/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence;

import java.lang.ref.Cleaner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public final class LeakDetector {
    public static final LeakDetector INSTANCE = new LeakDetector();
    private static final Bundle BUNDLE = FrameworkUtil.getBundle(LeakDetector.class);
    private static final ILog LOG = Platform.getLog((Bundle)BUNDLE);
    private final Cleaner cleaner = Cleaner.create();

    public Runnable register(Object shouldBeClosed) {
        Handle handle = new Handle(shouldBeClosed.toString());
        this.cleaner.register(shouldBeClosed, handle);
        return handle::close;
    }

    private LeakDetector() {
    }

    private static class Handle
    implements Runnable {
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Exception allocationTrace;

        public Handle(String name) {
            this.allocationTrace = new RuntimeException(name + " allocated here is not closed.");
        }

        public void close() {
            this.closed.set(true);
        }

        @Override
        public void run() {
            if (!this.closed.get()) {
                LOG.log((IStatus)new Status(4, BUNDLE.getSymbolicName(), "", (Throwable)this.allocationTrace));
            }
        }
    }
}

