/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.util.AnnotationScanner;
import org.eclipse.jdt.apt.core.internal.util.InputStreamAnnotationScanner;
import org.eclipse.jdt.apt.core.internal.util.ReaderAnnotationScanner;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;

public class ScannerUtil {
    private static final String[] SINGLE_BYTE_ENCODING_ARRAY = new String[]{"ASCII", "Cp1250", "Cp1251", "Cp1252", "Cp1253", "Cp1254", "Cp1257", "ISO8859_1", "ISO8859_2", "ISO8859_4", "ISO8859_5", "ISO8859_7", "ISO8859_9", "ISO8859_13", "ISO8859_15", "UTF8"};
    private static final Set<String> SINGLE_BYTE_ENCODINGS = Stream.of(SINGLE_BYTE_ENCODING_ARRAY).collect(Collectors.toSet());

    /*
     * Loose catch block
     */
    public static boolean hasAnnotationInstance(IFile f) {
        boolean bl;
        InputStream input;
        InputStreamReader reader;
        block23: {
            AnnotationScanner scanner;
            reader = null;
            input = null;
            if (SINGLE_BYTE_ENCODINGS.contains(f.getCharset())) {
                input = BuildEnv.getInputStream(f);
                scanner = new InputStreamAnnotationScanner(input);
            } else {
                reader = BuildEnv.getFileReader(f);
                scanner = new ReaderAnnotationScanner(reader);
            }
            bl = scanner.containsAnnotations();
            if (reader == null) break block23;
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception ioe) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static boolean hasAnnotationInstance(ICompilationUnit cu) {
        IBuffer b;
        block3: {
            try {
                b = cu.getBuffer();
                if (b != null) break block3;
                return false;
            }
            catch (JavaModelException jme) {
                return false;
            }
        }
        char[] source = b.getCharacters();
        return ScannerUtil.hasAnnotationInstance(source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasAnnotationInstance(char[] source) {
        try {
            if (source == null) {
                return false;
            }
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)"1.5");
            scanner.setSource(source);
            int token = scanner.getNextToken();
            do {
                if (token != 158) continue;
                return false;
            } while ((token = scanner.getNextToken()) != 401 || (token = scanner.getNextToken()) == 180);
            return true;
        }
        catch (InvalidInputException iie) {
            return false;
        }
        catch (Exception e) {
            AptPlugin.log(e, "Failure scanning source: \n" + new String(source));
            return false;
        }
    }
}

