/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.wizards.NewContextWizard;
import org.eclipse.rcptt.ui.wizards.NewQ7ProjectWizard;
import org.eclipse.rcptt.ui.wizards.NewScenarioWizard;
import org.eclipse.rcptt.ui.wizards.NewVerificationWizard;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DialogUtil {
    private static IProject workingProject = null;

    public static ITestCase openNewScenarioDialog(Shell shell, boolean openEditor) {
        return DialogUtil.openNewScenarioDialog(shell, openEditor, null);
    }

    public static ITestCase openNewScenarioDialog(Shell shell, boolean openEditor, IQ7Folder folder) {
        Assert.isNotNull((Object)shell);
        NewScenarioWizard wizard = new NewScenarioWizard();
        wizard.setOpenEditor(openEditor);
        IStructuredSelection selection = DialogUtil.getWorkingProjectSelection(shell);
        if (folder != null) {
            selection = new StructuredSelection((Object)folder.getResource());
        }
        if (selection.isEmpty()) {
            return null;
        }
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            workingProject = wizard.getProject();
            return wizard.getScenario();
        }
        return null;
    }

    public static IContext openNewContextDialog(Shell shell, boolean takeSnapshot, ContextType defaultType) {
        Assert.isNotNull((Object)shell);
        NewContextWizard wizard = new NewContextWizard();
        wizard.setTakeSnapshot(takeSnapshot);
        wizard.setDefaultType(defaultType);
        IStructuredSelection selection = DialogUtil.getWorkingProjectSelection(shell);
        if (selection.isEmpty()) {
            return null;
        }
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            workingProject = wizard.getProject();
            return wizard.getContext();
        }
        return null;
    }

    public static IVerification openNewVerificationDialog(Shell shell, boolean takeSnapshot) {
        return DialogUtil.openNewVerificationDialog(shell, takeSnapshot, null, null, null);
    }

    public static IVerification openNewVerificationDialog(Shell shell, boolean takeSnapshot, VerificationType type, String widgetClass, String selector) {
        Assert.isNotNull((Object)shell);
        NewVerificationWizard wizard = new NewVerificationWizard(type, widgetClass, selector);
        wizard.setTakeSnapshot(takeSnapshot);
        IStructuredSelection selection = DialogUtil.getWorkingProjectSelection(shell);
        if (selection.isEmpty()) {
            return null;
        }
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            workingProject = wizard.getProject();
            return wizard.getVerification();
        }
        return null;
    }

    private static IStructuredSelection getWorkingProjectSelection(Shell shell) {
        return DialogUtil.createProjectSelection(DialogUtil.getWorkingProject(shell));
    }

    private static IProject getWorkingProject(Shell shell) {
        IStructuredSelection ss = DialogUtil.getCurrentSelection();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project;
            IResource res;
            Object o = objectArray[n2];
            if (o instanceof IResource) {
                IProject project2 = ((IResource)o).getProject();
                if (project2.isAccessible()) {
                    workingProject = project2;
                    return workingProject;
                }
            } else if (o instanceof IEditorPart && (res = (IResource)((IEditorPart)o).getAdapter(IResource.class)) != null && (project = res.getProject()).isAccessible()) {
                workingProject = project;
                return workingProject;
            }
            ++n2;
        }
        if (workingProject != null && workingProject.isAccessible()) {
            return workingProject;
        }
        RcpttCore.getInstance();
        IProject[] projects = RcpttCore.getQ7Projects();
        if (projects.length > 0 && projects[0].isAccessible()) {
            workingProject = projects[0];
            return workingProject;
        }
        workingProject = DialogUtil.openNewQ7ProjectDialog(shell);
        return workingProject;
    }

    private static IProject openNewQ7ProjectDialog(Shell shell) {
        MessageBox msg = new MessageBox(shell, 288);
        msg.setText(shell.getText());
        msg.setMessage(Messages.DialogUtil_NewQ7ProjectDialogMsg);
        if (msg.open() == 32) {
            NewQ7ProjectWizard wizard = new NewQ7ProjectWizard();
            IWorkbench workbench = PlatformUI.getWorkbench();
            wizard.init(workbench, (IStructuredSelection)new StructuredSelection((Object)ResourcesPlugin.getWorkspace().getRoot()));
            wizard.setWindowTitle(Messages.DialogUtil_NewQ7ProjectDialogTitle);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() == 0) {
                return wizard.getNewProject();
            }
        }
        return null;
    }

    private static IStructuredSelection getCurrentSelection() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IEditorPart) {
                return new StructuredSelection((Object)part);
            }
            if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)provider.getSelection();
            }
        }
        return StructuredSelection.EMPTY;
    }

    private static IStructuredSelection createProjectSelection(IProject project) {
        return project == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)project);
    }
}

