/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.swt.peg.rules;

import java.util.List;
import org.eclipse.rcptt.tesla.core.protocol.DragCommand;
import org.eclipse.rcptt.tesla.core.protocol.DragKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.ApplicationResult;
import org.eclipse.rcptt.tesla.recording.core.swt.peg.ProcessingRule;

public class KeepOnlyLastDragSetData
extends ProcessingRule {
    @Override
    public boolean matches(List<Command> commands) {
        if (!(KeepOnlyLastDragSetData.get(-1, commands) instanceof DragCommand)) {
            return false;
        }
        DragCommand dragCommand = (DragCommand)KeepOnlyLastDragSetData.get(-1, commands);
        return dragCommand.getKind() == DragKind.SET_DATA;
    }

    @Override
    public ApplicationResult apply(List<Command> commands) {
        int i = commands.size() - 2;
        while (i >= 0) {
            Command c = commands.get(i);
            if (c instanceof DragCommand) {
                DragCommand dragCommand = (DragCommand)c;
                switch (dragCommand.getKind()) {
                    case SET_DATA: {
                        return new ApplicationResult().remove(i);
                    }
                    case START: {
                        return new ApplicationResult();
                    }
                }
            }
            --i;
        }
        return new ApplicationResult();
    }
}

