/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.info;

import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.InfoNode;
import org.eclipse.rcptt.tesla.core.info.NodeProperty;

public class InfoUtils {
    public static InfoNode node(String name) {
        InfoNode node = InfoFactory.eINSTANCE.createInfoNode();
        if (name.contains("]]>")) {
            name = name.replace("]]>", "{q7.replace.CDATA_END}");
        }
        node.setName(name);
        return node;
    }

    public static NodeProperty property(String name, String value) {
        NodeProperty property = InfoFactory.eINSTANCE.createNodeProperty();
        if (name.contains("]]>")) {
            name = name.replace("]]>", "{q7.replace.CDATA_END}");
        }
        property.setName(name);
        if (value != null && value.contains("]]>")) {
            value = value.replace("]]>", "{q7.replace.CDATA_END}");
        }
        property.setValue(value);
        return property;
    }

    public static void property(InfoNode node, String name, String value) {
        node.getProperties().add((Object)InfoUtils.property(name, value));
    }

    public static Node newNode(String name) {
        return new Node(InfoUtils.node(name));
    }

    public static class Node {
        private InfoNode node;

        Node(InfoNode node) {
            this.node = node;
        }

        public Node property(String name, String value) {
            InfoUtils.property(this.node, name, value);
            return this;
        }

        public Node property(String name, Object value) {
            InfoUtils.property(this.node, name, value.toString());
            return this;
        }

        public Node add(AdvancedInformation info) {
            info.getNodes().add((Object)this.node);
            return this;
        }

        public Node child(String name) {
            InfoNode childNode = InfoUtils.node(name);
            this.node.getChildren().add((Object)childNode);
            return new Node(childNode);
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

