/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.core.BackgroundEventHandler;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.SubscriberResourceCollector;
import org.osgi.service.prefs.Preferences;

public class SubscriberChangeSetManager
extends ActiveChangeSetManager {
    private static final String PREF_CHANGE_SETS = "changeSets";
    private static final int RESOURCE_REMOVAL = 1;
    private static final int RESOURCE_CHANGE = 2;
    private final EventHandler handler;
    private final ResourceCollector collector;

    public SubscriberChangeSetManager(Subscriber subscriber) {
        this.collector = new ResourceCollector(subscriber);
        this.handler = new EventHandler(NLS.bind((String)Messages.SubscriberChangeSetCollector_1, (Object[])new String[]{subscriber.getName()}), NLS.bind((String)Messages.SubscriberChangeSetCollector_2, (Object[])new String[]{subscriber.getName()}));
    }

    @Override
    protected void initializeSets() {
        this.load(this.getPreferences());
    }

    public boolean hasMembers(IResource resource) {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet s = changeSetArray[n2];
            ActiveChangeSet set = (ActiveChangeSet)s;
            if (set.getDiffTree().getChildren(resource.getFullPath()).length > 0) {
                return true;
            }
            ++n2;
        }
        if (this.getDefaultSet() != null) {
            return this.getDefaultSet().getDiffTree().getChildren(resource.getFullPath()).length > 0;
        }
        return false;
    }

    @Override
    public IDiff getDiff(IResource resource) throws CoreException {
        Subscriber subscriber = this.getSubscriber();
        return subscriber.getDiff(resource);
    }

    public Subscriber getSubscriber() {
        return this.collector.getSubscriber();
    }

    @Override
    public void dispose() {
        this.handler.shutdown();
        this.collector.dispose();
        super.dispose();
        this.save(this.getPreferences());
    }

    private Preferences getPreferences() {
        return SubscriberChangeSetManager.getParentPreferences().node(this.getSubscriberIdentifier());
    }

    private static Preferences getParentPreferences() {
        return SubscriberChangeSetManager.getTeamPreferences().node(PREF_CHANGE_SETS);
    }

    private static Preferences getTeamPreferences() {
        return InstanceScope.INSTANCE.getNode(TeamPlugin.getPlugin().getBundle().getSymbolicName());
    }

    protected String getSubscriberIdentifier() {
        return this.getSubscriber().getName();
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        monitor.worked(1);
        while (this.handler.getEventHandlerJob().getState() != 0) {
            monitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Policy.checkCanceled(monitor);
        }
        monitor.worked(1);
    }

    @Override
    protected String getName() {
        return this.getSubscriber().getName();
    }

    private class EventHandler
    extends BackgroundEventHandler {
        private final List<BackgroundEventHandler.Event> dispatchEvents;

        protected EventHandler(String jobName, String errorTitle) {
            super(jobName, errorTitle);
            this.dispatchEvents = new ArrayList<BackgroundEventHandler.Event>();
        }

        @Override
        protected void processEvent(BackgroundEventHandler.Event event, IProgressMonitor monitor) throws CoreException {
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            this.dispatchEvents.add(event);
        }

        @Override
        protected boolean doDispatchEvents(IProgressMonitor monitor) throws TeamException {
            if (this.dispatchEvents.isEmpty()) {
                return false;
            }
            if (this.isShutdown()) {
                throw new OperationCanceledException();
            }
            ResourceDiffTree[] locked = null;
            try {
                try {
                    locked = this.beginDispath();
                    for (BackgroundEventHandler.Event event : this.dispatchEvents) {
                        switch (event.getType()) {
                            case 1: {
                                this.handleRemove(event.getResource());
                                break;
                            }
                            case 2: {
                                this.handleChange(event.getResource(), ((BackgroundEventHandler.ResourceEvent)event).getDepth());
                                break;
                            }
                        }
                        if (!this.isShutdown()) continue;
                        throw new OperationCanceledException();
                    }
                }
                catch (CoreException e) {
                    throw TeamException.asTeamException(e);
                }
            }
            finally {
                try {
                    this.endDispatch(locked, monitor);
                }
                finally {
                    this.dispatchEvents.clear();
                }
            }
            return true;
        }

        private ResourceDiffTree[] beginDispath() {
            ChangeSet[] sets = SubscriberChangeSetManager.this.getSets();
            ArrayList<ResourceDiffTree> lockedSets = new ArrayList<ResourceDiffTree>();
            try {
                ChangeSet[] changeSetArray = sets;
                int n = sets.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeSet s = changeSetArray[n2];
                    ActiveChangeSet set = (ActiveChangeSet)s;
                    ResourceDiffTree tree = set.internalGetDiffTree();
                    lockedSets.add(tree);
                    tree.beginInput();
                    ++n2;
                }
                return lockedSets.toArray(new ResourceDiffTree[lockedSets.size()]);
            }
            catch (RuntimeException e) {
                try {
                    for (ResourceDiffTree tree : lockedSets) {
                        try {
                            tree.endInput(null);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }

        private void endDispatch(ResourceDiffTree[] locked, IProgressMonitor monitor) {
            if (locked == null) {
                return;
            }
            monitor.beginTask(null, 100 * locked.length);
            ResourceDiffTree[] resourceDiffTreeArray = locked;
            int n = locked.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceDiffTree tree = resourceDiffTreeArray[n2];
                try {
                    tree.endInput(Policy.subMonitorFor(monitor, 100));
                }
                catch (RuntimeException e) {
                    TeamPlugin.log(4, Messages.SubscriberChangeSetCollector_0, e);
                    throw e;
                }
                ++n2;
            }
            monitor.done();
        }

        @Override
        protected synchronized void queueEvent(BackgroundEventHandler.Event event, boolean front) {
            super.queueEvent(event, front);
        }

        private void handleRemove(IResource resource) {
            ChangeSet[] sets;
            ChangeSet[] changeSetArray = sets = SubscriberChangeSetManager.this.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet set = changeSetArray[n2];
                if (!set.isEmpty()) {
                    set.rootRemoved(resource, 2);
                    if (set.isEmpty()) {
                        SubscriberChangeSetManager.this.remove(set);
                    }
                }
                ++n2;
            }
        }

        private void handleChange(IResource resource, int depth) throws CoreException {
            int n;
            int n2;
            ActiveChangeSet[] activeChangeSetArray;
            IDiff diff = SubscriberChangeSetManager.this.getDiff(resource);
            if (SubscriberChangeSetManager.this.isModified(diff)) {
                ActiveChangeSet[] containingSets = this.getContainingSets(resource);
                if (containingSets.length == 0) {
                    if (SubscriberChangeSetManager.this.getDefaultSet() != null) {
                        SubscriberChangeSetManager.this.getDefaultSet().add(diff);
                    }
                } else {
                    activeChangeSetArray = containingSets;
                    n2 = containingSets.length;
                    n = 0;
                    while (n < n2) {
                        ActiveChangeSet set = activeChangeSetArray[n];
                        set.add(diff);
                        ++n;
                    }
                }
            } else {
                this.removeFromAllSets(resource);
            }
            if (depth != 0) {
                IResource[] members = SubscriberChangeSetManager.this.getSubscriber().members(resource);
                activeChangeSetArray = members;
                n2 = members.length;
                n = 0;
                while (n < n2) {
                    ActiveChangeSet member = activeChangeSetArray[n];
                    this.handleChange((IResource)member, depth == 1 ? 0 : 2);
                    ++n;
                }
            }
        }

        private void removeFromAllSets(IResource resource) {
            ChangeSet[] sets;
            ArrayList<ChangeSet> toRemove = new ArrayList<ChangeSet>();
            ChangeSet[] changeSetArray = sets = SubscriberChangeSetManager.this.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet set = changeSetArray[n2];
                if (set.contains(resource)) {
                    set.remove(resource);
                    if (set.isEmpty()) {
                        toRemove.add(set);
                    }
                }
                ++n2;
            }
            for (ChangeSet set : toRemove) {
                SubscriberChangeSetManager.this.remove(set);
            }
        }

        private ActiveChangeSet[] getContainingSets(IResource resource) {
            ChangeSet[] sets;
            HashSet<ActiveChangeSet> result = new HashSet<ActiveChangeSet>();
            ChangeSet[] changeSetArray = sets = SubscriberChangeSetManager.this.getSets();
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                ChangeSet set = changeSetArray[n2];
                if (set.contains(resource)) {
                    result.add((ActiveChangeSet)set);
                }
                ++n2;
            }
            return result.toArray(new ActiveChangeSet[result.size()]);
        }
    }

    private class ResourceCollector
    extends SubscriberResourceCollector {
        public ResourceCollector(Subscriber subscriber) {
            super(subscriber);
        }

        @Override
        protected void remove(IResource resource) {
            if (SubscriberChangeSetManager.this.handler != null) {
                SubscriberChangeSetManager.this.handler.queueEvent(new BackgroundEventHandler.ResourceEvent(resource, 1, 2), false);
            }
        }

        @Override
        protected void change(IResource resource, int depth) {
            if (SubscriberChangeSetManager.this.handler != null) {
                SubscriberChangeSetManager.this.handler.queueEvent(new BackgroundEventHandler.ResourceEvent(resource, 2, depth), false);
            }
        }

        @Override
        protected boolean hasMembers(IResource resource) {
            return SubscriberChangeSetManager.this.hasMembers(resource);
        }
    }
}

