/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.search.IIndexRequestor;
import org.eclipse.rcptt.core.model.search.ISearchPattern;
import org.eclipse.rcptt.core.model.search.SearchPattern;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.QueryResult;

public class AllContextWithLinksQueryPattern
implements ISearchPattern {
    final Set<IPath> linksFilterPaths;

    public AllContextWithLinksQueryPattern() {
        this.linksFilterPaths = new HashSet<IPath>();
    }

    public AllContextWithLinksQueryPattern(Set<IPath> linksFilterPaths) {
        this.linksFilterPaths = linksFilterPaths;
    }

    @Override
    public void findIndexMatches(Index index, IProgressMonitor monitor, IIndexRequestor requestor) {
        IPath path = index.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        List<QueryResult> list = index.query(new String[]{"ws_link"}, new SearchPattern.IKeyQuery(){

            @Override
            public boolean accept(String key, String value) {
                if (AllContextWithLinksQueryPattern.this.linksFilterPaths.isEmpty()) {
                    return true;
                }
                Path path = new Path(value);
                return AllContextWithLinksQueryPattern.this.linksFilterPaths.contains(path);
            }
        }, monitor);
        for (QueryResult queryResult : list) {
            Path fullPath = new Path(queryResult.path);
            IResource res = root.findMember(path.append((IPath)fullPath));
            if (!res.exists()) continue;
            IQ7Element q7Element = RcpttCore.create(res);
            requestor.acceptMatch(q7Element, queryResult.key, queryResult.value);
        }
    }
}

