/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.filediff;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.op.DiscardChangesOperation;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CommandConfirmation;
import org.eclipse.egit.ui.internal.filediff.AbstractFileDiffHandler;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.handlers.HandlerUtil;

public class FileDiffCheckoutNewHandler
extends AbstractFileDiffHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        List<FileDiff> diffs = this.getDiffs(selection, d -> !d.isSubmodule() && !DiffEntry.ChangeType.DELETE.equals((Object)d.getChange()));
        if (!diffs.isEmpty()) {
            FileDiff first = diffs.get(0);
            Repository repository = first.getRepository();
            String revision = first.getCommit().getName();
            List paths = diffs.stream().map(FileDiff::getNewPath).collect(Collectors.toList());
            DiscardChangesOperation operation = new DiscardChangesOperation(repository, paths);
            operation.setRevision(revision);
            if (CommandConfirmation.confirmCheckout(HandlerUtil.getActiveShellChecked((ExecutionEvent)event), operation.getPathsPerRepository(), true)) {
                JobUtil.scheduleUserWorkspaceJob((IEGitOperation)operation, (String)UIText.DiscardChangesAction_discardChanges, (Object)JobFamilies.DISCARD_CHANGES);
            }
        }
        return null;
    }
}

