/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.utils;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WorkbenchUtils {
    public static Shell getShell() {
        IWorkbenchWindow wbw = WorkbenchUtils.getWindow();
        if (wbw == null) {
            return null;
        }
        return wbw.getShell();
    }

    public static IWorkbenchPage getPage() {
        IWorkbenchWindow ww = WorkbenchUtils.getWindow();
        return ww == null ? null : ww.getActivePage();
    }

    public static IWorkbenchWindow getWindow() {
        IWorkbench wb = WorkbenchUtils.getWorkbench();
        return wb == null ? null : wb.getActiveWorkbenchWindow();
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static Display getDisplay() {
        return WorkbenchUtils.getWorkbench().getDisplay();
    }

    public static void uiRun(Runnable runnable) {
        WorkbenchUtils.uiRun(null, runnable);
    }

    public static void uiRun(final Control control, final Runnable runnable) {
        Display display;
        if (control != null && control.isDisposed()) {
            return;
        }
        Display display2 = display = control == null ? WorkbenchUtils.getDisplay() : control.getDisplay();
        if (!display.isDisposed()) {
            if (display.getThread() == Thread.currentThread()) {
                runnable.run();
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (control == null || !control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            }
        }
    }
}

