/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.EclipsePluginValidationOperation;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchConfigurationHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.osgi.framework.Version;

public abstract class AbstractPDELaunchConfiguration
extends LaunchConfigurationDelegate {
    protected File fConfigDir = null;
    String launchMode;
    @Deprecated
    public static boolean shouldVMAddModuleSystem = false;
    private static final String PDE_LAUNCH_SHOW_COMMAND = "pde.launch.showcommandline";

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        return super.isLaunchProblem(problemMarker) && (problemMarker.isSubtypeOf("org.eclipse.jdt.core.problem") || problemMarker.isSubtypeOf("org.eclipse.pde.core.problem"));
    }

    public String showCommandLine(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String commandLine = "";
        launch.setAttribute(PDE_LAUNCH_SHOW_COMMAND, "true");
        this.fConfigDir = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        try {
            this.preLaunchCheck(configuration, launch, (IProgressMonitor)subMonitor.split(2));
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                subMonitor.setCanceled(true);
                return commandLine;
            }
            throw e;
        }
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration(this.getMainClass(), this.getClasspath(configuration));
        IVMInstall launcher = VMHelper.createLauncher(configuration);
        runnerConfig.setVMArguments(this.updateVMArgumentWithAdditionalArguments(this.getVMArguments(configuration), launcher));
        runnerConfig.setProgramArguments(this.getProgramArguments(configuration));
        runnerConfig.setWorkingDirectory(this.getWorkingDirectory(configuration).getAbsolutePath());
        runnerConfig.setEnvironment(this.getEnvironment(configuration));
        runnerConfig.setVMSpecificAttributesMap(this.getVMSpecificAttributesMap(configuration));
        subMonitor.worked(1);
        this.setDefaultSourceLocator(configuration);
        this.manageLaunch(launch);
        IVMRunner runner = this.getVMRunner(configuration, mode);
        if (runner != null) {
            commandLine = runner.showCommandLine(runnerConfig, launch, (IProgressMonitor)subMonitor);
        } else {
            subMonitor.setCanceled(true);
        }
        return commandLine;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.fConfigDir = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.preLaunchCheck(configuration, launch, (IProgressMonitor)subMonitor.split(50));
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                subMonitor.setCanceled(true);
                return;
            }
            throw e;
        }
        VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration(this.getMainClass(), this.getClasspath(configuration));
        IVMInstall launcher = VMHelper.createLauncher(configuration);
        runnerConfig.setVMArguments(this.updateVMArgumentWithAdditionalArguments(this.getVMArguments(configuration), launcher));
        runnerConfig.setProgramArguments(this.getProgramArguments(configuration));
        runnerConfig.setWorkingDirectory(this.getWorkingDirectory(configuration).getAbsolutePath());
        runnerConfig.setEnvironment(this.getEnvironment(configuration));
        runnerConfig.setVMSpecificAttributesMap(this.getVMSpecificAttributesMap(configuration));
        subMonitor.worked(25);
        this.setDefaultSourceLocator(configuration);
        this.manageLaunch(launch);
        IVMRunner runner = this.getVMRunner(configuration, mode);
        if (runner != null) {
            runner.run(runnerConfig, launch, (IProgressMonitor)subMonitor.split(25));
        } else {
            subMonitor.setCanceled(true);
        }
    }

    private String[] updateVMArgumentWithAdditionalArguments(String[] args, IVMInstall vmInstall) {
        AbstractVMInstall install;
        String vmver;
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        boolean isModular = JavaRuntime.isModularJava((IVMInstall)vmInstall);
        if (isModular) {
            VMHelper.addNewArgument(arguments, "--add-modules", "ALL-SYSTEM");
        }
        if (this.isEclipseBundleGreaterThanVersion(4, 24) && vmInstall instanceof AbstractVMInstall && (vmver = (install = (AbstractVMInstall)vmInstall).getJavaVersion()) != null && JavaCore.compareJavaVersions((String)vmver, (String)"17") >= 0 && JavaCore.compareJavaVersions((String)vmver, (String)"23") <= 0) {
            VMHelper.addNewArgument(arguments, "-Djava.security.manager", "allow");
        }
        if (!isModular) {
            arguments.remove("--add-modules=ALL-SYSTEM");
        }
        return (String[])arguments.toArray(String[]::new);
    }

    private boolean isEclipseBundleGreaterThanVersion(int major, int minor) {
        PDEState pdeState = TargetPlatformHelper.getPDEState();
        if (pdeState != null) {
            try {
                Optional<BundleDescription> model = Arrays.stream(pdeState.getTargetModels()).map(IPluginModelBase::getBundleDescription).filter(Objects::nonNull).filter(x -> "org.eclipse.platform".equals(x.getSymbolicName())).findFirst();
                return model.map(BaseDescription::getVersion).filter(v -> v.compareTo(new Version(major, minor, 0)) >= 0).isPresent();
            }
            catch (Exception ex) {
                PDELaunchingPlugin.log(ex);
            }
        }
        return false;
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IVMInstall launcher = VMHelper.createLauncher(configuration);
        return launcher.getVMRunner(mode);
    }

    protected void setDefaultSourceLocator(ILaunchConfiguration configuration) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = null;
        wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
        String id = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        if (!"org.eclipse.pde.ui.workbenchClasspathProvider".equals(id)) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
            wc.doSave();
        }
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        String[] classpath = LaunchArgumentsHelper.constructClasspath(configuration);
        if (classpath == null) {
            String message = PDEMessages.WorkbenchLauncherConfigurationDelegate_noStartup;
            throw new CoreException(Status.error((String)message));
        }
        return classpath;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getWorkingDirectory(configuration);
    }

    public Map<String, Object> getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        return LaunchArgumentsHelper.getVMSpecificAttributesMap(configuration);
    }

    public String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        return new ExecutionArguments(LaunchArgumentsHelper.getUserVMArguments(configuration), "").getVMArgumentsArray();
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> programArgs = new ArrayList<String>();
        if (configuration.getAttribute("tracing", false) && !"[NONE]".equals(configuration.getAttribute("checked", null))) {
            programArgs.add("-debug");
            programArgs.add(LaunchArgumentsHelper.getTracingFileArgument(configuration, this.getConfigDir(configuration).toPath().resolve(".options")));
        }
        String[] userArgs = LaunchArgumentsHelper.getUserProgramArgumentArray(configuration);
        ArrayList<String> userDefined = new ArrayList<String>();
        String[] stringArray = userArgs;
        int n = userArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String userArg = stringArray[n2];
            if (!userArg.equals("-debug") || !programArgs.contains("-debug")) {
                userDefined.add(userArg);
            }
            ++n2;
        }
        if (!configuration.getAttribute("append.args", false)) {
            if (!userDefined.contains("-os")) {
                programArgs.add("-os");
                programArgs.add(TargetPlatform.getOS());
            }
            if (!userDefined.contains("-ws")) {
                programArgs.add("-ws");
                programArgs.add(TargetPlatform.getWS());
            }
            if (!userDefined.contains("-arch")) {
                programArgs.add("-arch");
                programArgs.add(TargetPlatform.getOSArch());
            }
        }
        if (!userDefined.isEmpty()) {
            programArgs.addAll(userDefined);
        }
        return programArgs.toArray(new String[programArgs.size()]);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        boolean autoValidate;
        this.launchMode = launch.getLaunchMode();
        String attribute = launch.getAttribute(PDE_LAUNCH_SHOW_COMMAND);
        boolean isShowCommand = false;
        if (attribute != null) {
            isShowCommand = attribute.equals("true");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((autoValidate = configuration.getAttribute("automaticValidate", false)) ? 30 : 40));
        if (!isShowCommand) {
            if (autoValidate) {
                this.validatePluginDependencies(configuration, (IProgressMonitor)subMonitor.split(10));
            }
            this.validateProjectDependencies(configuration, (IProgressMonitor)subMonitor.split(10));
            this.clear(configuration, (IProgressMonitor)subMonitor.split(10));
        }
        launch.setAttribute(PDE_LAUNCH_SHOW_COMMAND, "false");
        launch.setAttribute("configLocation", this.getConfigDir(configuration).toString());
        this.synchronizeManifests(configuration, (IProgressMonitor)subMonitor.split(10));
    }

    protected File getConfigDir(ILaunchConfiguration configuration) {
        if (this.fConfigDir == null) {
            this.fConfigDir = LaunchConfigurationHelper.getConfigurationArea(configuration);
        }
        return this.fConfigDir;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.computeBuildOrder(LaunchPluginValidator.getAffectedProjects(configuration));
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return LaunchPluginValidator.getAffectedProjects(configuration);
    }

    public String getMainClass() {
        if (TargetPlatformHelper.getTargetVersion() >= 3.3) {
            return "org.eclipse.equinox.launcher.Main";
        }
        return "org.eclipse.core.launcher.Main";
    }

    protected void manageLaunch(ILaunch launch) {
        PDELaunchingPlugin.getDefault().getLaunchListener().manage(launch);
    }

    protected void synchronizeManifests(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LaunchConfigurationHelper.synchronizeManifests(configuration, this.getConfigDir(configuration));
        monitor.done();
    }

    protected void validateProjectDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) {
        LauncherUtils.validateProjectDependencies(configuration, monitor);
    }

    protected void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
    }

    protected void validatePluginDependencies(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        Set<IPluginModelBase> models = BundleLauncherHelper.getMergedBundleMap(configuration, false).keySet();
        EclipsePluginValidationOperation op = new EclipsePluginValidationOperation(configuration, models, this.launchMode);
        LaunchPluginValidator.runValidationOperation(op, monitor);
    }

    @Deprecated
    public static void updatePDELaunchConfigModuleSystem(boolean java9) {
    }
}

