/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards.imports;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;

public class ProjectRecord {
    public File projectSystemFile;
    public Object projectArchiveFile;
    String projectName;
    public Object parent;
    public int level;
    boolean hasConflicts;
    public IProjectDescription description;
    ILeveledImportStructureProvider structureProvider;

    ProjectRecord(File file) {
        this.projectSystemFile = file;
        this.setProjectName();
    }

    public ProjectRecord(ILeveledImportStructureProvider structureProvider, Object file, Object parent, int level) {
        this.structureProvider = structureProvider;
        this.projectArchiveFile = file;
        this.parent = parent;
        this.level = level;
        this.setProjectName();
    }

    private void setProjectName() {
        try {
            if (this.projectArchiveFile != null) {
                InputStream stream = this.structureProvider.getContents(this.projectArchiveFile);
                if (stream == null) {
                    if (this.projectArchiveFile instanceof ZipEntry) {
                        Path path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                        this.projectName = path.segment(path.segmentCount() - 2);
                    } else if (this.projectArchiveFile instanceof TarEntry) {
                        Path path = new Path(((TarEntry)this.projectArchiveFile).getName());
                        this.projectName = path.segment(path.segmentCount() - 2);
                    }
                } else {
                    this.description = ResourcesPlugin.getWorkspace().loadProjectDescription(stream);
                    stream.close();
                    this.projectName = this.description.getName();
                }
            }
            if (this.projectName == null) {
                Path path = new Path(this.projectSystemFile.getPath());
                if (this.isDefaultLocation((IPath)path)) {
                    this.projectName = path.segment(path.segmentCount() - 2);
                    this.description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
                } else {
                    this.description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
                    this.projectName = this.description.getName();
                }
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean isDefaultLocation(IPath path) {
        if (path.segmentCount() < 2) {
            return false;
        }
        return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectLabel() {
        if (this.description == null) {
            return this.projectName;
        }
        String path = this.projectSystemFile == null ? this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
        return NLS.bind((String)Messages.ProjectRecord_ProjectLabelFormat, (Object)this.projectName, (Object)path);
    }

    public boolean hasConflicts() {
        return this.hasConflicts;
    }
}

