/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.panels.assertion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.ui.panels.assertion.AssertGroup;

public class AssertInput {
    private static final List<AssertGroup> empty_list = new ArrayList<AssertGroup>();
    public static final AssertInput EMPTY = new AssertInput(empty_list, null);
    private final List<AssertGroup> asserts;
    private final Map<Object, AssertGroup> parents = new HashMap<Object, AssertGroup>();
    private Element element;

    private void indexChildren(AssertGroup group) {
        for (Object a : group.getAsserts()) {
            this.parents.put(a, group);
            if (!(a instanceof AssertGroup)) continue;
            this.indexChildren((AssertGroup)a);
        }
    }

    public AssertInput(List<AssertGroup> asserts, Element element) {
        this.asserts = asserts;
        this.element = element;
        this.reindex();
    }

    public Element getElement() {
        return this.element;
    }

    public void reindex() {
        this.parents.clear();
        for (AssertGroup group : this.asserts) {
            this.indexChildren(group);
        }
    }

    public AssertGroup getParent(Object a) {
        return this.parents.get(a);
    }

    public List<AssertGroup> getAsserts() {
        return this.asserts;
    }
}

