/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.framelist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.framelist.Frame;

public class TreeFrame
extends Frame {
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_FRAME_INPUT = "frameInput";
    private static final String TAG_FACTORY_ID = "factoryID";
    private final AbstractTreeViewer viewer;
    private Object input;
    private ISelection selection;
    private Object[] expandedElements;

    public TreeFrame(AbstractTreeViewer viewer) {
        this.viewer = viewer;
    }

    public TreeFrame(AbstractTreeViewer viewer, Object input) {
        this(viewer);
        this.setInput(input);
        ILabelProvider provider = (ILabelProvider)viewer.getLabelProvider();
        String name = provider.getText(input);
        if (name == null) {
            name = "";
        }
        this.setName(name);
        this.setToolTipText(name);
    }

    public Object[] getExpandedElements() {
        return this.expandedElements;
    }

    public Object getInput() {
        return this.input;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public AbstractTreeViewer getViewer() {
        return this.viewer;
    }

    private List<IAdaptable> restoreElements(IMemento memento) {
        IMemento[] elementMem = memento.getChildren(TAG_ELEMENT);
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(elementMem.length);
        IMemento[] iMementoArray = elementMem;
        int n = elementMem.length;
        int n2 = 0;
        while (n2 < n) {
            IElementFactory factory;
            IMemento element = iMementoArray[n2];
            String factoryID = element.getString(TAG_FACTORY_ID);
            if (factoryID != null && (factory = PlatformUI.getWorkbench().getElementFactory(factoryID)) != null) {
                elements.add(factory.createElement(element));
            }
            ++n2;
        }
        return elements;
    }

    public void restoreState(IMemento memento) {
        IMemento expandedMem;
        IElementFactory factory;
        IMemento childMem = memento.getChild(TAG_FRAME_INPUT);
        if (childMem == null) {
            return;
        }
        String factoryID = childMem.getString(TAG_FACTORY_ID);
        IAdaptable frameInput = null;
        if (factoryID != null && (factory = PlatformUI.getWorkbench().getElementFactory(factoryID)) != null) {
            frameInput = factory.createElement(childMem);
        }
        if (frameInput != null) {
            this.input = frameInput;
        }
        if ((expandedMem = memento.getChild(TAG_EXPANDED)) != null) {
            List<IAdaptable> elements = this.restoreElements(expandedMem);
            this.expandedElements = elements.toArray(new Object[elements.size()]);
        } else {
            this.expandedElements = new Object[0];
        }
        IMemento selectionMem = memento.getChild(TAG_SELECTION);
        if (selectionMem != null) {
            List<IAdaptable> elements = this.restoreElements(selectionMem);
            this.selection = new StructuredSelection(elements);
        } else {
            this.selection = StructuredSelection.EMPTY;
        }
    }

    private void saveElements(Object[] elements, IMemento memento) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IPersistableElement persistable = (IPersistableElement)Adapters.adapt((Object)element, IPersistableElement.class);
            if (persistable != null) {
                IMemento elementMem = memento.createChild(TAG_ELEMENT);
                elementMem.putString(TAG_FACTORY_ID, persistable.getFactoryId());
                persistable.saveState(elementMem);
            }
            ++n2;
        }
    }

    public void saveState(IMemento memento) {
        IPersistableElement persistable = (IPersistableElement)Adapters.adapt((Object)this.input, IPersistableElement.class);
        if (persistable != null) {
            Object[] elements;
            IMemento frameMemento = memento.createChild(TAG_FRAME_INPUT);
            frameMemento.putString(TAG_FACTORY_ID, persistable.getFactoryId());
            persistable.saveState(frameMemento);
            if (this.expandedElements.length > 0) {
                IMemento expandedMem = memento.createChild(TAG_EXPANDED);
                this.saveElements(this.expandedElements, expandedMem);
            }
            if (this.selection instanceof IStructuredSelection && (elements = ((IStructuredSelection)this.selection).toArray()).length > 0) {
                IMemento selectionMem = memento.createChild(TAG_SELECTION);
                this.saveElements(elements, selectionMem);
            }
        }
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setExpandedElements(Object[] expandedElements) {
        this.expandedElements = expandedElements;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

