/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage;

import org.eclipse.equinox.internal.security.storage.friends.ReEncrypter;
import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.ChangePasswordWizard;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ChangePasswordWizardDialog
extends WizardDialog {
    private final ReEncrypter reEncrypter;
    private boolean decryptedOK;
    private boolean recodeDone;

    public ChangePasswordWizardDialog(Shell parentShell, ISecurePreferences node, String moduleID) {
        super(parentShell, (IWizard)new ChangePasswordWizard());
        this.reEncrypter = new ReEncrypter(node, moduleID);
    }

    public boolean isDecryptedOK() {
        return this.decryptedOK;
    }

    public boolean isRecodeDone() {
        return this.recodeDone;
    }

    protected void nextPressed() {
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof ChangePasswordWizard.DecodePage) {
            if (!this.reEncrypter.decrypt()) {
                MessageBox messageBox = new MessageBox(this.getShell(), 200);
                messageBox.setText(SecUIMessages.changePasswordWizardTitle);
                messageBox.setMessage(SecUIMessages.wizardDecodeWarning);
                if (messageBox.open() == 64) {
                    this.setReturnCode(1);
                    this.close();
                    return;
                }
            }
        } else if (currentPage instanceof ChangePasswordWizard.EncodePage) {
            if (!this.reEncrypter.switchToNewPassword()) {
                MessageBox messageBox = new MessageBox(this.getShell(), 33);
                messageBox.setText(SecUIMessages.changePasswordWizardTitle);
                messageBox.setMessage(SecUIMessages.wizardSwitchError);
                messageBox.open();
                this.close();
                return;
            }
            this.reEncrypter.encrypt();
            this.recodeDone = true;
        }
        super.nextPressed();
    }
}

