/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.tweaklets;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class Tweaklets {
    private static Map<TweakKey, Object> defaults = new HashMap<TweakKey, Object>();
    private static Map<TweakKey, Object> tweaklets = new HashMap<TweakKey, Object>();

    public static void setDefault(TweakKey definition, Object implementation) {
        defaults.put(definition, implementation);
    }

    public static Object get(TweakKey definition) {
        Object result = tweaklets.get(definition);
        if (result == null) {
            result = Tweaklets.createTweaklet(definition);
            if (result == null) {
                result = Tweaklets.getDefault(definition);
            }
            Assert.isNotNull((Object)result);
            tweaklets.put(definition, result);
        }
        return result;
    }

    private static Object getDefault(TweakKey definition) {
        return defaults.get(definition);
    }

    private static Object createTweaklet(TweakKey definition) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.internalTweaklets");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (definition.tweakClass.getName().equals(element.getAttribute("definition"))) {
                try {
                    Object tweaklet = element.createExecutableExtension("implementation");
                    tweaklets.put(definition, tweaklet);
                    return tweaklet;
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(StatusUtil.newStatus(4, "Error with extension " + String.valueOf(element), (Throwable)e), 1);
                }
            }
            ++n2;
        }
        return null;
    }

    public static class TweakKey {
        Class<?> tweakClass;

        public TweakKey(Class<?> tweakClass) {
            this.tweakClass = tweakClass;
        }

        public int hashCode() {
            return Objects.hashCode(this.tweakClass);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TweakKey other = (TweakKey)obj;
            return Objects.equals(this.tweakClass, other.tweakClass);
        }
    }
}

