/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.widgets.Table;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    int scrollIndex;
    long scrollBeginTime;

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    @Override
    public void dragEnter(DropTargetEvent event) {
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    @Override
    public void dragLeave(DropTargetEvent event) {
        Table table = (Table)this.control;
        long handle = table.handle;
        GTK.gtk_tree_view_set_drag_dest_row(handle, 0L, 0);
        this.scrollBeginTime = 0L;
        this.scrollIndex = -1;
    }

    @Override
    public void dragOver(DropTargetEvent event) {
        long indices;
        Table table = (Table)this.control;
        long handle = table.handle;
        int effect = this.checkEffect(event.feedback);
        Point coordinates = new Point(event.x, event.y);
        coordinates = DPIUtil.autoScaleUp(table.toControl(coordinates));
        long[] path = new long[1];
        GTK.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
        int index = -1;
        if (path[0] != 0L && (indices = GTK.gtk_tree_path_get_indices(path[0])) != 0L) {
            int[] temp = new int[1];
            C.memmove(temp, indices, 4L);
            index = temp[0];
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (index != -1 && this.scrollIndex == index && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                if (coordinates.y < DPIUtil.autoScaleUp(table.getItemHeight())) {
                    GTK.gtk_tree_path_prev(path[0]);
                } else {
                    GTK.gtk_tree_path_next(path[0]);
                }
                if (path[0] != 0L) {
                    GTK.gtk_tree_view_scroll_to_cell(handle, path[0], 0L, false, 0.0f, 0.0f);
                    GTK.gtk_tree_path_free(path[0]);
                    path[0] = 0L;
                    GTK.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = index;
        }
        if (path[0] != 0L) {
            int position = -1;
            if ((effect & 1) != 0) {
                position = 2;
            }
            if ((effect & 2) != 0) {
                position = 0;
            }
            if ((effect & 4) != 0) {
                position = 1;
            }
            if (position != -1) {
                GTK.gtk_tree_view_set_drag_dest_row(handle, path[0], position);
            } else {
                GTK.gtk_tree_view_set_drag_dest_row(handle, 0L, 0);
            }
        } else {
            GTK.gtk_tree_view_set_drag_dest_row(handle, 0L, 0);
        }
        if (path[0] != 0L) {
            GTK.gtk_tree_path_free(path[0]);
        }
    }
}

