/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.text.NumberFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public abstract class SizeComputingWizardPage
extends ResolutionResultsWizardPage {
    protected Label sizeInfo;
    protected long size;
    Job sizingJob;
    private IProvisioningPlan lastComputedPlan = null;

    protected SizeComputingWizardPage(ProvisioningUI ui, ProvisioningOperationWizard wizard, IUElementListRoot root, ProfileChangeOperation initialResolution) {
        super(ui, wizard, root, initialResolution);
        if (initialResolution != null && initialResolution.hasResolved()) {
            this.computeSizing(initialResolution.getProvisioningPlan(), initialResolution.getProvisioningContext());
        } else {
            this.size = -3L;
        }
    }

    protected void computeSizing(final IProvisioningPlan plan, final ProvisioningContext provisioningContext) {
        if (plan == this.lastComputedPlan) {
            return;
        }
        this.lastComputedPlan = plan;
        this.size = -1L;
        this.updateSizingInfo();
        if (this.sizingJob != null) {
            this.sizingJob.cancel();
        }
        this.sizingJob = new Job(ProvUIMessages.SizeComputingWizardPage_SizeJobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                SizeComputingWizardPage.this.size = ProvUI.getSize(ProvUI.getEngine(SizeComputingWizardPage.this.getProvisioningUI().getSession()), plan, provisioningContext, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (SizeComputingWizardPage.this.display != null) {
                    SizeComputingWizardPage.this.display.asyncExec(() -> SizeComputingWizardPage.this.updateSizingInfo());
                }
                return Status.OK_STATUS;
            }
        };
        this.sizingJob.setUser(false);
        this.sizingJob.setSystem(true);
        this.sizingJob.setProperty(LoadMetadataRepositoryJob.SUPPRESS_AUTHENTICATION_JOB_MARKER, (Object)Boolean.toString(true));
        this.sizingJob.schedule();
    }

    @Override
    protected void createSizingInfo(Composite parent) {
        this.sizeInfo = new Label(parent, 0);
        GridData data = new GridData(4, 4, true, false);
        this.sizeInfo.setLayoutData((Object)data);
        this.updateSizingInfo();
    }

    protected void updateSizingInfo() {
        if (this.sizeInfo != null && !this.sizeInfo.isDisposed()) {
            if (this.size == -3L) {
                this.sizeInfo.setVisible(false);
            } else {
                this.sizeInfo.setText(NLS.bind((String)ProvUIMessages.UpdateOrInstallWizardPage_Size, (Object)this.getFormattedSize()));
                this.sizeInfo.setVisible(true);
            }
        }
    }

    protected String getFormattedSize() {
        if (this.size == -1L || this.size == -2L) {
            return ProvUIMessages.IUDetailsLabelProvider_Unknown;
        }
        if (this.size > 1000L) {
            long kb = this.size / 1000L;
            return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_KB, (Object)NumberFormat.getInstance().format((Object)kb));
        }
        return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_Bytes, (Object)NumberFormat.getInstance().format((Object)this.size));
    }

    public void dispose() {
        if (this.sizingJob != null) {
            this.sizingJob.cancel();
            this.sizingJob = null;
        }
    }

    @Override
    public void updateStatus(IUElementListRoot root, ProfileChangeOperation op) {
        super.updateStatus(root, op);
        if (op != null && op.getProvisioningPlan() != null) {
            this.computeSizing(op.getProvisioningPlan(), op.getProvisioningContext());
        }
    }

    @Override
    protected IQueryable<IInstallableUnit> getQueryable(IProvisioningPlan plan) {
        return plan.getAdditions();
    }
}

