/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;

public final class LocalDateTimeObservableValue
extends AbstractObservableValue<LocalDateTime> {
    private IObservableValue<LocalDate> dateObservable;
    private IObservableValue<LocalTime> timeObservable;
    private PrivateInterface privateInterface;
    private LocalDateTime cachedValue;
    private boolean updating;

    public LocalDateTimeObservableValue(IObservableValue<LocalDate> dateObservable, IObservableValue<LocalTime> timeObservable) {
        super(dateObservable.getRealm());
        this.dateObservable = dateObservable;
        this.timeObservable = timeObservable;
        Assert.isTrue((boolean)dateObservable.getRealm().equals(timeObservable.getRealm()));
        this.privateInterface = new PrivateInterface();
        dateObservable.addDisposeListener(this.privateInterface);
    }

    @Override
    public Object getValueType() {
        return LocalDateTime.class;
    }

    @Override
    protected void firstListenerAdded() {
        this.cachedValue = this.doGetValue();
        this.dateObservable.addChangeListener(this.privateInterface);
        this.dateObservable.addStaleListener(this.privateInterface);
        this.timeObservable.addChangeListener(this.privateInterface);
        this.timeObservable.addStaleListener(this.privateInterface);
    }

    @Override
    protected void lastListenerRemoved() {
        if (this.dateObservable != null && !this.dateObservable.isDisposed()) {
            this.dateObservable.removeChangeListener(this.privateInterface);
            this.dateObservable.removeStaleListener(this.privateInterface);
        }
        if (this.timeObservable != null && !this.timeObservable.isDisposed()) {
            this.timeObservable.removeChangeListener(this.privateInterface);
            this.timeObservable.removeStaleListener(this.privateInterface);
        }
        this.cachedValue = null;
    }

    private void notifyIfChanged() {
        LocalDateTime newValue;
        LocalDateTime oldValue;
        if (this.hasListeners() && !Objects.equals(oldValue = this.cachedValue, newValue = (this.cachedValue = this.doGetValue()))) {
            this.fireValueChange(Diffs.createValueDiff(oldValue, newValue));
        }
    }

    @Override
    protected LocalDateTime doGetValue() {
        LocalDate dateValue = this.dateObservable.getValue();
        if (dateValue == null) {
            return null;
        }
        LocalTime timeValue = this.timeObservable.getValue();
        if (timeValue == null) {
            timeValue = LocalTime.MIDNIGHT;
        }
        return LocalDateTime.of(dateValue, timeValue);
    }

    @Override
    protected void doSetValue(LocalDateTime combined) {
        this.updating = true;
        try {
            if (combined == null) {
                this.dateObservable.setValue(null);
                this.timeObservable.setValue(LocalTime.MIDNIGHT);
            } else {
                this.dateObservable.setValue(combined.toLocalDate());
                this.timeObservable.setValue(combined.toLocalTime());
            }
        }
        finally {
            this.updating = false;
        }
        this.notifyIfChanged();
    }

    @Override
    public boolean isStale() {
        ObservableTracker.getterCalled(this);
        return this.dateObservable.isStale() || this.timeObservable.isStale();
    }

    @Override
    public synchronized void dispose() {
        this.checkRealm();
        if (!this.isDisposed()) {
            if (!this.dateObservable.isDisposed()) {
                this.dateObservable.removeDisposeListener(this.privateInterface);
                this.dateObservable.removeChangeListener(this.privateInterface);
                this.dateObservable.removeStaleListener(this.privateInterface);
            }
            if (!this.timeObservable.isDisposed()) {
                this.timeObservable.removeDisposeListener(this.privateInterface);
                this.timeObservable.removeChangeListener(this.privateInterface);
                this.timeObservable.removeStaleListener(this.privateInterface);
            }
            this.dateObservable = null;
            this.timeObservable = null;
            this.privateInterface = null;
            this.cachedValue = null;
        }
        super.dispose();
    }

    private class PrivateInterface
    implements IChangeListener,
    IStaleListener,
    IDisposeListener {
        private PrivateInterface() {
        }

        @Override
        public void handleDispose(DisposeEvent staleEvent) {
            LocalDateTimeObservableValue.this.dispose();
        }

        @Override
        public void handleChange(ChangeEvent event) {
            if (!LocalDateTimeObservableValue.this.isDisposed() && !LocalDateTimeObservableValue.this.updating) {
                LocalDateTimeObservableValue.this.notifyIfChanged();
            }
        }

        @Override
        public void handleStale(StaleEvent staleEvent) {
            if (!LocalDateTimeObservableValue.this.isDisposed()) {
                LocalDateTimeObservableValue.this.fireStale();
            }
        }
    }
}

