/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.util.PrefUtil;

public class LargeFileLimitsPreferenceHandler {
    public static final String PROMPT_EDITOR_PREFERENCE_VALUE = "largeFileLimits_prompt";
    public static final String LARGE_FILE_ASSOCIATIONS_PREFERENCE_PAGE_ID = "org.eclipse.ui.preferencePages.LargeFileAssociations";
    private static final IPreferenceStore PREFERENCE_STORE = PrefUtil.getInternalPreferenceStore();
    private static final String DISABLED_EXTENSIONS_KEY = "largeFileLimits_disabled";
    private static final String CONFIGURED_EXTENSIONS_KEY = "largeFileLimits_types";
    private static final String DEFAULT_VALUE_KEY = "largeFileLimits_default_value";
    private static final String DEFAULT_VALUE_ENABLED_KEY = "largeFileLimits_default_enabled";
    private static final String EXTENSION_SEPARATOR = ".";
    private static final String PREFERENCE_EXTENSIONS_SEPARATOR = ",";
    private static final String PREFERENCE_VALUE_SEPARATOR = ",";
    private static final String EMPTY_VALUES = "";
    private static final boolean DEFAULT_REMEMBER_EDITOR_SELECTION = false;
    private final Map<String, List<FileLimit>> preferencesCache;
    private final IPropertyChangeListener preferencesListener;
    private final PromptForEditor promptForEditor;
    private long legacyMaxFileSize = 0L;
    private boolean legacyCheckDocumentSize;

    public LargeFileLimitsPreferenceHandler() {
        this(new DialogPromptForEditor());
    }

    public LargeFileLimitsPreferenceHandler(PromptForEditor promptForEditor) {
        this.promptForEditor = promptForEditor;
        this.initLegacyPreference();
        this.preferencesCache = new HashMap<String, List<FileLimit>>();
        this.preferencesListener = e -> {
            String property = e.getProperty();
            if (property.startsWith("largeFileLimits")) {
                this.preferencesCache.clear();
            }
        };
        PREFERENCE_STORE.addPropertyChangeListener(this.preferencesListener);
    }

    private void initLegacyPreference() {
        this.legacyMaxFileSize = LargeFileLimitsPreferenceHandler.getLargeDocumentLegacyPreferenceValue();
        this.legacyCheckDocumentSize = this.legacyMaxFileSize != 0L;
    }

    public void dispose() {
        PREFERENCE_STORE.removePropertyChangeListener(this.preferencesListener);
    }

    public static void setDefaults() {
        PREFERENCE_STORE.setDefault(DEFAULT_VALUE_KEY, 0x800000);
        PREFERENCE_STORE.setDefault(DEFAULT_VALUE_ENABLED_KEY, false);
    }

    public static void restoreDefaults() {
        PREFERENCE_STORE.setToDefault(DEFAULT_VALUE_KEY);
        PREFERENCE_STORE.setToDefault(DEFAULT_VALUE_ENABLED_KEY);
        ArrayList extensions = new ArrayList();
        Collections.addAll(extensions, LargeFileLimitsPreferenceHandler.getDisabledExtensionTypes());
        Collections.addAll(extensions, LargeFileLimitsPreferenceHandler.getConfiguredExtensionTypes());
        extensions.forEach(e -> PREFERENCE_STORE.setToDefault(LargeFileLimitsPreferenceHandler.getPreferenceNameForExtension(e)));
        PREFERENCE_STORE.setToDefault(DISABLED_EXTENSIONS_KEY);
        PREFERENCE_STORE.setToDefault(CONFIGURED_EXTENSIONS_KEY);
    }

    public static boolean isLargeDocumentLegacyPreferenceSet() {
        long legacyPreferenceValue = LargeFileLimitsPreferenceHandler.getLargeDocumentLegacyPreferenceValue();
        return legacyPreferenceValue > 0L;
    }

    public static long getDefaultLimit() {
        return PREFERENCE_STORE.getLong(DEFAULT_VALUE_KEY);
    }

    public static boolean isDefaultLimitEnabled() {
        return PREFERENCE_STORE.getBoolean(DEFAULT_VALUE_ENABLED_KEY);
    }

    public static void setDefaultLimit(long fileSize) {
        PREFERENCE_STORE.setValue(DEFAULT_VALUE_KEY, fileSize);
        PREFERENCE_STORE.setValue(DEFAULT_VALUE_ENABLED_KEY, true);
    }

    public static void disableDefaultLimit() {
        PREFERENCE_STORE.setValue(DEFAULT_VALUE_ENABLED_KEY, false);
    }

    public static String[] getConfiguredExtensionTypes() {
        String[] extensions = LargeFileLimitsPreferenceHandler.getExtensionsPreferenceValue(CONFIGURED_EXTENSIONS_KEY);
        return extensions;
    }

    public static void setConfiguredExtensionTypes(String[] extensionTypes) {
        LargeFileLimitsPreferenceHandler.setExtensionsPreferenceValue(CONFIGURED_EXTENSIONS_KEY, extensionTypes);
    }

    public static String[] getDisabledExtensionTypes() {
        String[] extensions = LargeFileLimitsPreferenceHandler.getExtensionsPreferenceValue(DISABLED_EXTENSIONS_KEY);
        return extensions;
    }

    public static void setDisabledExtensionTypes(String[] extensionTypes) {
        LargeFileLimitsPreferenceHandler.setExtensionsPreferenceValue(DISABLED_EXTENSIONS_KEY, extensionTypes);
    }

    public static List<FileLimit> getFileLimitsForExtension(String fileExtension) {
        String preferenceName = LargeFileLimitsPreferenceHandler.getPreferenceNameForExtension(fileExtension);
        List<FileLimit> preferenceValues = LargeFileLimitsPreferenceHandler.getPreferenceValues(preferenceName);
        return preferenceValues;
    }

    public static void removeFileLimitsForExtension(String fileExtension) {
        String preferenceName = LargeFileLimitsPreferenceHandler.getPreferenceNameForExtension(fileExtension);
        PREFERENCE_STORE.setValue(preferenceName, EMPTY_VALUES);
    }

    public static void setFileLimitsForExtension(String fileExtension, List<FileLimit> fileLimits) {
        String preferenceName = LargeFileLimitsPreferenceHandler.getPreferenceNameForExtension(fileExtension);
        LargeFileLimitsPreferenceHandler.setPreferenceValues(preferenceName, fileLimits);
    }

    public static boolean isPromptPreferenceValue(String editorId) {
        boolean isPromptPreferenceValue = PROMPT_EDITOR_PREFERENCE_VALUE.equals(editorId);
        return isPromptPreferenceValue;
    }

    public Optional<String> getEditorForInput(IEditorInput editorInput) {
        if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
            try {
                IPath inputPath = pathEditorInput.getPath();
                return this.getEditorForPath(inputPath);
            }
            catch (Exception e) {
                Status warning = Status.warning((String)("Exception occurred while checking large file editor for " + String.valueOf(editorInput)), (Throwable)e);
                WorkbenchPlugin.log((IStatus)warning);
            }
        }
        return Optional.empty();
    }

    private Optional<String> getEditorForPath(IPath inputPath) {
        boolean legacyPreferenceApplies = this.isLargeDocumentFromLegacy(inputPath);
        if (legacyPreferenceApplies) {
            IEditorDescriptor editor = LargeFileLimitsPreferenceHandler.getLegacyAlternateEditor();
            if (editor == null) {
                return null;
            }
            String editorId = editor.getId();
            return Optional.of(editorId);
        }
        String editorId = null;
        boolean isPromptPreferenceValue = false;
        FileLimit fileLimit = this.getLimitForLargeFile(inputPath);
        if (fileLimit != null) {
            editorId = fileLimit.editorId;
            isPromptPreferenceValue = LargeFileLimitsPreferenceHandler.isPromptPreferenceValue(fileLimit.editorId);
        }
        if (isPromptPreferenceValue) {
            this.promptForEditor.prompt(inputPath, fileLimit);
            IEditorDescriptor editor = this.promptForEditor.getSelectedEditor();
            if (editor == null) {
                return null;
            }
            editorId = editor.getId();
            boolean rememberSelectedEditor = this.promptForEditor.shouldRememberSelectedEditor();
            if (editorId != null && rememberSelectedEditor) {
                FileLimit newLimit = new FileLimit(editorId, fileLimit.fileSize);
                this.replaceLimitForLargeFile(inputPath, fileLimit, newLimit);
                LargeFileLimitsPreferenceHandler.addedConfiguredExtensionType(inputPath);
            }
        }
        if (editorId != null && !editorId.isEmpty()) {
            return Optional.of(editorId);
        }
        return Optional.empty();
    }

    private static IEditorDescriptor getLegacyAlternateEditor() {
        Shell shell = ProgressManagerUtil.getDefaultParent();
        EditorSelectionDialog dialog = new EditorSelectionDialog(shell){

            @Override
            protected IDialogSettings getDialogSettings() {
                DialogSettings result = new DialogSettings("EditorSelectionDialog");
                result.put("EditorSelectionDialog.STORE_ID_INTERNAL_EXTERNAL", true);
                return result;
            }
        };
        dialog.setMessage(WorkbenchMessages.EditorManager_largeDocumentWarning);
        if (dialog.open() == 0) {
            return dialog.getSelectedEditor();
        }
        return null;
    }

    boolean isLargeDocumentFromLegacy(IPath path) {
        if (!this.legacyCheckDocumentSize) {
            return false;
        }
        try {
            File file = new File(path.toOSString());
            return file.length() > this.legacyMaxFileSize;
        }
        catch (Exception e) {
            return false;
        }
    }

    FileLimit getLimitForLargeFile(IPath path) {
        FileLimit applicableFileLimit = null;
        try {
            List<FileLimit> fileLimits = LargeFileLimitsPreferenceHandler.getFileLimits(path, this.preferencesCache);
            if (!fileLimits.isEmpty()) {
                File file = new File(path.toOSString());
                long fileSize = file.length();
                long maxBound = 0L;
                for (FileLimit fileLimit : fileLimits) {
                    long limit = fileLimit.fileSize;
                    if (fileSize <= limit || limit <= maxBound) continue;
                    maxBound = limit;
                    applicableFileLimit = fileLimit;
                }
            }
        }
        catch (Exception e) {
            WorkbenchPlugin.log("Exception occurred while checking large file editor for path " + String.valueOf(path), e);
        }
        return applicableFileLimit;
    }

    private void replaceLimitForLargeFile(IPath path, FileLimit oldLimit, FileLimit newLimit) {
        try {
            List<FileLimit> fileLimits = LargeFileLimitsPreferenceHandler.getFileLimits(path, this.preferencesCache);
            ArrayList<FileLimit> newLimits = new ArrayList<FileLimit>();
            for (FileLimit fileLimit : fileLimits) {
                boolean toReplace = LargeFileLimitsPreferenceHandler.equals(oldLimit, fileLimit);
                if (toReplace) continue;
                newLimits.add(fileLimit);
            }
            newLimits.add(newLimit);
            LargeFileLimitsPreferenceHandler.setFileLimitsForPath(path, newLimits);
        }
        catch (Exception e) {
            WorkbenchPlugin.log("Exception occurred while replacing large file editor preference for path " + String.valueOf(path), e);
        }
    }

    private static void addedConfiguredExtensionType(IPath inputPath) {
        String extension = inputPath.getFileExtension();
        String[] configuredExtensionTypes = LargeFileLimitsPreferenceHandler.getConfiguredExtensionTypes();
        ArrayList<String> newExtensionTypes = new ArrayList<String>();
        newExtensionTypes.addAll(Arrays.asList(configuredExtensionTypes));
        if (!newExtensionTypes.contains(extension)) {
            newExtensionTypes.add(extension);
            LargeFileLimitsPreferenceHandler.setConfiguredExtensionTypes((String[])newExtensionTypes.toArray(String[]::new));
        }
    }

    private static List<FileLimit> getFileLimits(IPath path, Map<String, List<FileLimit>> preferencesCache) {
        String fileExtension = path.getFileExtension();
        List<FileLimit> preferenceValues = new ArrayList<FileLimit>();
        if (fileExtension != null && (preferenceValues = preferencesCache.get(fileExtension)) == null) {
            preferenceValues = LargeFileLimitsPreferenceHandler.getLargeFilePreferenceValues(fileExtension);
            preferencesCache.put(fileExtension, preferenceValues);
        }
        return preferenceValues;
    }

    public static List<FileLimit> getLargeFilePreferenceValues(String fileExtension) {
        List<FileLimit> preferenceValues = new ArrayList<FileLimit>();
        String[] disabled = LargeFileLimitsPreferenceHandler.getDisabledExtensionTypes();
        boolean isDisabled = Arrays.asList(disabled).contains(fileExtension);
        if (!isDisabled) {
            boolean noPreferenceForExtension;
            String preferenceName = LargeFileLimitsPreferenceHandler.getPreferenceNameForExtension(fileExtension);
            String largeFilePreference = PREFERENCE_STORE.getString(preferenceName);
            boolean bl = noPreferenceForExtension = largeFilePreference == null || largeFilePreference.isEmpty();
            if (noPreferenceForExtension && LargeFileLimitsPreferenceHandler.isDefaultLimitEnabled()) {
                long defaultLimit = LargeFileLimitsPreferenceHandler.getDefaultLimit();
                preferenceValues.add(new FileLimit(PROMPT_EDITOR_PREFERENCE_VALUE, defaultLimit));
            } else {
                preferenceValues = LargeFileLimitsPreferenceHandler.getPreferenceValues(preferenceName);
            }
        }
        return preferenceValues;
    }

    private static long getLargeDocumentLegacyPreferenceValue() {
        return PREFERENCE_STORE.getLong("LARGE_DOC_SIZE_FOR_EDITORS");
    }

    private static boolean equals(FileLimit l1, FileLimit l2) {
        return l1.fileSize == l2.fileSize && l1.editorId.equals(l2.editorId);
    }

    private static String[] getExtensionsPreferenceValue(String preferenceName) {
        String[] extensions = new String[]{};
        String extensionTypes = PREFERENCE_STORE.getString(preferenceName);
        if (extensionTypes != null && !extensionTypes.isEmpty()) {
            extensions = extensionTypes.split(",");
        }
        return extensions;
    }

    private static void setExtensionsPreferenceValue(String preferenceName, String[] extensionTypes) {
        String preferenceValue = EMPTY_VALUES;
        if (extensionTypes.length > 0) {
            preferenceValue = String.join((CharSequence)",", extensionTypes);
        }
        PREFERENCE_STORE.setValue(preferenceName, preferenceValue);
    }

    private static void setFileLimitsForPath(IPath path, List<FileLimit> fileLimits) {
        String fileExtension = path.getFileExtension();
        LargeFileLimitsPreferenceHandler.setFileLimitsForExtension(fileExtension, fileLimits);
    }

    private static List<FileLimit> getPreferenceValues(String preferenceName) {
        String largeFilePreference = PREFERENCE_STORE.getString(preferenceName);
        List<Object> preferenceValues = new ArrayList();
        if (largeFilePreference != null && !largeFilePreference.isEmpty()) {
            String[] values = LargeFileLimitsPreferenceHandler.splitPreferenceValues(preferenceName, largeFilePreference);
            preferenceValues = LargeFileLimitsPreferenceHandler.parsePreferenceValues(preferenceName, values);
        }
        return Collections.unmodifiableList(preferenceValues);
    }

    private static String[] splitPreferenceValues(String preferenceName, String preferenceValue) {
        Object[] values = preferenceValue.split(",");
        if (values.length % 2 != 0) {
            String errorMessage = NLS.bind((String)"Expected pairs of values separated by \"{0}\" for preference \"{1}\" but got: \"{2}\"", (Object[])new String[]{",", preferenceName, Arrays.toString(values)});
            WorkbenchPlugin.log(new IllegalArgumentException(errorMessage));
            values = new String[]{};
        }
        return values;
    }

    private static List<FileLimit> parsePreferenceValues(String preferenceName, String[] preferenceValues) {
        ArrayList<FileLimit> fileLimits = new ArrayList<FileLimit>();
        int i = 0;
        while (i < preferenceValues.length) {
            String sizeString = preferenceValues[i + 0];
            String editorId = preferenceValues[i + 1];
            try {
                long bytes = Long.parseLong(sizeString);
                FileLimit fileLimit = new FileLimit(editorId, bytes);
                fileLimits.add(fileLimit);
            }
            catch (NumberFormatException e) {
                String errorMessage = NLS.bind((String)"Skipped invalid file size value \"{0}\" stored in preference \"{1}\" with value \"{2}\"", (Object[])new String[]{sizeString, preferenceName, Arrays.toString(preferenceValues)});
                WorkbenchPlugin.log(new IllegalArgumentException(errorMessage, e));
            }
            i += 2;
        }
        return fileLimits;
    }

    private static void setPreferenceValues(String preferenceName, List<FileLimit> fileLimits) {
        StringBuilder preferenceValue = new StringBuilder();
        int i = 0;
        while (i < fileLimits.size()) {
            FileLimit fileLimit = fileLimits.get(i);
            preferenceValue.append(fileLimit.fileSize);
            preferenceValue.append(",");
            preferenceValue.append(fileLimit.editorId);
            if (i < fileLimits.size() - 1) {
                preferenceValue.append(",");
            }
            ++i;
        }
        PREFERENCE_STORE.setValue(preferenceName, preferenceValue.toString());
    }

    private static String getPreferenceNameForExtension(String fileExtension) {
        String preferenceName = "largeFileLimits." + fileExtension;
        return preferenceName;
    }

    private static void openPreferencePage(Shell shell) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(shell, LARGE_FILE_ASSOCIATIONS_PREFERENCE_PAGE_ID, null, null);
        dialog.open();
    }

    private static class DialogPromptForEditor
    implements PromptForEditor {
        IEditorDescriptor selectedEditor = null;
        boolean rememberSelection = false;

        private DialogPromptForEditor() {
        }

        @Override
        public void prompt(IPath inputPath, FileLimit fileLimit) {
            this.selectedEditor = null;
            this.rememberSelection = false;
            Shell shell = ProgressManagerUtil.getDefaultParent();
            LargeFileEditorSelectionDialog dialog = new LargeFileEditorSelectionDialog(shell, inputPath.getFileExtension(), fileLimit.fileSize);
            dialog.setMessage(WorkbenchMessages.EditorManager_largeDocumentWarning);
            if (dialog.open() == 0) {
                this.selectedEditor = dialog.getSelectedEditor();
                this.rememberSelection = dialog.shouldRememberSelectedEditor();
            }
        }

        @Override
        public IEditorDescriptor getSelectedEditor() {
            return this.selectedEditor;
        }

        @Override
        public boolean shouldRememberSelectedEditor() {
            return this.rememberSelection;
        }
    }

    public static class FileLimit {
        public final String editorId;
        public final long fileSize;

        public FileLimit(String editorId, long fileSize) {
            this.editorId = editorId;
            this.fileSize = fileSize;
        }

        public String toString() {
            return "(" + this.editorId + "," + this.fileSize + ")";
        }
    }

    public static class LargeFileEditorSelectionDialog
    extends EditorSelectionDialog {
        private final String extension;
        private final long fileSize;
        private Button rememberSelectionButton;
        private boolean rememberSelection;

        public LargeFileEditorSelectionDialog(Shell shell, String extension, long size) {
            super(shell);
            this.extension = extension;
            this.fileSize = size;
            this.rememberSelection = false;
        }

        @Override
        protected IDialogSettings getDialogSettings() {
            DialogSettings result = new DialogSettings("LargeFileEditorSelectionDialog");
            result.put("EditorSelectionDialog.STORE_ID_INTERNAL_EXTERNAL", true);
            return result;
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            Composite contents = (Composite)super.createDialogArea(parent);
            Composite preferenceGroup = new Composite(contents, 0);
            preferenceGroup.setLayout((Layout)new FillLayout(512));
            this.rememberSelectionButton = new Button(preferenceGroup, 32);
            String buttonText = NLS.bind((String)WorkbenchMessages.LargeFileAssociation_Dialog_rememberSelectedEditor, (Object)this.extension, (Object)this.fileSize);
            this.rememberSelectionButton.setText(buttonText);
            this.rememberSelectionButton.setSelection(this.rememberSelection);
            this.rememberSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    rememberSelection = rememberSelectionButton.getSelection();
                }
            });
            final Shell shell = parent.getShell();
            Link preferencePageLink = new Link(preferenceGroup, 0);
            preferencePageLink.setText(WorkbenchMessages.LargeFileAssociation_Dialog_configureFileAssociationsLink);
            preferencePageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LargeFileLimitsPreferenceHandler.openPreferencePage(shell);
                }
            });
            return contents;
        }

        public boolean shouldRememberSelectedEditor() {
            return this.rememberSelection;
        }
    }

    public static interface PromptForEditor {
        public void prompt(IPath var1, FileLimit var2);

        public IEditorDescriptor getSelectedEditor();

        public boolean shouldRememberSelectedEditor();
    }
}

