/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.DefaultCustomFilterArgumentUI;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterEditDialog;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.internal.ide.dialogs.ICustomFilterArgumentUI;
import org.eclipse.ui.internal.ide.dialogs.MultiMatcherCustomFilterArgumentUI;

public class ResourceFilterGroup {
    private Button addButton;
    private Button addGroupButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private Button editButton;
    private TreeViewer filterView;
    private TreeContentProvider filterViewContentProvider;
    private Filters filters;
    private UIResourceFilterDescription[] initialFilters = new UIResourceFilterDescription[0];
    private LabelProvider labelProvider;
    private Font boldFont;
    private Font plainFont;
    private Image fileIcon;
    private Image folderIcon;
    private Image fileFolderIcon;
    private Image includeIcon;
    private Image excludeIcon;
    private Image inheritableIcon;
    private boolean tableViewCellEditorAdequatlyUsable;
    private Shell shell;
    private IContainer nonExistantResource;
    private IContainer resource = this.nonExistantResource = this.getNonExistantResource();
    static String includeOnlyGroup = "INCLUDE_ONLY_GROUP";
    static String excludeAllGroup = "EXCLUDE_ALL_GROUP";
    Action addSubFilterAction = new AddSubFilterAction(false);
    Action addSubGroupFilterAction = new AddSubFilterAction(true);
    private FilterCopyTransfer filterCopyTransfer = new FilterCopyTransfer();

    public ResourceFilterGroup() {
        ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/fileType_filter.png").ifPresent(d -> {
            Image image = this.fileIcon = d.createImage();
        });
        ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/folderType_filter.png").ifPresent(d -> {
            Image image = this.folderIcon = d.createImage();
        });
        ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/fileFolderType_filter.png").ifPresent(d -> {
            Image image = this.fileFolderIcon = d.createImage();
        });
        ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/includeMode_filter.png").ifPresent(d -> {
            Image image = this.includeIcon = d.createImage();
        });
        ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/excludeMode_filter.png").ifPresent(d -> {
            Image image = this.excludeIcon = d.createImage();
        });
        ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/inheritable_filter.png").ifPresent(d -> {
            Image image = this.inheritableIcon = d.createImage();
        });
    }

    Image getImage(String string, int i) {
        if (string.equals(FilterTypeUtil.MODE)) {
            return (new Image[]{this.includeIcon, this.excludeIcon, this.inheritableIcon})[i];
        }
        if (string.equals(FilterTypeUtil.TARGET)) {
            return (new Image[]{this.fileIcon, this.folderIcon, this.fileFolderIcon})[i];
        }
        return null;
    }

    public void setContainer(IContainer res) {
        this.resource = res;
    }

    private IContainer getNonExistantResource() {
        String projectName = "nonExistantProject_";
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        int iteration = 0;
        while (p.exists()) {
            p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName + iteration);
            ++iteration;
        }
        return p;
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        this.shell = parent.getShell();
        if (this.resource == null) {
            Label label = new Label(parent, 0);
            label.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_noResource, null));
            label.setFont(font);
            return label;
        }
        this.filters = this.resource == this.nonExistantResource ? new Filters(this.initialFilters) : new Filters(this.resource);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Label label = new Label(composite, 0);
        label.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_title, null));
        data = new GridData(4);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.createViewerGroup(composite);
        this.createButtonGroup(composite);
        this.refreshEnablement();
        return composite;
    }

    private void createViewerGroup(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tableComposite.setLayoutData((Object)data);
        this.filterView = new TreeViewer(tableComposite, 67840);
        data = new GridData(4, 4, true, true);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.filterView.getTree().setLayoutData((Object)data);
        this.filterView.setColumnProperties(FilterTypeUtil.columnNames);
        this.plainFont = this.filterView.getTree().getFont();
        FontData[] boldFontData = ResourceFilterGroup.getModifiedFontData(this.plainFont.getFontData(), 1);
        this.boldFont = new Font((Device)Display.getCurrent(), boldFontData);
        this.filterView.setAutoExpandLevel(2);
        this.filterViewContentProvider = new TreeContentProvider();
        this.filterView.setContentProvider((IContentProvider)this.filterViewContentProvider);
        this.filterView.setInput((Object)this.filters);
        this.filterView.getTree().setFont(parent.getFont());
        this.filterView.addSelectionChangedListener(event -> this.refreshEnablement());
        TreeColumn modeColumn = new TreeColumn(this.filterView.getTree(), 0);
        modeColumn.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterDescription, null));
        modeColumn.setData((Object)FilterTypeUtil.MODE);
        modeColumn.setResizable(true);
        modeColumn.setMoveable(false);
        this.filterView.getTree().setHeaderVisible(false);
        this.filterView.getTree().showColumn(this.filterView.getTree().getColumn(0));
        this.labelProvider = new LabelProvider();
        this.filterView.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        CellEditor[] editors = new CellEditor[]{new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getFilterNames(false), 8), new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getModes(), 8), new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getTargets(), 8), new CheckboxCellEditor((Composite)this.filterView.getTree()), new TextCellEditor((Composite)this.filterView.getTree())};
        if (this.tableViewCellEditorAdequatlyUsable) {
            this.filterView.setCellEditors(editors);
            this.filterView.setCellModifier((ICellModifier)new CellModifier());
        }
        this.filterView.getTree().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ISelection selection;
                if (!ResourceFilterGroup.this.handleEdit() && (selection = ResourceFilterGroup.this.filterView.getSelection()) instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
                    Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                    ResourceFilterGroup.this.filterView.setExpandedState(firstElement, !ResourceFilterGroup.this.filterView.getExpandedState(firstElement));
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        FilterCopyDrag drag = new FilterCopyDrag();
        int ops = 2;
        Transfer[] transfers = new Transfer[]{this.filterCopyTransfer};
        this.filterView.addDragSupport(ops, transfers, (DragSourceListener)drag);
        this.filterView.addDropSupport(ops, transfers, (DropTargetListener)new FilterCopyDrop((Viewer)this.filterView));
        this.filterView.getTree().addMenuDetectListener(e -> {
            MenuManager mgr = new MenuManager();
            mgr.add((IAction)this.addSubFilterAction);
            mgr.add((IAction)this.addSubGroupFilterAction);
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new EditFilterAction());
            mgr.add((IAction)new RemoveFilterAction());
            this.filterView.getControl().setMenu(mgr.createContextMenu(this.filterView.getControl()));
        });
        TreeColumnLayout layout = new TreeColumnLayout();
        tableComposite.setLayout((Layout)layout);
        layout.setColumnData((Widget)modeColumn, (ColumnLayoutData)new ColumnWeightData(100));
        this.filterView.setSelection((ISelection)new StructuredSelection((Object)includeOnlyGroup));
    }

    private static FontData[] getModifiedFontData(FontData[] originalData, int additionalStyle) {
        FontData[] styleData = new FontData[originalData.length];
        int i = 0;
        while (i < styleData.length) {
            FontData base = originalData[i];
            styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | additionalStyle);
            ++i;
        }
        return styleData;
    }

    private void handleAdd(boolean createGroupOnly) {
        Object selectedObject = null;
        ISelection selection = this.filterView.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectedObject = structuredSelection.getFirstElement();
        }
        this.handleAdd(selectedObject, createGroupOnly);
    }

    private void handleAdd(Object selection, boolean createGroupOnly) {
        if (selection == null) {
            FilterCopy newFilter = new FilterCopy();
            FilterEditDialog dialog = new FilterEditDialog((IResource)this.resource, this, this.shell, newFilter, createGroupOnly, true);
            if (dialog.open() == 0) {
                this.addToTopLevelFilters(newFilter);
                this.refreshAndSelect(newFilter);
            }
        } else if (selection instanceof FilterCopy) {
            FilterCopy filter = (FilterCopy)selection;
            if (filter.getChildrenLimit() > 0) {
                FilterCopy newFilter = new FilterCopy();
                newFilter.setParent(filter);
                FilterTypeUtil.setValue(newFilter, FilterTypeUtil.MODE, FilterTypeUtil.getValue(filter, FilterTypeUtil.MODE));
                FilterEditDialog dialog = new FilterEditDialog((IResource)this.resource, this, this.shell, newFilter, createGroupOnly, true);
                if (dialog.open() == 0) {
                    filter.addChild(newFilter);
                    this.refreshAndSelect(newFilter);
                }
            } else {
                FilterCopy newFilter = new FilterCopy();
                FilterEditDialog dialog = new FilterEditDialog((IResource)this.resource, this, this.shell, newFilter, createGroupOnly, true);
                if (dialog.open() == 0) {
                    this.addToTopLevelFilters(newFilter);
                    this.refreshAndSelect(newFilter);
                }
            }
        } else if (selection instanceof String) {
            FilterCopy newFilter = new FilterCopy();
            FilterTypeUtil.setValue(newFilter, FilterTypeUtil.MODE, selection.equals(includeOnlyGroup) ? 0 : 1);
            FilterEditDialog dialog = new FilterEditDialog((IResource)this.resource, this, this.shell, newFilter, createGroupOnly, true);
            if (dialog.open() == 0) {
                this.addToTopLevelFilters(newFilter);
                this.refreshAndSelect(newFilter);
            }
        }
    }

    private void refreshAndSelect(FilterCopy newFilter) {
        this.filterView.refresh();
        this.filterView.reveal((Object)newFilter);
    }

    private boolean isAddEnabled(Object selection) {
        if (selection == null) {
            return true;
        }
        if (selection instanceof FilterCopy) {
            FilterCopy filter = (FilterCopy)selection;
            return filter.getChildrenLimit() > 0;
        }
        return selection instanceof String;
    }

    private void addToTopLevelFilters(FilterCopy newFilter) {
        int value = (Integer)FilterTypeUtil.getValue(newFilter, FilterTypeUtil.MODE);
        Object[] existingChildren = this.filterViewContentProvider.getChildren(value == 0 ? includeOnlyGroup : excludeAllGroup);
        this.filters.add(newFilter);
        this.filterView.refresh();
        if (existingChildren.length == 0) {
            this.filterView.setExpandedState((Object)newFilter, true);
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, false, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.addButton = new Button(composite, 8);
        this.addButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_addButtonLabel, null));
        data = new GridData(4, 4, false, false);
        this.addButton.setLayoutData((Object)data);
        ResourceFilterGroup.setButtonDimensionHint(this.addButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterGroup.this.handleAdd(false);
            }
        });
        this.addGroupButton = new Button(composite, 8);
        this.addGroupButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_addGroupButtonLabel, null));
        data = new GridData(4, 4, false, false);
        this.addGroupButton.setLayoutData((Object)data);
        ResourceFilterGroup.setButtonDimensionHint(this.addGroupButton);
        this.addGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterGroup.this.handleAdd(true);
            }
        });
        this.editButton = new Button(composite, 8);
        this.editButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_editButtonLabel, null));
        data = new GridData(4, 4, false, false);
        this.editButton.setLayoutData((Object)data);
        ResourceFilterGroup.setButtonDimensionHint(this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterGroup.this.handleEdit();
            }
        });
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_removeButtonLabel, null));
        data = new GridData(4, 4, false, false);
        this.removeButton.setLayoutData((Object)data);
        ResourceFilterGroup.setButtonDimensionHint(this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterGroup.this.handleRemove();
            }
        });
    }

    private void refreshEnablement() {
        if (this.addButton != null) {
            ISelection selection = this.filterView.getSelection();
            IStructuredSelection structuredSelection = null;
            if (selection instanceof IStructuredSelection) {
                structuredSelection = (IStructuredSelection)selection;
            }
            this.removeButton.setEnabled(structuredSelection != null && structuredSelection.size() > 0 && !(structuredSelection.getFirstElement() instanceof String));
            this.editButton.setEnabled(structuredSelection != null && structuredSelection.size() == 1 && structuredSelection.getFirstElement() instanceof FilterCopy);
            if (this.upButton != null) {
                this.upButton.setEnabled(structuredSelection != null && structuredSelection.size() > 0 && !this.isFirst(structuredSelection.getFirstElement()));
            }
            if (this.downButton != null) {
                this.downButton.setEnabled(structuredSelection != null && structuredSelection.size() > 0 && !this.isLast(structuredSelection.getFirstElement()));
            }
        }
    }

    private boolean isFirst(Object o) {
        return this.filters.isFirst((FilterCopy)o);
    }

    private boolean isLast(Object o) {
        return this.filters.isLast((FilterCopy)o);
    }

    private boolean handleEdit() {
        ISelection selection = this.filterView.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof String) {
                this.handleAdd(firstElement, false);
                return true;
            }
            if (firstElement instanceof FilterCopy) {
                FilterCopy filter = (FilterCopy)firstElement;
                FilterCopy copy = new FilterCopy(filter);
                copy.setParent(filter.getParent());
                boolean isGroup = filter.getChildrenLimit() > 0;
                FilterEditDialog dialog = new FilterEditDialog((IResource)this.resource, this, this.shell, copy, isGroup, false);
                if (dialog.open() == 0 && copy.hasChanged()) {
                    filter.copy(copy);
                    this.filterView.refresh();
                }
                return true;
            }
        }
        return false;
    }

    private FilterCopy[] getFilterCopySelection() {
        ISelection selection = this.filterView.getSelection();
        IStructuredSelection structuredSelection = null;
        if (selection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
            FilterCopy[] tmp = new FilterCopy[structuredSelection.size()];
            System.arraycopy(structuredSelection.toArray(), 0, tmp, 0, tmp.length);
            return tmp;
        }
        return new FilterCopy[0];
    }

    private void handleRemove() {
        ISelection selection = this.filterView.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                if (element instanceof FilterCopy) {
                    FilterCopy filter = (FilterCopy)element;
                    filter.getParent().removeChild(filter);
                    continue;
                }
                int mask = element.equals(includeOnlyGroup) ? 1 : 2;
                FilterCopy[] filterCopyArray = this.filters.getChildren();
                int n = filterCopyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterCopy filterCopy = filterCopyArray[n2];
                    if ((filterCopy.getType() & mask) != 0) {
                        this.filters.removeChild(filterCopy);
                    }
                    ++n2;
                }
            }
            this.filterView.refresh();
        }
    }

    private static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = ResourceFilterGroup.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    private static int getButtonWidthHint(Button button) {
        FontMetrics fontMetrics;
        button.setFont(JFaceResources.getDialogFont());
        GC gc = new GC((Drawable)button);
        try {
            gc.setFont(button.getFont());
            fontMetrics = gc.getFontMetrics();
        }
        finally {
            gc.dispose();
        }
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public void performDefaults() {
        if (this.resource == null) {
            return;
        }
        this.filters = new Filters(this.resource);
        this.filters.removeAll();
        this.filterView.setInput((Object)this.filters);
        this.filterView.refresh();
    }

    public UIResourceFilterDescription[] getFilters() {
        FilterCopy[] newFilters = this.filters.getChildren();
        UIResourceFilterDescription[] result = new UIResourceFilterDescription[newFilters.length];
        System.arraycopy(newFilters, 0, result, 0, newFilters.length);
        return result;
    }

    public void setFilters(IResourceFilterDescription[] filters) {
        this.initialFilters = new UIResourceFilterDescription[filters.length];
        int i = 0;
        while (i < filters.length) {
            this.initialFilters[i] = UIResourceFilterDescription.wrap(filters[i]);
            ++i;
        }
    }

    public void setFilters(UIResourceFilterDescription[] filters) {
        this.initialFilters = filters;
    }

    public boolean performOk() {
        if (this.resource == null || this.filters == null) {
            return true;
        }
        if (this.filters.hasChanged()) {
            try {
                if (this.resource != this.nonExistantResource) {
                    FilterCopy[] newFilters;
                    IResourceFilterDescription[] oldFilters;
                    IResourceFilterDescription[] iResourceFilterDescriptionArray = oldFilters = this.resource.getFilters();
                    int n = oldFilters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceFilterDescription oldFilter = iResourceFilterDescriptionArray[n2];
                        oldFilter.delete(128, (IProgressMonitor)new NullProgressMonitor());
                        ++n2;
                    }
                    FilterCopy[] filterCopyArray = newFilters = this.filters.getChildren();
                    int n3 = newFilters.length;
                    n = 0;
                    while (n < n3) {
                        FilterCopy newFilter = filterCopyArray[n];
                        this.resource.createFilter(newFilter.getType(), newFilter.getFileInfoMatcherDescription(), 128, (IProgressMonitor)new NullProgressMonitor());
                        ++n;
                    }
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.shell, (String)NLS.bind((String)IDEWorkbenchMessages.InternalError, null), (String)e.getLocalizedMessage(), (IStatus)e.getStatus());
            }
        }
        return true;
    }

    public void dispose() {
        this.disposeIcons();
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
    }

    private void disposeIcons() {
        Field[] fields;
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Class<?> cls = field.getType();
            if (cls.equals(Image.class)) {
                try {
                    Image img = (Image)field.get(this);
                    if (img != null) {
                        img.dispose();
                        field.set(this, null);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    IDEWorkbenchPlugin.log(e.getMessage(), e);
                }
            }
            ++n2;
        }
    }

    class AddSubFilterAction
    extends Action {
        boolean createGroupOnly;

        public AddSubFilterAction(boolean createGroupOnly) {
            this.createGroupOnly = createGroupOnly;
            this.setText(NLS.bind((String)(createGroupOnly ? IDEWorkbenchMessages.ResourceFilterPage_addSubFilterGroupActionLabel : IDEWorkbenchMessages.ResourceFilterPage_addSubFilterActionLabel), null));
        }

        public void run() {
            ISelection selection = ResourceFilterGroup.this.filterView.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                ResourceFilterGroup.this.handleAdd(firstElement, this.createGroupOnly);
            }
        }

        public boolean isEnabled() {
            ISelection selection = ResourceFilterGroup.this.filterView.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                return ResourceFilterGroup.this.isAddEnabled(firstElement);
            }
            return false;
        }
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            FilterCopy filter = (FilterCopy)element;
            return !property.equals(FilterTypeUtil.ARGUMENTS) || filter.hasStringArguments();
        }

        public Object getValue(Object element, String property) {
            FilterCopy filter = (FilterCopy)element;
            return FilterTypeUtil.getValue(filter, property);
        }

        public void modify(Object element, String property, Object value) {
            FilterCopy filter = (FilterCopy)((TableItem)element).getData();
            FilterTypeUtil.setValue(filter, property, value);
            ResourceFilterGroup.this.filterView.refresh((Object)filter);
        }
    }

    class EditFilterAction
    extends Action {
        public EditFilterAction() {
            this.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_editFilterActionLabel, null));
        }

        public void run() {
            ResourceFilterGroup.this.handleEdit();
        }

        public boolean isEnabled() {
            ISelection selection = ResourceFilterGroup.this.filterView.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                return firstElement instanceof FilterCopy;
            }
            return false;
        }
    }

    class FilterCopyDrag
    implements DragSourceListener {
        FilterCopyDrag() {
        }

        public void dragFinished(DragSourceEvent event) {
            int cfr_ignored_0 = event.detail;
        }

        public void dragSetData(DragSourceEvent event) {
            if (ResourceFilterGroup.this.filterCopyTransfer.isSupportedType(event.dataType)) {
                event.data = ResourceFilterGroup.this.getFilterCopySelection();
            }
        }

        public void dragStart(DragSourceEvent event) {
            if (ResourceFilterGroup.this.getFilterCopySelection().length == 0) {
                event.doit = false;
            }
        }
    }

    class FilterCopyDrop
    extends ViewerDropAdapter {
        protected FilterCopyDrop(Viewer viewer) {
            super(viewer);
        }

        public boolean performDrop(Object data) {
            FilterCopy filterToDrop;
            int n;
            int n2;
            FilterCopy[] filterCopyArray;
            Object target = this.getCurrentTarget();
            if (target == null) {
                target = ResourceFilterGroup.this.filters;
            }
            FilterCopy[] toDrop = (FilterCopy[])data;
            if (target instanceof FilterCopy) {
                filterCopyArray = toDrop;
                n2 = toDrop.length;
                n = 0;
                while (n < n2) {
                    filterToDrop = filterCopyArray[n];
                    if (filterToDrop.equals(target) || ((FilterCopy)target).hasParent(filterToDrop)) {
                        return false;
                    }
                    ++n;
                }
            }
            filterCopyArray = toDrop;
            n2 = toDrop.length;
            n = 0;
            while (n < n2) {
                filterToDrop = filterCopyArray[n];
                if (target instanceof Filters) {
                    ResourceFilterGroup.this.filters.add(filterToDrop);
                }
                if (target instanceof String) {
                    FilterTypeUtil.setValue(filterToDrop, FilterTypeUtil.MODE, target.equals(includeOnlyGroup) ? 0 : 1);
                    ResourceFilterGroup.this.addToTopLevelFilters(filterToDrop);
                }
                if (target instanceof FilterCopy) {
                    ((FilterCopy)target).addChild(filterToDrop);
                }
                ResourceFilterGroup.this.filterView.refresh();
                ResourceFilterGroup.this.filterView.reveal((Object)filterToDrop);
                ++n;
            }
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (ResourceFilterGroup.this.filterCopyTransfer.isSupportedType(transferType)) {
                if (target instanceof FilterCopy) {
                    return ((FilterCopy)target).canAcceptDrop();
                }
                return true;
            }
            return false;
        }
    }

    class FilterCopyTransfer
    extends ByteArrayTransfer {
        private static final String MYTYPENAME = "org.eclipse.ui.ide.internal.filterCopy";
        private final int MYTYPEID = FilterCopyTransfer.registerType((String)"org.eclipse.ui.ide.internal.filterCopy");

        private FilterCopyTransfer() {
        }

        public void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof FilterCopy[])) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                FilterCopy[] myTypes = (FilterCopy[])object;
                try {
                    byte[] buffer;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    Object var7_7 = null;
                    try (DataOutputStream writeOut = new DataOutputStream(out);){
                        writeOut.writeInt(myTypes.length);
                        FilterCopy[] filterCopyArray = myTypes;
                        int n = myTypes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FilterCopy myType = filterCopyArray[n2];
                            writeOut.writeInt(myType.getSerialNumber());
                            ++n2;
                        }
                        buffer = out.toByteArray();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    super.javaToNative((Object)buffer, transferData);
                }
                catch (IOException iOException) {}
            }
        }

        public Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                FilterCopy[] myData;
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    Throwable throwable = null;
                    Object var6_6 = null;
                    try (DataInputStream readIn = new DataInputStream(in);){
                        int size = readIn.readInt();
                        LinkedList<FilterCopy> droppedFilters = new LinkedList<FilterCopy>();
                        int i = 0;
                        while (i < size) {
                            int serialNumber = readIn.readInt();
                            FilterCopy tmp = ResourceFilterGroup.this.filters.findBySerialNumber(serialNumber);
                            if (tmp != null) {
                                droppedFilters.add(tmp);
                            }
                            ++i;
                        }
                        myData = droppedFilters.toArray(new FilterCopy[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
                return myData;
            }
            return null;
        }

        protected String[] getTypeNames() {
            return new String[]{MYTYPENAME};
        }

        protected int[] getTypeIds() {
            return new int[]{this.MYTYPEID};
        }
    }

    class Filters
    extends FilterCopy {
        boolean changed = false;
        public LinkedList<FilterCopy> trash = new LinkedList();

        public Filters(IContainer resource) {
            try {
                this.children = new LinkedList();
                IResourceFilterDescription[] iResourceFilterDescriptionArray = resource.getFilters();
                int n = iResourceFilterDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceFilterDescription filter = iResourceFilterDescriptionArray[n2];
                    FilterCopy copy = new FilterCopy(UIResourceFilterDescription.wrap(filter));
                    copy = this.convertLegacyMatchers(copy);
                    this.addChild(copy);
                    ++n2;
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)ResourceFilterGroup.this.shell, (String)NLS.bind((String)IDEWorkbenchMessages.InternalError, null), (String)e.getLocalizedMessage(), (IStatus)e.getStatus());
            }
        }

        public Filters(IResourceFilterDescription[] filters) {
            this.children = new LinkedList();
            if (filters != null) {
                IResourceFilterDescription[] iResourceFilterDescriptionArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceFilterDescription filter = iResourceFilterDescriptionArray[n2];
                    this.addChild(new FilterCopy(UIResourceFilterDescription.wrap(filter)));
                    ++n2;
                }
            }
        }

        public Filters(UIResourceFilterDescription[] filters) {
            this.children = new LinkedList();
            if (filters != null) {
                UIResourceFilterDescription[] uIResourceFilterDescriptionArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    UIResourceFilterDescription filter = uIResourceFilterDescriptionArray[n2];
                    this.addChild(new FilterCopy(filter));
                    ++n2;
                }
            }
        }

        public void add(FilterCopy newFilter) {
            super.addChild(newFilter);
            this.changed = true;
        }

        public void remove(FilterCopy filter) {
            super.removeChild(filter);
            if (filter.original != null) {
                this.trash.add(filter);
            }
            this.changed = true;
        }

        public void moveUp(UIResourceFilterDescription filter) {
            FilterCopy[] content = this.getChildren();
            int i = 1;
            while (i < content.length) {
                if (content[i] == filter) {
                    FilterCopy tmp = content[i - 1];
                    content[i - 1] = content[i];
                    content[i] = tmp;
                }
                ++i;
            }
            this.children = new LinkedList<FilterCopy>(Arrays.asList(content));
            this.changed = true;
        }

        public void moveDown(UIResourceFilterDescription filter) {
            FilterCopy[] content = this.getChildren();
            int i = 0;
            while (i < content.length - 1) {
                if (content[i] == filter) {
                    FilterCopy tmp = content[i + 1];
                    content[i + 1] = content[i];
                    content[i] = tmp;
                }
                ++i;
            }
            this.children = new LinkedList<FilterCopy>(Arrays.asList(content));
            this.changed = true;
        }

        @Override
        public int getChildrenLimit() {
            return Integer.MAX_VALUE;
        }

        @Override
        protected void argumentsChanged() {
            this.changed = true;
        }

        @Override
        public boolean hasChanged() {
            if (this.changed) {
                return true;
            }
            for (FilterCopy filter : this.children) {
                if (!filter.hasChanged()) continue;
                return true;
            }
            return false;
        }

        public boolean isFirst(FilterCopy o) {
            if (this.children.size() > 0) {
                return ((FilterCopy)this.children.getFirst()).equals(o);
            }
            return false;
        }

        public boolean isLast(FilterCopy o) {
            if (this.children.size() > 0) {
                return ((FilterCopy)this.children.getLast()).equals(o);
            }
            return false;
        }

        @Override
        public void removeAll() {
            if (this.children.size() > 0) {
                super.removeAll();
                this.changed = true;
            }
        }
    }

    class LabelProvider
    extends StyledCellLabelProvider {
        private final StyledString.Styler fBoldStyler;
        private final StyledString.Styler fPlainStyler;
        FilterTypeUtil util;
        TreeMap<Object, ICustomFilterArgumentUI> customfilterArgumentMap = new TreeMap();

        public LabelProvider() {
            this.util = new FilterTypeUtil();
            this.fBoldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = ((LabelProvider)LabelProvider.this).ResourceFilterGroup.this.boldFont;
                }
            };
            this.fPlainStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = ((LabelProvider)LabelProvider.this).ResourceFilterGroup.this.plainFont;
                }
            };
            ICustomFilterArgumentUI ui = new MultiMatcherCustomFilterArgumentUI(null, null, null);
            this.customfilterArgumentMap.put(ui.getID(), ui);
            ui = new DefaultCustomFilterArgumentUI(null, null, null);
            this.customfilterArgumentMap.put(ui.getID(), ui);
        }

        ICustomFilterArgumentUI getUI(String descriptorID) {
            ICustomFilterArgumentUI result = this.customfilterArgumentMap.get(descriptorID);
            if (result == null) {
                result = this.customfilterArgumentMap.get("");
                return result;
            }
            return result;
        }

        String getColumnID(int index) {
            return (String)ResourceFilterGroup.this.filterView.getColumnProperties()[index];
        }

        public boolean isPartialFilter(Object element) {
            FilterCopy copy = (FilterCopy)element;
            return copy.isUnderAGroupFilter();
        }

        public void update(ViewerCell cell) {
            int columnIndex = cell.getColumnIndex();
            String column = this.getColumnID(columnIndex);
            FilterCopy filter = null;
            Object element = cell.getElement();
            if (element instanceof String) {
                if (column.equals(FilterTypeUtil.MODE)) {
                    cell.setImage(ResourceFilterGroup.this.getImage(FilterTypeUtil.MODE, element.equals(includeOnlyGroup) ? 0 : 1));
                }
                if (column.equals(FilterTypeUtil.MODE)) {
                    if (element.equals(includeOnlyGroup)) {
                        cell.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_includeOnlyColumn, null));
                    } else {
                        cell.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_excludeAllColumn, null));
                    }
                }
            } else {
                filter = (FilterCopy)element;
                if (column.equals(FilterTypeUtil.MODE)) {
                    Object isInheritable;
                    StyledString styledString = this.getStyleColumnText(filter);
                    if (!this.isPartialFilter(filter) && ((Boolean)(isInheritable = FilterTypeUtil.getValue(filter, FilterTypeUtil.INHERITABLE))).booleanValue()) {
                        styledString.append("   " + IDEWorkbenchMessages.ResourceFilterPage_recursive);
                    }
                    cell.setText(styledString.toString());
                    cell.setStyleRanges(styledString.getStyleRanges());
                    if (!this.isPartialFilter(filter)) {
                        Image[] images = new Image[]{ResourceFilterGroup.this.fileIcon, ResourceFilterGroup.this.folderIcon, ResourceFilterGroup.this.fileFolderIcon};
                        Object index = FilterTypeUtil.getValue(filter, FilterTypeUtil.TARGET);
                        cell.setImage(images[(Integer)index]);
                    }
                }
            }
            super.update(cell);
        }

        private StyledString getStyleColumnText(FilterCopy filter) {
            if (filter.getChildrenLimit() > 0) {
                String whiteSpace = " ";
                String expression = this.getFilterTypeName(filter);
                boolean isUnaryOperator = filter.getId().equals("org.eclipse.ui.ide.notFilterMatcher");
                StyledString buffer = new StyledString();
                if (isUnaryOperator) {
                    buffer.append("NOT ", this.fBoldStyler);
                    expression = "OR";
                }
                buffer.append("(", this.fBoldStyler);
                Object[] children = ResourceFilterGroup.this.filterViewContentProvider.getChildren(filter);
                int i = 0;
                while (i < children.length) {
                    buffer.append(this.getStyleColumnText((FilterCopy)children[i]));
                    if (i + 1 < children.length) {
                        buffer.append(whiteSpace, this.fPlainStyler);
                        buffer.append(expression, this.fBoldStyler);
                        buffer.append(whiteSpace, this.fPlainStyler);
                    }
                    ++i;
                }
                if (children.length < 2 && !isUnaryOperator) {
                    if (children.length == 1) {
                        buffer.append(whiteSpace, this.fPlainStyler);
                    }
                    buffer.append(expression, this.fBoldStyler);
                }
                buffer.append(")", this.fBoldStyler);
                return buffer;
            }
            ICustomFilterArgumentUI ui = this.getUI(filter.getId());
            return ui.formatStyledText(filter, this.fPlainStyler, this.fBoldStyler);
        }

        protected void measure(Event event, Object element) {
            super.measure(event, element);
        }

        private String getFilterTypeName(FilterCopy filter) {
            IFilterMatcherDescriptor desc = FilterTypeUtil.getDescriptor(filter.getId());
            if (desc != null) {
                return desc.getName();
            }
            return "";
        }
    }

    class RemoveFilterAction
    extends Action {
        public RemoveFilterAction() {
            this.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_removeFilterActionLabel, null));
        }

        public void run() {
            ResourceFilterGroup.this.handleRemove();
        }

        public boolean isEnabled() {
            ISelection selection = ResourceFilterGroup.this.filterView.getSelection();
            if (selection instanceof IStructuredSelection) {
                return ((IStructuredSelection)selection).size() > 0;
            }
            return false;
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == ResourceFilterGroup.this.filters) {
                if (ResourceFilterGroup.this.filters.getChildren().length > 0) {
                    return new Object[]{includeOnlyGroup, excludeAllGroup};
                }
                return new Object[0];
            }
            if (parentElement instanceof String) {
                ArrayList<FilterCopy> list = new ArrayList<FilterCopy>();
                int mask = parentElement.equals(includeOnlyGroup) ? 1 : 2;
                FilterCopy[] filterCopyArray = ResourceFilterGroup.this.filters.getChildren();
                int n = filterCopyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterCopy filterCopy = filterCopyArray[n2];
                    if ((filterCopy.getType() & mask) != 0) {
                        list.add(filterCopy);
                    }
                    ++n2;
                }
                return list.toArray();
            }
            if (parentElement instanceof FilterCopy) {
                return ((FilterCopy)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                return ResourceFilterGroup.this.filters;
            }
            if (element instanceof FilterCopy) {
                FilterCopy filterCopy = (FilterCopy)element;
                if (filterCopy.getParent() != null && filterCopy.getParent() != ResourceFilterGroup.this.filters) {
                    return filterCopy.getParent();
                }
                return (filterCopy.getType() & 1) != 0 ? includeOnlyGroup : excludeAllGroup;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof FilterCopy || element instanceof String) {
                Object[] children = this.getChildren(element);
                return children != null && children.length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

