/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.metadata.expression.IMemberProvider;

public class InstallableUnit
implements IInstallableUnit,
IMemberProvider {
    private static final Map<IFilterExpression, IMatchExpression<IInstallableUnit>> filterCache = new LinkedHashMap<IFilterExpression, IMatchExpression<IInstallableUnit>>(){

        @Override
        public boolean removeEldestEntry(Map.Entry<IFilterExpression, IMatchExpression<IInstallableUnit>> expr) {
            return this.size() > 64;
        }
    };
    private static final OrderedProperties NO_PROPERTIES = new OrderedProperties();
    private static final IProvidedCapability[] NO_PROVIDES = new IProvidedCapability[0];
    private static final IRequirement[] NO_REQUIRES = new IRequirement[0];
    private static final IArtifactKey[] NO_ARTIFACTS = new IArtifactKey[0];
    private static final ITouchpointData[] NO_TOUCHPOINT_DATA = new ITouchpointData[0];
    private static final ILicense[] NO_LICENSE = new ILicense[0];
    private static final IExpression filterWrap;
    public static final String MEMBER_PROVIDED_CAPABILITIES = "providedCapabilities";
    public static final String MEMBER_ID = "id";
    public static final String MEMBER_VERSION = "version";
    public static final String MEMBER_PROPERTIES = "properties";
    public static final String MEMBER_FILTER = "filter";
    public static final String MEMBER_ARTIFACTS = "artifacts";
    public static final String MEMBER_REQUIREMENTS = "requirements";
    public static final String MEMBER_LICENSES = "licenses";
    public static final String MEMBER_COPYRIGHT = "copyright";
    public static final String MEMBER_TOUCHPOINT_DATA = "touchpointData";
    public static final String MEMBER_TOUCHPOINT_TYPE = "touchpointType";
    public static final String MEMBER_UPDATE_DESCRIPTOR = "updateDescriptor";
    public static final String MEMBER_SINGLETON = "singleton";
    private IArtifactKey[] artifacts = NO_ARTIFACTS;
    private IMatchExpression<IInstallableUnit> filter;
    private String id;
    private OrderedProperties properties;
    private OrderedProperties localizedProperties;
    IProvidedCapability[] providedCapabilities = NO_PROVIDES;
    private IRequirement[] requires = NO_REQUIRES;
    private IRequirement[] metaRequires = NO_REQUIRES;
    private boolean singleton;
    private ITouchpointData[] touchpointData = NO_TOUCHPOINT_DATA;
    private ITouchpointType touchpointType;
    private Version version = Version.emptyVersion;
    private IUpdateDescriptor updateInfo;
    private ILicense[] licenses = NO_LICENSE;
    private ICopyright copyright;
    public static final String MEMBER_TRANSLATED_PROPERTIES = "translatedProperties";
    public static final String MEMBER_PROFILE_PROPERTIES = "profileProperties";
    static final Comparator<IInstallableUnit> ID_FIRST_THEN_VERSION;

    static {
        IExpressionFactory factory = ExpressionUtil.getFactory();
        filterWrap = factory.matches(factory.member(factory.thisVariable(), MEMBER_PROPERTIES), factory.indexedParameter(0));
        ID_FIRST_THEN_VERSION = Comparator.comparing(IVersionedId::getId).thenComparing(IVersionedId::getVersion);
    }

    public void addTouchpointData(ITouchpointData newData) {
        int tl = this.touchpointData.length;
        if (tl == 0) {
            this.touchpointData = new ITouchpointData[]{newData};
        } else {
            ITouchpointData[] newDatas = new ITouchpointData[tl + 1];
            System.arraycopy(this.touchpointData, 0, newDatas, 0, tl);
            newDatas[tl] = newData;
            this.touchpointData = newDatas;
        }
    }

    @Override
    public int compareTo(IInstallableUnit other) {
        return ID_FIRST_THEN_VERSION.compare(this, other);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object object = obj;
        if (object instanceof IInstallableUnit) {
            void unit;
            IInstallableUnit iInstallableUnit = (IInstallableUnit)object;
            IInstallableUnit cfr_ignored_0 = (IInstallableUnit)object;
            if (Objects.equals(this.getId(), unit.getId()) && Objects.equals(this.getVersion(), unit.getVersion())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<IArtifactKey> getArtifacts() {
        return CollectionUtils.unmodifiableList((Object[])this.artifacts);
    }

    @Override
    public IMatchExpression<IInstallableUnit> getFilter() {
        return this.filter;
    }

    @Override
    public Collection<IInstallableUnitFragment> getFragments() {
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, String> getProperties() {
        return OrderedProperties.unmodifiableProperties((Map)this.properties());
    }

    public String getLocalizedProperty(String key) {
        return this.localizedProperties != null ? this.localizedProperties.getProperty(key) : null;
    }

    @Override
    public String getProperty(String key) {
        return this.properties().getProperty(key);
    }

    @Override
    public Collection<IProvidedCapability> getProvidedCapabilities() {
        return CollectionUtils.unmodifiableList((Object[])this.providedCapabilities);
    }

    @Override
    public String getProperty(String key, String locale) {
        return TranslationSupport.getInstance().getIUProperty(this, key, locale);
    }

    public List<IRequirement> getRequirements() {
        return CollectionUtils.unmodifiableList((Object[])this.requires);
    }

    @Override
    public Collection<ITouchpointData> getTouchpointData() {
        return CollectionUtils.unmodifiableList((Object[])this.touchpointData);
    }

    @Override
    public ITouchpointType getTouchpointType() {
        return this.touchpointType != null ? this.touchpointType : ITouchpointType.NONE;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.getVersion());
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    private OrderedProperties properties() {
        return this.properties != null ? this.properties : NO_PROPERTIES;
    }

    public void setArtifacts(IArtifactKey[] value) {
        this.artifacts = value == null || value.length == 0 ? NO_ARTIFACTS : value;
    }

    public void setCapabilities(IProvidedCapability[] newCapabilities) {
        this.providedCapabilities = newCapabilities == null || newCapabilities.length == 0 ? NO_PROVIDES : newCapabilities;
    }

    public void setFilter(IMatchExpression<IInstallableUnit> filter) {
        this.filter = filter;
    }

    public void setFilter(String filter) {
        this.setFilter(InstallableUnit.parseFilter(filter));
    }

    public void setId(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMatchExpression<IInstallableUnit> parseFilter(String filterStr) {
        IFilterExpression filter = ExpressionUtil.parseLDAP(filterStr);
        if (filter == null) {
            return null;
        }
        Map<IFilterExpression, IMatchExpression<IInstallableUnit>> map = filterCache;
        synchronized (map) {
            IMatchExpression<IInstallableUnit> matchExpr = filterCache.get(filter);
            if (matchExpr != null) {
                return matchExpr;
            }
            matchExpr = ExpressionUtil.getFactory().matchExpression(filterWrap, filter);
            filterCache.put(filter, matchExpr);
            return matchExpr;
        }
    }

    public String setLocalizedProperty(String key, String value) {
        if (this.localizedProperties == null) {
            this.localizedProperties = new OrderedProperties();
        }
        return this.localizedProperties.put(key, value);
    }

    public String setProperty(String key, String value) {
        if (value == null) {
            return this.properties != null ? this.properties.remove((Object)key) : null;
        }
        if (this.properties == null) {
            this.properties = new OrderedProperties();
        }
        return (String)this.properties.setProperty(key, value);
    }

    public void setRequiredCapabilities(IRequirement[] capabilities) {
        this.requires = capabilities.length == 0 ? NO_REQUIRES : (IRequirement[])capabilities.clone();
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setTouchpointType(ITouchpointType type) {
        this.touchpointType = type != ITouchpointType.NONE ? type : null;
    }

    public void setVersion(Version newVersion) {
        this.version = newVersion != null ? newVersion : Version.emptyVersion;
    }

    public String toString() {
        return this.id + " " + String.valueOf(this.getVersion());
    }

    @Override
    public IInstallableUnit unresolved() {
        return this;
    }

    @Override
    public IUpdateDescriptor getUpdateDescriptor() {
        return this.updateInfo;
    }

    public void setUpdateDescriptor(IUpdateDescriptor updateInfo) {
        this.updateInfo = updateInfo;
    }

    public void setLicenses(ILicense[] license) {
        this.licenses = license == null ? NO_LICENSE : license;
    }

    @Override
    public Collection<ILicense> getLicenses() {
        return CollectionUtils.unmodifiableList((Object[])this.licenses);
    }

    @Override
    public Collection<ILicense> getLicenses(String locale) {
        return CollectionUtils.unmodifiableList((Object[])TranslationSupport.getInstance().getLicenses(this, locale));
    }

    public void setCopyright(ICopyright copyright) {
        this.copyright = copyright;
    }

    @Override
    public ICopyright getCopyright() {
        return this.copyright;
    }

    @Override
    public ICopyright getCopyright(String locale) {
        return TranslationSupport.getInstance().getCopyright(this, locale);
    }

    @Override
    public boolean satisfies(IRequirement candidate) {
        return candidate.isMatch(this);
    }

    @Override
    public Collection<IRequirement> getMetaRequirements() {
        return CollectionUtils.unmodifiableList((Object[])this.metaRequires);
    }

    public void setMetaRequiredCapabilities(IRequirement[] metaReqs) {
        this.metaRequires = metaReqs.length == 0 ? NO_REQUIRES : (IRequirement[])metaReqs.clone();
    }

    @Override
    public Object getMember(String memberName) {
        return switch (memberName) {
            case MEMBER_PROVIDED_CAPABILITIES -> this.providedCapabilities;
            case MEMBER_ID -> this.id;
            case MEMBER_VERSION -> this.version;
            case MEMBER_PROPERTIES -> this.properties;
            case MEMBER_FILTER -> this.filter;
            case MEMBER_ARTIFACTS -> this.artifacts;
            case MEMBER_REQUIREMENTS -> this.requires;
            case MEMBER_LICENSES -> this.licenses;
            case MEMBER_COPYRIGHT -> this.copyright;
            case MEMBER_TOUCHPOINT_DATA -> this.touchpointData;
            case MEMBER_TOUCHPOINT_TYPE -> this.touchpointType;
            case MEMBER_UPDATE_DESCRIPTOR -> this.updateInfo;
            case MEMBER_SINGLETON -> this.singleton;
            default -> throw new IllegalArgumentException("No such member: " + memberName);
        };
    }

    public static IInstallableUnit contextIU(String ws, String os, String arch) {
        InstallableUnit ctxIU = new InstallableUnit();
        ctxIU.setId("org.eclipse.equinox.p2.context.iu");
        ctxIU.setProperty("osgi.ws", ws);
        ctxIU.setProperty("osgi.os", os);
        ctxIU.setProperty("osgi.arch", arch);
        return ctxIU;
    }

    public static IInstallableUnit contextIU(Map<String, String> environment) {
        InstallableUnit ctxIU = new InstallableUnit();
        ctxIU.setId("org.eclipse.equinox.p2.context.iu");
        environment.forEach(ctxIU::setProperty);
        return ctxIU;
    }
}

