/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.consumable;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.custom.StructuredTextCharTypes;
import org.eclipse.equinox.bidi.custom.StructuredTextOffsets;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.StructuredTextActivator;

public class StructuredTextSql
extends StructuredTextTypeHandler {
    private static final byte WS = 12;
    static final String lineSep = StructuredTextActivator.getProperty("line.separator");
    private static final Integer STATE_LITERAL = 2;
    private static final Integer STATE_SLASH_ASTER_COMMENT = 4;

    public StructuredTextSql() {
        super("\t!#%&()*+,-./:;<=>?|[]{}");
    }

    @Override
    public int getSpecialsCount(IStructuredTextExpert expert) {
        return 5;
    }

    @Override
    public int indexOfSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int fromIndex) {
        switch (caseNumber) {
            case 1: {
                return text.indexOf(" ", fromIndex);
            }
            case 2: {
                return text.indexOf(39, fromIndex);
            }
            case 3: {
                return text.indexOf(34, fromIndex);
            }
            case 4: {
                return text.indexOf("/*", fromIndex);
            }
            case 5: {
                return text.indexOf("--", fromIndex);
            }
        }
        return -1;
    }

    @Override
    public int processSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int separLocation) {
        StructuredTextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
        if (separLocation < 0) {
            caseNumber = (Integer)expert.getState();
            expert.clearState();
        }
        switch (caseNumber) {
            case 1: {
                ++separLocation;
                while (separLocation < text.length() && text.charAt(separLocation) == ' ') {
                    charTypes.setBidiTypeAt(separLocation, (byte)12);
                    ++separLocation;
                }
                return separLocation;
            }
            case 2: {
                int location = separLocation + 1;
                while (true) {
                    if ((location = text.indexOf(39, location)) < 0) {
                        expert.setState(STATE_LITERAL);
                        return text.length();
                    }
                    if (location + 1 >= text.length() || text.charAt(location + 1) != '\'') break;
                    location += 2;
                }
                return location + 1;
            }
            case 3: {
                int location = separLocation + 1;
                while (true) {
                    if ((location = text.indexOf(34, location)) < 0) {
                        return text.length();
                    }
                    if (location + 1 >= text.length() || text.charAt(location + 1) != '\"') break;
                    location += 2;
                }
                return location + 1;
            }
            case 4: {
                int location = separLocation < 0 ? 0 : separLocation + 2;
                location = text.indexOf("*/", location);
                if (location < 0) {
                    expert.setState(STATE_SLASH_ASTER_COMMENT);
                    return text.length();
                }
                StructuredTextTypeHandler.processSeparator(text, charTypes, offsets, location);
                return location + 2;
            }
            case 5: {
                int location = text.indexOf(lineSep, separLocation + 2);
                if (location < 0) {
                    return text.length();
                }
                return location + lineSep.length();
            }
        }
        return text.length();
    }
}

