/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.util;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.internal.base.BasePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseValidator
extends EObjectValidator {
    public static final BaseValidator INSTANCE = new BaseValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.oomph.base";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    public static final int WELL_FORMED_SOURCE_URI = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    public static final EValidator.PatternMatcher[][] ID__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"[\\i-[:]][\\c-[:]]*")}};

    protected EPackage getEPackage() {
        return BasePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateModelElement((ModelElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateAnnotation((Annotation)value, diagnostics, context);
            }
            case 2: {
                return this.validateStringToStringMapEntry((Map.Entry)value, diagnostics, context);
            }
            case 3: {
                return this.validateURI((URI)value, diagnostics, context);
            }
            case 4: {
                return this.validateException((Exception)value, diagnostics, context);
            }
            case 5: {
                return this.validateText((String)value, diagnostics, context);
            }
            case 6: {
                return this.validateID((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateModelElement(ModelElement modelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(modelElement, diagnostics, context);
    }

    public boolean validateAnnotation(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(annotation, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(annotation, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(annotation, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAnnotation_WellFormedSourceURI(annotation, diagnostics, context);
        }
        return result;
    }

    public boolean validateAnnotation_WellFormedSourceURI(Annotation annotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        String source = annotation.getSource();
        boolean bl = result = source == null || BaseValidator.isWellFormedURI(source);
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 1, "_UI_AnnotationSourceURINotWellFormed_diagnostic", new Object[]{source}, new Object[]{annotation, BasePackage.Literals.ANNOTATION__SOURCE}, context));
        }
        return result;
    }

    protected static boolean isWellFormedURI(String uri) {
        try {
            return uri != null && uri.length() != 0 && uri.equals(URI.createURI((String)uri, (boolean)true).toString());
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    public boolean validateStringToStringMapEntry(Map.Entry<?, ?> stringToStringMapEntry, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)stringToStringMapEntry, diagnostics, context);
    }

    public boolean validateURI(URI uri, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateException(Exception exception, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateText(String text, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateID(String id, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateID_Pattern(id, diagnostics, context);
        return result;
    }

    public boolean validateID_Pattern(String id, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(BasePackage.Literals.ID, id, ID__PATTERN__VALUES, diagnostics, context);
    }

    protected void reportDataValuePatternViolation(EDataType eDataType, Object value, EValidator.PatternMatcher[] patterns, DiagnosticChain diagnostics, Map<Object, Object> context) {
        diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 9, "_UI_IDConstraint_diagnostic", new Object[]{BaseValidator.getValueLabel((EDataType)eDataType, (Object)value, context)}, new Object[]{value, eDataType, patterns}, context));
    }

    public ResourceLocator getResourceLocator() {
        return BasePlugin.INSTANCE;
    }
}

