/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class LTKLauncher {
    private static final String LTK_DELETE_ID = "org.eclipse.ltk.ui.refactoring.commands.deleteResources";
    private static final String LTK_MOVE_ID = "org.eclipse.ltk.ui.refactoring.commands.moveResources";
    private static final String LTK_RENAME_ID = "org.eclipse.ltk.ui.refactoring.commands.renameResource";
    private static final String LTK_RENAME_COMMAND_NEWNAME_PARAMETER_KEY = "org.eclipse.ltk.ui.refactoring.commands.renameResource.newName.parameter.key";

    public static boolean openDeleteWizard(IStructuredSelection structuredSelection) {
        return LTKLauncher.runCommand(LTK_DELETE_ID, structuredSelection, Collections.emptyMap());
    }

    public static boolean openMoveWizard(IStructuredSelection structuredSelection) {
        return LTKLauncher.runCommand(LTK_MOVE_ID, structuredSelection, Collections.emptyMap());
    }

    public static boolean openRenameWizard(String newName, IStructuredSelection structuredSelection) {
        Map<String, Object> commandParameters = newName != null ? Collections.singletonMap(LTK_RENAME_COMMAND_NEWNAME_PARAMETER_KEY, newName) : Collections.emptyMap();
        return LTKLauncher.runCommand(LTK_RENAME_ID, structuredSelection, commandParameters);
    }

    private static boolean runCommand(String commandId, IStructuredSelection selection, Map<String, Object> commandParameters) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = commandService.getCommand(commandId);
        if (!cmd.isDefined()) {
            return false;
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        EvaluationContext c = null;
        if (selection != null) {
            c = new EvaluationContext(handlerService.createContextSnapshot(false), (Object)selection.toList());
            c.addVariable("selection", (Object)selection);
            for (Map.Entry<String, Object> entry : commandParameters.entrySet()) {
                c.addVariable(entry.getKey(), entry.getValue());
            }
        }
        try {
            if (c != null) {
                handlerService.executeCommandInContext(new ParameterizedCommand(cmd, null), null, (IEvaluationContext)c);
            } else {
                handlerService.executeCommand(commandId, null);
            }
            return true;
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException throwable) {
            return false;
        }
    }
}

