/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CompositeElement;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.internal.css.swt.dom.scrollbar.StyledTextThemedScrollBarAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

public class StyledTextElement
extends CompositeElement {
    public StyledTextElement(Composite composite, CSSEngine engine) {
        super(composite, engine);
    }

    public StyledText getStyledText() {
        return (StyledText)this.getControl();
    }

    private StyledTextThemedScrollBarAdapter getScrollbarAdapter() {
        return StyledTextThemedScrollBarAdapter.getScrollbarAdapter(this.getStyledText());
    }

    public void setScrollBarBackgroundColor(Color newColor) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setScrollBarBackgroundColor(newColor);
        }
    }

    public void setScrollBarForegroundColor(Color newColor) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setScrollBarForegroundColor(newColor);
        }
    }

    public void setScrollBarWidth(int width) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setScrollBarWidth(width);
        }
    }

    public void setMouseNearScrollScrollBarWidth(int width) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setMouseNearScrollScrollBarWidth(width);
        }
    }

    public void setVerticalScrollBarVisible(boolean visible) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setVerticalScrollBarVisible(visible);
        }
    }

    public void setHorizontalScrollBarVisible(boolean visible) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setHorizontalScrollBarVisible(visible);
        }
    }

    public void setScrollBarBorderRadius(int radius) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setScrollBarBorderRadius(radius);
        }
    }

    private void setScrollBarThemed(boolean themed) {
        StyledTextThemedScrollBarAdapter scrollbarAdapter = this.getScrollbarAdapter();
        if (scrollbarAdapter != null) {
            scrollbarAdapter.setScrollBarThemed(themed);
        }
    }

    @Override
    public void reset() {
        this.setScrollBarThemed(false);
        super.reset();
    }

    public void setScrollBarThemed(String cssText) {
        String value = System.getProperty("swt.enable.themedScrollBar");
        if (value != null) {
            if ("true".equalsIgnoreCase(value)) {
                this.setScrollBarThemed(true);
            } else {
                this.setScrollBarThemed(false);
            }
        } else if ("true".equalsIgnoreCase(cssText)) {
            this.setScrollBarThemed(true);
        } else if ("false".equalsIgnoreCase(cssText)) {
            this.setScrollBarThemed(false);
        } else {
            CSSActivator.getDefault().log(2, "Don't know how to handle setting value: " + cssText + " (supported: boolean or preference:bundle.qualifier.id/key).");
        }
    }
}

