/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.mirroring;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

public class XMLMirrorLog
implements IArtifactMirrorLog {
    private static final String DEFAULT_FORMAT = "canonical";
    private static final String LOG = "log";
    private static final String TIME_ATTRIBUTE = "time";
    private static final String DESCRIPTOR_ELEMENT = "descriptor";
    private static final String DESCRIPTOR_CLASSIFIER_ATTRIBUTE = "classifier";
    private static final String DESCRIPTOR_FORMAT_ATTRIBUTE = "format";
    private static final String DESCRIPTOR_ID_ATTRIBUTE = "id";
    private static final String DESCRIPTOR_VERSION_ATTRIBUTE = "version";
    private static final String STATUS_ELEMENT = "status";
    private static final String STATUS_SEVERITY_ATTRIBUTE = "severity";
    private static final String STATUS_MESSAGE_ATTRIBUTE = "message";
    private int minStatus = 0;
    private XMLWriter writer;
    private OutputStream outputStream;
    private boolean consoleMessage = false;

    public XMLMirrorLog(String location, int minStatus, String root) {
        this.minStatus = minStatus;
        try {
            this.outputStream = new FileOutputStream(location);
            this.writer = new XMLWriter(this.outputStream, null);
            if (root != null) {
                this.writer.start(root.toLowerCase());
            } else {
                this.writer.start(LOG);
            }
            this.writer.attribute(TIME_ATTRIBUTE, (Object)new Date());
        }
        catch (FileNotFoundException e) {
            this.exceptionOccurred(e);
        }
    }

    @Override
    public void log(IArtifactDescriptor descriptor, IStatus status) {
        if (status.getSeverity() < this.minStatus) {
            return;
        }
        if (this.writer != null) {
            this.writer.start(DESCRIPTOR_ELEMENT);
            this.writer.attribute(DESCRIPTOR_ID_ATTRIBUTE, (Object)descriptor.getArtifactKey().getId());
            this.writer.attribute(DESCRIPTOR_CLASSIFIER_ATTRIBUTE, (Object)descriptor.getArtifactKey().getClassifier());
            this.writer.attribute(DESCRIPTOR_VERSION_ATTRIBUTE, (Object)descriptor.getArtifactKey().getVersion());
            if (descriptor.getProperties().get(DESCRIPTOR_FORMAT_ATTRIBUTE) != null) {
                this.writer.attribute(DESCRIPTOR_FORMAT_ATTRIBUTE, descriptor.getProperties().get(DESCRIPTOR_FORMAT_ATTRIBUTE));
            } else {
                this.writer.attribute(DESCRIPTOR_FORMAT_ATTRIBUTE, (Object)DEFAULT_FORMAT);
            }
        } else {
            System.out.println(descriptor);
        }
        this.log(status);
        if (this.writer != null) {
            this.writer.end();
        }
    }

    @Override
    public void log(IStatus status) {
        if (status.getSeverity() < this.minStatus) {
            return;
        }
        if (this.writer != null) {
            this.writer.start(STATUS_ELEMENT);
            switch (status.getSeverity()) {
                case 0: {
                    this.writer.attribute(STATUS_SEVERITY_ATTRIBUTE, (Object)"OK");
                    break;
                }
                case 1: {
                    this.writer.attribute(STATUS_SEVERITY_ATTRIBUTE, (Object)"INFO");
                    break;
                }
                case 2: {
                    this.writer.attribute(STATUS_SEVERITY_ATTRIBUTE, (Object)"WARNING");
                    break;
                }
                case 4: {
                    this.writer.attribute(STATUS_SEVERITY_ATTRIBUTE, (Object)"ERROR");
                    break;
                }
                case 8: {
                    this.writer.attribute(STATUS_SEVERITY_ATTRIBUTE, (Object)"CANCEL");
                    break;
                }
                default: {
                    this.writer.attribute(STATUS_SEVERITY_ATTRIBUTE, status.getSeverity());
                }
            }
            this.writer.attribute(STATUS_MESSAGE_ATTRIBUTE, (Object)status.getMessage());
        } else {
            System.out.println(status);
        }
        IStatus[] nestedStatus = status.getChildren();
        if (nestedStatus != null) {
            int i = 0;
            while (i < nestedStatus.length) {
                this.log(nestedStatus[i]);
                ++i;
            }
        }
        if (this.writer != null) {
            this.writer.end();
        }
    }

    @Override
    public void close() {
        try {
            if (this.writer != null) {
                this.writer.end();
                this.writer.flush();
            }
        }
        finally {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    this.exceptionOccurred(e);
                }
            }
        }
    }

    private void exceptionOccurred(Exception e) {
        if (!this.consoleMessage) {
            System.err.println(Messages.MirrorLog_Exception_Occurred);
            e.printStackTrace(System.err);
            System.err.println(Messages.MirrorLog_Console_Log);
            this.consoleMessage = true;
        }
    }
}

