/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebKit;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

class WebkitGDBus {
    private static String DBUS_SERVICE_NAME;
    private static final String DBUS_OBJECT_PATH = "/org/eclipse/swt/gdbus";
    private static final String INTERFACE_NAME = "org.eclipse.swt.gdbusInterface";
    private static final String EXTENSION_INTERFACE_NAME = "org.eclipse.swt.webkitgtk_extension.gdbusInterface";
    private static String EXTENSION_DBUS_NAME;
    private static String EXTENSION_DBUS_PATH;
    private static final String webkit2callJava;
    private static final String webkitWebExtensionIdentifier;
    static long proxy;
    static boolean proxyToExtension;
    static boolean functionsPending;
    static HashMap<Long, ArrayList<ArrayList<String>>> pendingBrowserFunctions;
    private static final String dbus_introspection_xml;
    private static final byte SWT_DBUS_MAGIC_NUMBER_EMPTY_ARRAY = 101;
    private static final byte SWT_DBUS_MAGIC_NUMBER_NULL = 48;
    private static Callback onBusAcquiredCallback;
    private static Callback onNameAcquiredCallback;
    private static Callback onNameLostCallback;
    private static Callback handleMethodCallback;
    private static Callback callExtensionAsyncCallback;
    static boolean initialized;

    static {
        webkit2callJava = WebKit.Webkit2Extension.getJavaScriptFunctionName();
        webkitWebExtensionIdentifier = WebKit.Webkit2Extension.getWebExtensionIdentifer();
        pendingBrowserFunctions = new HashMap();
        dbus_introspection_xml = "<node>  <interface name='org.eclipse.swt.gdbusInterface'>    <method name='" + webkit2callJava + "'>" + "      <arg type='" + "s" + "' name='webViewPtr' direction='in'/>" + "      <arg type='" + "d" + "' name='index' direction='in'/>" + "      <arg type='" + "s" + "' name='token' direction='in'/>" + "      <arg type='" + "*" + "' name='arguments' direction='in'/>" + "      <arg type='" + "*" + "' name='result' direction='out'/>" + "    </method>" + "\t<method name='" + webkitWebExtensionIdentifier + "'>" + "      <arg type='" + "s" + "' name='webExtensionDbusName' direction='in'/>" + "      <arg type='" + "s" + "' name='webExtensionDbusPath' direction='in'/>" + "      <arg type='" + "a(tss)" + "' name='result' direction='out'/>" + "    </method>" + "  </interface>" + "</node>";
        onBusAcquiredCallback = new Callback(WebkitGDBus.class, "onBusAcquiredCallback", 3);
        if (onBusAcquiredCallback.getAddress() == 0L) {
            SWT.error(3);
        }
        if ((onNameAcquiredCallback = new Callback(WebkitGDBus.class, "onNameAcquiredCallback", 3)).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((onNameLostCallback = new Callback(WebkitGDBus.class, "onNameLostCallback", 3)).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((handleMethodCallback = new Callback(WebkitGDBus.class, "handleMethodCallback", 8)).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((callExtensionAsyncCallback = new Callback(WebkitGDBus.class, "callExtensionAsyncCallback", 3)).getAddress() == 0L) {
            SWT.error(3);
        }
    }

    WebkitGDBus() {
    }

    static void init(String uniqueId) {
        if (initialized) {
            return;
        }
        initialized = true;
        DBUS_SERVICE_NAME = "org.eclipse.swt" + uniqueId;
        int owner_id = OS.g_bus_own_name(2, Converter.javaStringToCString(DBUS_SERVICE_NAME), 3, onBusAcquiredCallback.getAddress(), onNameAcquiredCallback.getAddress(), onNameLostCallback.getAddress(), 0L, 0L);
        if (owner_id == 0) {
            System.err.println("SWT WebkitGDBus: Failed to aquire bus name: " + DBUS_SERVICE_NAME);
        }
    }

    private static void teardown_gdbus() {
    }

    private static long onBusAcquiredCallback(long connection, long name, long user_data) {
        long[] error = new long[1];
        long gdBusNodeInfo = OS.g_dbus_node_info_new_for_xml(Converter.javaStringToCString(dbus_introspection_xml), error);
        if (gdBusNodeInfo == 0L || error[0] != 0L) {
            System.err.println("SWT WebkitGDBus: Failed to get introspection data");
        }
        assert (gdBusNodeInfo != 0L) : "SWT WebkitGDBus: introspection data should not be 0";
        error = new long[1];
        long interface_info = OS.g_dbus_node_info_lookup_interface(gdBusNodeInfo, Converter.javaStringToCString(INTERFACE_NAME));
        long[] lArray = new long[3];
        lArray[0] = handleMethodCallback.getAddress();
        long[] vtable = lArray;
        OS.g_dbus_connection_register_object(connection, Converter.javaStringToCString(DBUS_OBJECT_PATH), interface_info, vtable, 0L, 0L, error);
        if (error[0] != 0L) {
            System.err.println("SWT WebkitGDBus: Failed to register object: /org/eclipse/swt/gdbus");
            return 0L;
        }
        return 0L;
    }

    private static long onNameAcquiredCallback(long connection, long name, long user_data) {
        return 0L;
    }

    private static long onNameLostCallback(long connection, long name, long user_data) {
        assert (false) : "This code should never have executed";
        System.err.println("SWT WebkitGDBus.java: Lost GDBus name. This should never occur");
        return 0L;
    }

    private static long handleMethodCallback(long connection, long sender, long object_path, long interface_name, long method_name, long gvar_parameters, long invocation, long user_data) {
        String java_method_name = Converter.cCharPtrToJavaString(method_name, false);
        Object result = null;
        if (java_method_name != null) {
            if (java_method_name.equals(webkit2callJava)) {
                try {
                    Object[] java_parameters = (Object[])WebkitGDBus.convertGVariantToJava(gvar_parameters);
                    result = WebKit.Webkit2Extension.webkit2callJavaCallback(java_parameters);
                }
                catch (Exception e) {
                    result = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                    System.err.println("SWT Webkit: Exception occured in Webkit2 callback logic. Bug?");
                }
            } else if (java_method_name.equals(webkitWebExtensionIdentifier)) {
                Object[] nameArray = (Object[])WebkitGDBus.convertGVariantToJava(gvar_parameters);
                if (nameArray[0] != null && nameArray[0] instanceof String) {
                    EXTENSION_DBUS_NAME = (String)nameArray[0];
                }
                if (nameArray[1] != null && nameArray[1] instanceof String) {
                    EXTENSION_DBUS_PATH = (String)nameArray[1];
                }
                if (proxyToExtension = WebkitGDBus.proxyToExtensionInit()) {
                    WebkitGDBus.invokeReturnValueExtensionIdentifier(pendingBrowserFunctions, invocation);
                } else {
                    WebkitGDBus.invokeReturnValueExtensionIdentifier(null, invocation);
                    System.err.println("SWT webkit: proxy to web extension failed to load, BrowserFunction may not work.");
                }
                return 0L;
            }
        } else {
            result = "SWT webkit: GDBus called an unknown method?";
            System.err.println("SWT webkit: Received a call from an unknown method: " + java_method_name);
        }
        WebkitGDBus.invokeReturnValue(result, invocation);
        return 0L;
    }

    private static long callExtensionAsyncCallback(long source_object, long res, long user_data) {
        long[] gerror = new long[1];
        OS.g_dbus_proxy_call_finish(proxy, res, gerror);
        if (gerror[0] != 0L) {
            long errMsg = OS.g_error_get_message(gerror[0]);
            String msg = Converter.cCharPtrToJavaString(errMsg, false);
            System.err.println("SWT webkit: There was an error executing something asynchronously with the extension (Java callback).");
            System.err.println("SWT webkit: the error message provided is " + msg);
            OS.g_error_free(gerror[0]);
        }
        return 0L;
    }

    private static void invokeReturnValueExtensionIdentifier(HashMap<Long, ArrayList<ArrayList<String>>> map, long invocation) {
        boolean sendEmptyFunction;
        long type = OS.g_variant_type_new(OS.G_VARIANT_TYPE_ARRAY_BROWSER_FUNCS);
        long builder = OS.g_variant_builder_new(type);
        if (builder == 0L) {
            return;
        }
        Object[] tupleArray = new Object[3];
        if (map == null) {
            sendEmptyFunction = true;
        } else {
            boolean bl = sendEmptyFunction = map.isEmpty() && !functionsPending;
        }
        if (sendEmptyFunction) {
            tupleArray[0] = -1L;
            tupleArray[1] = "";
            tupleArray[2] = "";
            long tupleGVariant = WebkitGDBus.convertJavaToGVariant(tupleArray);
            if (tupleGVariant != 0L) {
                OS.g_variant_builder_add_value(builder, tupleGVariant);
            } else {
                System.err.println("SWT webkit: error creating empty BrowserFunction GVariant tuple, skipping.");
            }
        } else {
            for (long id : map.keySet()) {
                ArrayList<ArrayList<String>> list = map.get(id);
                if (list == null) continue;
                for (ArrayList<String> stringList : list) {
                    Object[] stringArray = stringList.toArray();
                    if (stringArray.length > 2) {
                        System.err.println("SWT webkit: String array with BrowserFunction and URL should never havemore than 2 Strings");
                    }
                    tupleArray[0] = id;
                    System.arraycopy(stringArray, 0, tupleArray, 1, 2);
                    long tupleGVariant = WebkitGDBus.convertJavaToGVariant(tupleArray);
                    if (tupleGVariant != 0L) {
                        OS.g_variant_builder_add_value(builder, tupleGVariant);
                        continue;
                    }
                    System.err.println("SWT webkit: error creating BrowserFunction GVariant tuple, skipping.");
                }
            }
        }
        long resultGVariant = OS.g_variant_builder_end(builder);
        String typeString = Converter.cCharPtrToJavaString(OS.g_variant_get_type_string(resultGVariant), false);
        if (!"a(tss)".equals(typeString)) {
            System.err.println("An error packaging the GVariant occurred: type mismatch.");
        }
        long[] variants = new long[]{resultGVariant};
        long finalGVariant = OS.g_variant_new_tuple(variants, 1L);
        OS.g_dbus_method_invocation_return_value(invocation, finalGVariant);
        OS.g_variant_builder_unref(builder);
    }

    private static void invokeReturnValue(Object result, long invocation) {
        long resultGVariant = 0L;
        try {
            resultGVariant = WebkitGDBus.convertJavaToGVariant(new Object[]{result});
        }
        catch (SWTException e) {
            String errMsg = WebBrowser.CreateErrorString(e.getLocalizedMessage());
            resultGVariant = WebkitGDBus.convertJavaToGVariant(new Object[]{errMsg});
        }
        OS.g_dbus_method_invocation_return_value(invocation, resultGVariant);
    }

    private static boolean proxyToExtensionInit() {
        if (proxy != 0L) {
            return true;
        }
        if (EXTENSION_DBUS_NAME != null && EXTENSION_DBUS_PATH != null) {
            long[] error = new long[1];
            byte[] name = Converter.javaStringToCString(EXTENSION_DBUS_NAME);
            byte[] path = Converter.javaStringToCString(EXTENSION_DBUS_PATH);
            byte[] interfaceName = Converter.javaStringToCString(EXTENSION_INTERFACE_NAME);
            proxy = OS.g_dbus_proxy_new_for_bus_sync(2, 0, 0L, name, path, interfaceName, 0L, error);
            if (error[0] != 0L) {
                long errMsg = OS.g_error_get_message(error[0]);
                String msg = Converter.cCharPtrToJavaString(errMsg, false);
                OS.g_error_free(error[0]);
                System.err.println("SWT webkit: there was an error establishing the proxy connection to the extension.  The error is " + msg);
                return false;
            }
            return true;
        }
        return false;
    }

    static Object callExtensionSync(long params, String methodName) {
        Object resultObject;
        long[] gerror = new long[1];
        long gVariant = OS.g_dbus_proxy_call_sync(proxy, Converter.javaStringToCString(methodName), params, 1, 1000, 0L, gerror);
        if (gerror[0] != 0L) {
            long errMsg = OS.g_error_get_message(gerror[0]);
            String msg = Converter.cCharPtrToJavaString(errMsg, false);
            if (msg != null && !msg.contains("Timeout") && !msg.contains("timeout")) {
                System.err.println("SWT webkit: There was an error executing something synchronously with the extension.");
                System.err.println("SWT webkit: The error message is: " + msg);
                return false;
            }
            OS.g_error_free(gerror[0]);
            return "timeout";
        }
        Object object = resultObject = gVariant != 0L ? WebkitGDBus.convertGVariantToJava(gVariant) : Boolean.valueOf(false);
        if (resultObject instanceof Object[]) {
            return ((Object[])resultObject)[0];
        }
        return resultObject;
    }

    static boolean callExtensionAsync(long params, String methodName) {
        long[] gerror = new long[1];
        OS.g_dbus_proxy_call(proxy, Converter.javaStringToCString(methodName), params, 1, 1000, 0L, callExtensionAsyncCallback.getAddress(), gerror);
        if (gerror[0] != 0L) {
            long errMsg = OS.g_error_get_message(gerror[0]);
            String msg = Converter.cCharPtrToJavaString(errMsg, false);
            System.err.println("SWT webkit: There was an error executing something asynchronously with the extension.");
            System.err.println("SWT webkit: The error message is: " + msg);
            OS.g_error_free(gerror[0]);
            return false;
        }
        return true;
    }

    private static Object convertGVariantToJava(long gVariant) {
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_BOOLEAN)) {
            return new Boolean(OS.g_variant_get_boolean(gVariant));
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_BYTE)) {
            byte byteVal = OS.g_variant_get_byte(gVariant);
            switch (byteVal) {
                case 48: {
                    return null;
                }
                case 101: {
                    return new Object[0];
                }
            }
            System.err.println("SWT Error, received unsupported byte type via gdbus: " + byteVal);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_DOUBLE)) {
            return new Double(OS.g_variant_get_double(gVariant));
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_UINT64)) {
            return new Long(OS.g_variant_get_uint64(gVariant));
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_STRING)) {
            return Converter.cCharPtrToJavaString(OS.g_variant_get_string(gVariant, null), false);
        }
        if (OS.g_variant_is_of_type(gVariant, OS.G_VARIANT_TYPE_TUPLE)) {
            int length = (int)OS.g_variant_n_children(gVariant);
            Object[] result = new Object[length];
            int i = 0;
            while (i < length) {
                result[i] = WebkitGDBus.convertGVariantToJava(OS.g_variant_get_child_value(gVariant, i));
                ++i;
            }
            return result;
        }
        String typeString = Converter.cCharPtrToJavaString(OS.g_variant_get_type_string(gVariant), false);
        SWT.error(5, new Throwable("Unhandled variant type " + typeString));
        return null;
    }

    private static long convertJavaToGVariant(Object javaObject) throws SWTException {
        if (javaObject == null) {
            return OS.g_variant_new_byte((byte)48);
        }
        if (javaObject instanceof Long) {
            return OS.g_variant_new_uint64((Long)javaObject);
        }
        if (javaObject instanceof String) {
            return OS.g_variant_new_string(Converter.javaStringToCString((String)javaObject));
        }
        if (javaObject instanceof Boolean) {
            return OS.g_variant_new_boolean((Boolean)javaObject);
        }
        if (javaObject instanceof Number) {
            return OS.g_variant_new_double(((Number)javaObject).doubleValue());
        }
        if (javaObject instanceof Object[]) {
            Object[] arrayValue = (Object[])javaObject;
            int length = arrayValue.length;
            if (length == 0) {
                return OS.g_variant_new_byte((byte)101);
            }
            long[] variants = new long[length];
            int i = 0;
            while (i < length) {
                variants[i] = WebkitGDBus.convertJavaToGVariant(arrayValue[i]);
                ++i;
            }
            return OS.g_variant_new_tuple(variants, length);
        }
        System.err.println("SWT Webkit: Invalid object being returned to javascript: " + javaObject.toString() + "\n" + "Only the following are supported: null, String, Boolean, Number(Long,Integer,Double...), Object[] of basic types");
        throw new SWTException(5, "Given object is not valid: " + javaObject.toString());
    }
}

