/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.ui.viewer.IStyledLabelDecorator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.StructuredViewerTreeIterator;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindAndReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Map<IWorkbenchPart, FindAndReplaceTarget> FIND_AND_REPLACE_TARGETS = new WeakHashMap<IWorkbenchPart, FindAndReplaceTarget>();
    private static final Field FILTER_ACTION_FIELD = ReflectUtil.getField(PropertySheetPage.class, (String)"filterAction");
    private static final Method GET_DESCRIPTOR_METHOD = ReflectUtil.getMethod(PropertySheetEntry.class, (String)"getDescriptor", (Class[])new Class[0]);
    private static final Field OBJECT_FIELD = ReflectUtil.getField(PropertyDescriptor.class, (String)"object");
    private static final Field ITEM_PROPERTY_DESCRIPTOR_FIELD = ReflectUtil.getField(PropertyDescriptor.class, (String)"itemPropertyDescriptor");
    private static final Field ITEM_PROPERTY_SOURCE_FIELD = ReflectUtil.getField(PropertySource.class, (String)"itemPropertySource");
    private static final StyledString.Styler MATCH_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.borderStyle = 1;
        }
    };
    private IWorkbenchPart workbenchPart;
    private Runnable propertiesCleanup;
    private Runnable sessionCleanup;
    private List<?> selectionScope;
    private Set<Object> selectionScopeObjects;
    private String selectionText;
    private Data.Item selectedItem;
    private int selectedItemStart;
    private Pattern selectedItemPattern;
    private CompoundCommand replaceAllCommand;
    private int pendingReplacements = -1;
    private boolean findReplaceable;
    private SearchType searchType;
    private TreeItem specialTreeItem;
    private int specialStart;
    private boolean suspendScopeChanges;

    public FindAndReplaceTarget(IWorkbenchPart workbenchPart) {
        this.workbenchPart = workbenchPart;
    }

    protected StructuredViewer getViewer() {
        IViewerProvider viewerProvider;
        Viewer viewer;
        if (this.workbenchPart instanceof IViewerProvider && (viewer = (viewerProvider = (IViewerProvider)this.workbenchPart).getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected PropertySheetPage getActivePropertySheetPage() {
        PropertySheet propertySheet;
        IPage currentPage;
        IWorkbenchPart activePart = this.workbenchPart.getSite().getPage().getActivePart();
        if (activePart instanceof PropertySheet && (currentPage = (propertySheet = (PropertySheet)activePart).getCurrentPage()) != null && currentPage instanceof PropertySheetPage) {
            PropertySheetPage propertySheetPage = (PropertySheetPage)currentPage;
            return propertySheetPage;
        }
        return null;
    }

    protected Tree getActivePropertySheetTree() {
        Control control;
        PropertySheetPage propertySheetPage = this.getActivePropertySheetPage();
        if (propertySheetPage != null && (control = propertySheetPage.getControl()) instanceof Tree) {
            Tree tree = (Tree)control;
            return tree;
        }
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean canPerformFind() {
        StructuredViewer viewer = this.getViewer();
        return viewer != null && viewer.getLabelProvider() instanceof ILabelProvider && viewer.getContentProvider() instanceof IStructuredContentProvider;
    }

    public void initialize(IWorkbenchPart workbenchPart) {
        StructuredViewer viewer = this.getViewer();
        Tree propertySheetTree = this.getActivePropertySheetTree();
        if (propertySheetTree != null) {
            TreeItem[] treeItemArray = propertySheetTree.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                PropertyDescriptor propertyDescriptor = FindAndReplaceTarget.getPropertyDescriptor(treeItem);
                if (propertyDescriptor != null) {
                    Object object = FindAndReplaceTarget.getObject(propertyDescriptor);
                    for (Data data : new TextData(viewer)) {
                        if (data.object != object) continue;
                        Object feature = FindAndReplaceTarget.getFeature(propertyDescriptor);
                        for (Data.Item item : data.items) {
                            Object itemFeature = item.getFeature();
                            if (itemFeature != feature) continue;
                            Control control = workbenchPart.getSite().getShell().getDisplay().getFocusControl();
                            if (control instanceof Text) {
                                Text text = (Text)control;
                                this.selectionText = text.getSelectionText();
                                if (this.selectionText.length() > 0) {
                                    Point selection = text.getSelection();
                                    this.setSelection(true, viewer, item, selection.x, Pattern.compile(Pattern.quote(this.selectionText)));
                                    return;
                                }
                            }
                            this.setSelection(true, viewer, item, 0, Pattern.compile(Pattern.quote(item.value)));
                            return;
                        }
                    }
                }
                ++n2;
            }
        } else {
            List list = ((IStructuredSelection)viewer.getSelection()).toList();
            for (Data data : new TextData(viewer)) {
                if (!list.contains(data.object)) continue;
                Data.Item item = data.items.get(0);
                this.setSelection(true, viewer, item, 0, Pattern.compile(Pattern.quote(item.value)));
                return;
            }
        }
    }

    public void beginSession() {
        this.addSearchTypeControl();
    }

    protected void addSearchTypeControl() {
        Shell[] shells;
        Shell workbenchShell = this.workbenchPart.getSite().getShell();
        Shell[] shellArray = shells = workbenchShell.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Button checkBoxButton;
            Object layoutData;
            Dialog dialog;
            Object checkBox;
            final Shell shell = shellArray[n2];
            Object data = shell.getData();
            if (data instanceof Dialog && "org.eclipse.ui.texteditor.FindReplaceDialog".equals(data.getClass().getName()) && (checkBox = ReflectUtil.getValue((String)"fIsRegExCheckBox", (Object)(dialog = (Dialog)data))) instanceof Button && (layoutData = (checkBoxButton = (Button)checkBox).getLayoutData()) instanceof GridData) {
                String label;
                final GridData checkBoxGridData = (GridData)layoutData;
                if (checkBoxGridData.horizontalSpan == 2) {
                    checkBoxGridData.verticalAlignment = 128;
                    checkBoxGridData.horizontalSpan = 1;
                }
                final IDialogSettings dialogSettings = UIPlugin.INSTANCE.getDialogSettings("org.eclipse.ui.texteditor.FindReplaceDialog");
                final Composite group = checkBoxButton.getParent();
                final Combo combo = new Combo(group, 12);
                combo.setItems(SearchType.getLabels());
                GridData gridData = new GridData(16384, 128, false, false, 1, 1);
                combo.setLayoutData((Object)gridData);
                this.searchType = SearchType.getSearchType(dialogSettings.get("search-type"));
                combo.select(this.searchType.ordinal());
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FindAndReplaceTarget.this.searchType = SearchType.values()[combo.getSelectionIndex()];
                        dialogSettings.put("search-type", FindAndReplaceTarget.this.searchType.key());
                    }
                });
                String oldLabel = null;
                Button selectedRangeButton = null;
                Object selectedRange = ReflectUtil.getValue((String)"fSelectedRangeRadioButton", (Object)dialog);
                if (selectedRange instanceof Button && (label = (selectedRangeButton = (Button)selectedRange).getText()).endsWith("lines")) {
                    oldLabel = label;
                    selectedRangeButton.setText(String.valueOf(label.substring(0, label.length() - 5)) + " elements");
                }
                shell.layout(true, true);
                if (!dialogSettings.getBoolean("resized")) {
                    Rectangle comboBounds = combo.getBounds();
                    Point comboBottomRightLocation = group.toDisplay(comboBounds.x + comboBounds.width, comboBounds.y + comboBounds.height);
                    Rectangle groupBounds = group.getBounds();
                    Point groupBottomRightLocation = group.getParent().toDisplay(groupBounds.x + groupBounds.width, groupBounds.y + groupBounds.height);
                    int widthDelta = groupBottomRightLocation.x - comboBottomRightLocation.x;
                    int heightDelta = groupBottomRightLocation.y - comboBottomRightLocation.y;
                    if (widthDelta < 8 || heightDelta < 8) {
                        Point shellSize = shell.getSize();
                        if (widthDelta < 8) {
                            shellSize.x -= widthDelta - 8;
                        }
                        if (heightDelta < 8) {
                            shellSize.y -= heightDelta - 8;
                        }
                        shell.setSize(shellSize);
                    }
                    dialogSettings.put("resized", true);
                }
                final String finalOldLabel = oldLabel;
                final Button finalSelectRangeButton = selectedRangeButton;
                this.sessionCleanup = new Runnable(){

                    public void run() {
                        checkBoxGridData.horizontalSpan = 2;
                        checkBoxGridData.verticalAlignment = 0x1000000;
                        combo.dispose();
                        if (finalOldLabel != null) {
                            finalSelectRangeButton.setText(finalOldLabel);
                        }
                        UIUtil.asyncExec((Control)group, new Runnable(){

                            public void run() {
                                shell.layout(true, true);
                            }
                        });
                    }
                };
            }
            ++n2;
        }
    }

    public void endSession() {
        if (this.sessionCleanup != null) {
            this.sessionCleanup.run();
        }
        this.setScope(null);
    }

    public Point getLineSelection() {
        StructuredViewer viewer = this.getViewer();
        this.selectionScope = ((IStructuredSelection)viewer.getSelection()).toList();
        return new Point(0, 0);
    }

    public IRegion getScope() {
        return new Region(0, 0);
    }

    public void setScope(IRegion scope) {
        if (this.suspendScopeChanges) {
            return;
        }
        StructuredViewer viewer = this.getViewer();
        if (scope == null) {
            Object[] selectionScopeObjectsToUpdate = this.selectionScopeObjects == null ? null : this.selectionScopeObjects.toArray();
            Object selectionToUpdate = this.selectedItem != null && this.selectedItem.itemPropertyDescriptor == null ? this.selectedItem.data.object : null;
            this.selectionText = null;
            this.selectedItem = null;
            this.findReplaceable = false;
            this.selectionScopeObjects = null;
            this.propertiesCleanup();
            if (selectionScopeObjectsToUpdate != null) {
                viewer.update(selectionScopeObjectsToUpdate, null);
            }
            if (selectionToUpdate != null) {
                viewer.update(selectionToUpdate, null);
            }
        } else {
            this.selectionScopeObjects = new HashSet<Object>();
            int depth = -1;
            for (Data data : new TextData(viewer)) {
                if (data.depth == depth) {
                    depth = -1;
                }
                if (this.selectionScope.contains(data.object) && depth == -1) {
                    depth = data.depth;
                }
                if (depth == -1) continue;
                this.selectionScopeObjects.add(data.object);
            }
            this.hookLabelProvider();
            viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void propertiesCleanup() {
        if (this.propertiesCleanup != null) {
            this.propertiesCleanup.run();
            this.propertiesCleanup = null;
        }
    }

    public void setScopeHighlightColor(Color color) {
    }

    public String getSelectionText() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if ("updateButtonState".equals(stackTrace[2].getMethodName()) && (this.selectedItem == null || this.selectedItem.itemPropertyDescriptor == null || !this.selectedItem.itemPropertyDescriptor.canSetProperty(this.selectedItem.data.object))) {
            return "";
        }
        if (this.selectionText != null) {
            return this.selectionText;
        }
        if (this.selectedItem != null) {
            return this.selectedItem.value;
        }
        return "";
    }

    public Point getSelection() {
        if (this.pendingReplacements >= 0) {
            return new Point(this.pendingReplacements, 0);
        }
        if (this.selectedItem != null) {
            Matcher matcher = this.selectedItemPattern.matcher(this.selectedItem.value);
            int size = 0;
            if (this.selectedItem.value.length() >= this.selectedItemStart && matcher.find(this.selectedItemStart)) {
                size = matcher.group().length();
            }
            Point point = new Point(this.selectedItem.index + this.selectedItemStart, size);
            return point;
        }
        StructuredViewer viewer = this.getViewer();
        Tree propertySheetTree = this.getActivePropertySheetTree();
        if (propertySheetTree != null) {
            TreeItem[] treeItemArray = propertySheetTree.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                PropertyDescriptor propertyDescriptor = FindAndReplaceTarget.getPropertyDescriptor(treeItem);
                if (propertyDescriptor != null) {
                    Object object = FindAndReplaceTarget.getObject(propertyDescriptor);
                    for (Data data : new TextData(viewer)) {
                        if (data.object != object) continue;
                        Object feature = FindAndReplaceTarget.getFeature(propertyDescriptor);
                        ArrayList<Object> features = new ArrayList<Object>();
                        TreeItem[] treeItemArray2 = propertySheetTree.getItems();
                        int n3 = treeItemArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TreeItem otherTreeIem = treeItemArray2[n4];
                            PropertyDescriptor otherPropertyDescriptor = FindAndReplaceTarget.getPropertyDescriptor(otherTreeIem);
                            if (otherPropertyDescriptor != null) {
                                Object otherFeature = FindAndReplaceTarget.getFeature(otherPropertyDescriptor);
                                features.add(otherFeature);
                                if (otherFeature == feature) break;
                            }
                            ++n4;
                        }
                        Data.Item candidate = null;
                        for (Data.Item item : data.items) {
                            Object itemFeature = item.getFeature();
                            if (itemFeature == feature) {
                                return new Point(item.index, 0);
                            }
                            if (!features.contains(itemFeature)) continue;
                            candidate = item;
                        }
                        if (candidate == null) break;
                        return new Point(candidate.index, 0);
                    }
                }
                ++n2;
            }
        }
        List list = ((IStructuredSelection)viewer.getSelection()).toList();
        for (Data data : new TextData(viewer)) {
            if (!list.contains(data.object)) continue;
            return new Point(data.items.get((int)0).index, 0);
        }
        return new Point(0, 0);
    }

    public void setSelection(int offset, int length) {
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        this.selectionText = null;
        if (regExSearch) {
            Pattern.compile(findString);
        }
        String impliedPattern = findString;
        if (!regExSearch) {
            impliedPattern = Pattern.quote(impliedPattern);
        }
        if (!caseSensitive) {
            impliedPattern = "(?i)" + impliedPattern;
        }
        if (wholeWord) {
            impliedPattern = "\\b" + impliedPattern + "\\b";
        }
        Pattern pattern = Pattern.compile(impliedPattern);
        if (this.pendingReplacements >= 0) {
            this.selectedItemPattern = pattern;
            return --this.pendingReplacements;
        }
        StructuredViewer viewer = this.getViewer();
        Data.Item candidate = null;
        int candidateStart = -1;
        block0: for (Data data : new TextData(viewer)) {
            if (this.selectionScopeObjects != null && !this.selectionScopeObjects.contains(data.object)) continue;
            for (Data.Item item : data.items) {
                if (searchForward ? item.index >= offset || item.index + item.value.length() > offset : offset == -1 || item.index < offset) {
                    Matcher matcher;
                    if (this.findReplaceable ? !SearchType.MODIFIABLE_ATTRIBUTE.isIncluded(item) : this.searchType != null && !this.searchType.isIncluded(item)) continue;
                    int begin = 0;
                    if (searchForward && item.index < offset) {
                        begin = offset - item.index;
                    }
                    if (!(matcher = pattern.matcher(item.value)).find(begin)) continue;
                    int start = matcher.start();
                    if (searchForward) {
                        this.setSelection(false, viewer, item, start, pattern);
                        this.findReplaceable = false;
                        return item.index + start;
                    }
                    if (offset != -1 && item.index + start > offset) continue;
                    candidate = item;
                    candidateStart = start;
                    while (matcher.find()) {
                        start = matcher.start();
                        if (offset != -1 && item.index + start > offset) continue;
                        candidate = item;
                        candidateStart = start;
                    }
                    continue;
                }
                if (!searchForward && item.index > offset) break block0;
            }
        }
        if (candidate != null) {
            this.setSelection(false, viewer, candidate, candidateStart, pattern);
            this.findReplaceable = false;
            return candidate.index + candidateStart;
        }
        return -1;
    }

    protected void setSelection(boolean preserve, StructuredViewer viewer, Data.Item item, int start, Pattern pattern) {
        Object selectedObjectToUpdate = this.selectedItem != null && this.selectedItem.itemPropertyDescriptor == null ? this.selectedItem.data.object : null;
        this.selectedItem = item;
        this.selectedItemPattern = pattern;
        this.selectedItemStart = start;
        if (selectedObjectToUpdate != null) {
            viewer.update(selectedObjectToUpdate, null);
        }
        this.specialTreeItem = null;
        this.hookLabelProvider();
        this.propertiesCleanup();
        if (this.replaceAllCommand == null) {
            Control control;
            PropertySheet propertySheet;
            IPage currentPage;
            IViewPart viewPart;
            block22: {
                PropertySheetPage activePropertySheetPage;
                StructuredSelection selection = new StructuredSelection((Object)new TreePath(item.data.getPath()));
                if (!preserve) {
                    viewer.setSelection((ISelection)selection, true);
                }
                if ((activePropertySheetPage = this.getActivePropertySheetPage()) != null) {
                    activePropertySheetPage.selectionChanged(this.workbenchPart, (ISelection)selection);
                }
                IWorkbenchPartSite site = this.workbenchPart.getSite();
                IWorkbenchPage page = site.getPage();
                viewPart = page.findView("org.eclipse.ui.views.PropertySheet");
                Display display = site.getShell().getDisplay();
                Control oldFocusControl = display.getFocusControl();
                try {
                    try {
                        Control newFocusControl;
                        this.suspendScopeChanges = true;
                        if (item.itemPropertyDescriptor != null && (viewPart = page.showView("org.eclipse.ui.views.PropertySheet", null, 2)) == null) {
                            viewPart = page.showView("org.eclipse.ui.views.PropertySheet", null, 3);
                        }
                        if (oldFocusControl != (newFocusControl = display.getFocusControl())) {
                            oldFocusControl.setFocus();
                        }
                    }
                    catch (PartInitException ex) {
                        UIPlugin.INSTANCE.log(ex);
                        this.suspendScopeChanges = false;
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    this.suspendScopeChanges = false;
                    throw throwable;
                }
                this.suspendScopeChanges = false;
            }
            if (viewPart instanceof PropertySheet && (currentPage = (propertySheet = (PropertySheet)viewPart).getCurrentPage()) instanceof PropertySheetPage && (control = currentPage.getControl()) instanceof Tree) {
                final Tree tree = (Tree)control;
                if (item.itemPropertyDescriptor != null) {
                    int n;
                    int n2;
                    String[] stringArray;
                    Action filterAction = null;
                    String[] filterFlags = item.itemPropertyDescriptor.getFilterFlags(item.data.object);
                    if (filterFlags != null) {
                        stringArray = filterFlags;
                        n2 = filterFlags.length;
                        n = 0;
                        while (n < n2) {
                            Action action;
                            String filterFlag = stringArray[n];
                            if ("org.eclipse.ui.views.properties.expert".equals(filterFlag) && !(action = (Action)ReflectUtil.getValue((Field)FILTER_ACTION_FIELD, (Object)currentPage)).isChecked()) {
                                action.setChecked(true);
                                action.run();
                                filterAction = action;
                            }
                            ++n;
                        }
                    }
                    stringArray = tree.getItems();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String treeItem = stringArray[n];
                        PropertyDescriptor propertyDescriptor = FindAndReplaceTarget.getPropertyDescriptor((TreeItem)treeItem);
                        if (propertyDescriptor != null && propertyDescriptor.getFeature() == item.getFeature()) {
                            Matcher matcher;
                            String treeItemText = treeItem.getText(1);
                            String itemValue = item.value;
                            this.specialStart = -1;
                            if (!treeItemText.equals(itemValue) && (matcher = pattern.matcher(itemValue)).find(start)) {
                                this.specialTreeItem = treeItem;
                                int end = matcher.end();
                                if (treeItemText.length() < end || !treeItemText.substring(0, end).equals(itemValue.substring(0, end))) {
                                    int begin = matcher.start();
                                    this.specialStart = 2;
                                    while (begin >= 0 && this.specialStart < 20 && !Character.isISOControl(itemValue.charAt(begin))) {
                                        ++this.specialStart;
                                        --begin;
                                    }
                                    int itemValueLength = itemValue.length();
                                    while (end < itemValueLength && !Character.isISOControl(itemValue.charAt(end))) {
                                        ++end;
                                    }
                                    String specialText = "..." + itemValue.substring(begin + 1, end) + "...";
                                    treeItem.setText(1, specialText);
                                    tree.redraw();
                                }
                            }
                            final Listener paintItemListener = new Listener((TreeItem)treeItem, start){
                                private final /* synthetic */ TreeItem val$treeItem;
                                private final /* synthetic */ int val$start;
                                {
                                    this.val$treeItem = treeItem;
                                    this.val$start = n;
                                }

                                private void paintItem(Event event, TreeItem item, int matchStart) {
                                    String text = item.getText(1);
                                    Matcher matcher = FindAndReplaceTarget.this.selectedItemPattern.matcher(text);
                                    if (matchStart < text.length() && matcher.find(matchStart)) {
                                        int start = matcher.start();
                                        int x = event.gc.textExtent((String)text.substring((int)0, (int)start)).x + item.getTextBounds((int)1).x - this.val$treeItem.getBounds((int)1).x;
                                        int width = event.gc.textExtent((String)matcher.group()).x;
                                        event.gc.drawRectangle(event.x + x + 1, event.y, width + 1, event.height - 1);
                                    } else if (text.endsWith("...")) {
                                        int x = event.gc.textExtent((String)text.substring((int)0, (int)(text.length() - 3))).x + this.val$treeItem.getTextBounds((int)1).x - this.val$treeItem.getBounds((int)1).x;
                                        int width = event.gc.textExtent((String)"...").x;
                                        event.gc.drawRectangle(event.x + x + 1, event.y, width + 1, event.height - 1);
                                    }
                                }

                                public void handleEvent(Event event) {
                                    TreeItem item = (TreeItem)event.item;
                                    if (item == this.val$treeItem && event.index == 1) {
                                        this.paintItem(event, item, FindAndReplaceTarget.this.specialStart == -1 ? this.val$start : FindAndReplaceTarget.this.specialStart);
                                    }
                                }
                            };
                            tree.addListener(42, paintItemListener);
                            final PropertySheetPage propertySheetPage = (PropertySheetPage)currentPage;
                            final Action finalFilterAction = filterAction;
                            this.propertiesCleanup = new Runnable(){

                                public void run() {
                                    tree.removeListener(42, paintItemListener);
                                    if (finalFilterAction != null) {
                                        finalFilterAction.setChecked(false);
                                        finalFilterAction.run();
                                    } else {
                                        propertySheetPage.refresh();
                                    }
                                }
                            };
                            tree.setSelection((TreeItem)treeItem);
                            tree.redraw();
                            return;
                        }
                        ++n;
                    }
                }
                tree.setSelection(new TreeItem[0]);
            }
        }
    }

    protected void hookLabelProvider() {
        StructuredViewer viewer = this.getViewer();
        final ILabelProvider labelProvider = (ILabelProvider)viewer.getLabelProvider();
        class DecoratingLabelProvider
        extends DelegatingStyledCellLabelProvider.FontAndColorProvider
        implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
            public DecoratingLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider) {
                super(styledLabelProvider);
            }

            public StyledString getStyledText(Object element) {
                return super.getStyledText(element);
            }
        }
        if (labelProvider instanceof DecoratingLabelProvider) {
            if (this.selectionScopeObjects != null) {
                viewer.update(this.selectionScopeObjects.toArray(), null);
            }
            if (this.selectedItem != null && this.selectedItem.itemPropertyDescriptor == null) {
                viewer.update(this.selectedItem.data.object, null);
            }
        } else {
            DecoratingColumLabelProvider.StyledLabelProvider styledProvider = new DecoratingColumLabelProvider.StyledLabelProvider(labelProvider, (ILabelDecorator)new IStyledLabelDecorator(){
                final Color color;
                final StyledString.Styler scopeStyler;
                {
                    this.color = FindAndReplaceTarget.this.workbenchPart.getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.ui.editors.findScope");
                    this.scopeStyler = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.background = color;
                        }
                    };
                }

                public void removeListener(ILabelProviderListener listener) {
                    labelProvider.removeListener(listener);
                }

                public boolean isLabelProperty(Object element, String property) {
                    return labelProvider.isLabelProperty(element, property);
                }

                public void dispose() {
                    labelProvider.dispose();
                }

                public void addListener(ILabelProviderListener listener) {
                    labelProvider.addListener(listener);
                }

                public String decorateText(String text, Object element) {
                    if (labelProvider instanceof ILabelDecorator) {
                        ILabelDecorator labelDecorator = (ILabelDecorator)labelProvider;
                        return labelDecorator.decorateText(text, element);
                    }
                    return text;
                }

                public Image decorateImage(Image image, Object element) {
                    if (labelProvider instanceof ILabelDecorator) {
                        ILabelDecorator labelDecorator = (ILabelDecorator)labelProvider;
                        return labelDecorator.decorateImage(image, element);
                    }
                    return image;
                }

                public StyledString decorateStyledText(StyledString styledString, Object element) {
                    if (labelProvider instanceof IStyledLabelDecorator) {
                        IStyledLabelDecorator styledLabelDecorator = (IStyledLabelDecorator)labelProvider;
                        styledString = styledLabelDecorator.decorateStyledText(styledString, element);
                    }
                    if (FindAndReplaceTarget.this.selectedItem != null && ((FindAndReplaceTarget)FindAndReplaceTarget.this).selectedItem.itemPropertyDescriptor == null && element == ((FindAndReplaceTarget)FindAndReplaceTarget.this).selectedItem.data.object) {
                        String string = styledString.getString();
                        Matcher matcher = FindAndReplaceTarget.this.selectedItemPattern.matcher(string);
                        if (matcher.find(FindAndReplaceTarget.this.selectedItemStart)) {
                            StyledString result = new StyledString();
                            String group = matcher.group();
                            int start = matcher.start();
                            int end = matcher.end();
                            result.append(string.substring(0, start));
                            result.append(group, MATCH_STYLER);
                            result.append(string.substring(end));
                            return result;
                        }
                    }
                    if (FindAndReplaceTarget.this.selectionScopeObjects != null && FindAndReplaceTarget.this.selectionScopeObjects.contains(element)) {
                        StyledString result = new StyledString();
                        result.append(styledString.getString(), this.scopeStyler);
                        return result;
                    }
                    return styledString;
                }
            }){
                {
                    if (this.labelProvider instanceof CellLabelProvider) {
                        this.cellLabelProvider = (CellLabelProvider)this.labelProvider;
                    }
                }
            };
            DecoratingLabelProvider delegatingLabelProvider = new DecoratingLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)styledProvider);
            viewer.setLabelProvider((IBaseLabelProvider)delegatingLabelProvider);
        }
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void replaceSelection(String text, boolean regExReplace) {
        Command setCommand;
        String specialText;
        Matcher specialMatcher;
        Object value;
        if (this.replaceAllCommand != null) {
            if (this.pendingReplacements == 0x7FFFFFFE) {
                this.pendingReplacements = this.replaceSelectionAll(text, regExReplace) - 1;
            }
            return;
        }
        if (!SearchType.MODIFIABLE_ATTRIBUTE.isIncluded(this.selectedItem)) {
            return;
        }
        Matcher matcher = this.selectedItemPattern.matcher(this.selectedItem.value);
        if (!matcher.find(this.selectedItemStart)) {
            return;
        }
        StringBuffer result = new StringBuffer();
        int start = matcher.start();
        String replacement = regExReplace ? text : text.replace("$", "\\$");
        matcher.appendReplacement(result, replacement);
        String actualReplacement = result.substring(start);
        matcher.appendTail(result);
        EditingDomain domain = ((IEditingDomainProvider)this.workbenchPart).getEditingDomain();
        EAttribute eAttribute = (EAttribute)this.selectedItem.getFeature();
        try {
            value = EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)result.toString());
        }
        catch (RuntimeException runtimeException) {
            return;
        }
        String replacementSpecialText = null;
        if (this.specialTreeItem != null && !this.specialTreeItem.isDisposed() && (specialMatcher = this.selectedItemPattern.matcher(specialText = this.specialTreeItem.getText(1))).find(this.specialStart)) {
            StringBuffer specialResult = new StringBuffer();
            specialMatcher.appendReplacement(specialResult, replacement);
            specialMatcher.appendTail(specialResult);
            replacementSpecialText = specialResult.toString();
        }
        this.selectedItemPattern = Pattern.compile(Pattern.quote(actualReplacement));
        if (eAttribute.isMany()) {
            Object propertyValue = this.selectedItem.itemPropertyDescriptor.getPropertyValue(this.selectedItem.data.object);
            if (propertyValue instanceof IItemPropertySource) {
                propertyValue = ((IItemPropertySource)propertyValue).getEditableValue(this.selectedItem.data.object);
            }
            ArrayList<Object> values = new ArrayList<Object>((List)propertyValue);
            values.set(this.selectedItem.itemIndex, value);
            setCommand = SetCommand.create((EditingDomain)domain, (Object)this.selectedItem.data.object, (Object)eAttribute, values);
        } else {
            setCommand = SetCommand.create((EditingDomain)domain, (Object)this.selectedItem.data.object, (Object)eAttribute, (Object)value);
        }
        CompoundCommand wrapper = new CompoundCommand(Integer.MAX_VALUE){
            boolean isFirst;
            {
                this.isFirst = true;
            }

            public Collection<?> getAffectedObjects() {
                if (this.isFirst) {
                    this.isFirst = false;
                    return Collections.emptyList();
                }
                return super.getAffectedObjects();
            }
        };
        wrapper.append(setCommand);
        domain.getCommandStack().execute((Command)wrapper);
        Display display = this.getViewer().getControl().getShell().getDisplay();
        final boolean[] run = new boolean[]{true};
        display.asyncExec(new Runnable(){

            public void run() {
                run[0] = false;
            }
        });
        while (run[0] && display.readAndDispatch()) {
            display.sleep();
        }
        if (this.specialTreeItem != null) {
            if (!this.specialTreeItem.isDisposed() && replacementSpecialText != null) {
                this.specialTreeItem.setText(1, replacementSpecialText);
                this.specialTreeItem.getParent().redraw();
            }
            this.specialTreeItem = null;
        }
        for (Data data : new TextData(this.getViewer())) {
            if (data.object != this.selectedItem.data.object) continue;
            for (Data.Item item : data.items) {
                if (this.selectedItem.itemPropertyDescriptor != item.itemPropertyDescriptor || this.selectedItem.itemIndex != item.itemIndex) continue;
                this.selectedItem = item;
            }
        }
        this.findReplaceable = true;
    }

    protected int replaceSelectionAll(String text, boolean regExReplace) {
        String replacement = regExReplace ? text : text.replace("$", "\\$");
        EditingDomain domain = ((IEditingDomainProvider)this.workbenchPart).getEditingDomain();
        int total = 0;
        for (Data data : new TextData(this.getViewer())) {
            EAttribute currentListAttribute = null;
            ArrayList<Object> currentListValue = null;
            for (Data.Item item : data.items) {
                Object value;
                Matcher matcher;
                if (!SearchType.MODIFIABLE_ATTRIBUTE.isIncluded(item) || !(matcher = this.selectedItemPattern.matcher(item.value)).find()) continue;
                StringBuffer result = new StringBuffer();
                int count = 0;
                do {
                    matcher.appendReplacement(result, replacement);
                    ++count;
                } while (matcher.find());
                matcher.appendTail(result);
                EAttribute eAttribute = (EAttribute)item.getFeature();
                if (currentListAttribute != null && eAttribute != currentListAttribute) {
                    Command setCommand = SetCommand.create((EditingDomain)domain, (Object)data.object, currentListAttribute, currentListValue);
                    this.replaceAllCommand.append(setCommand);
                    currentListAttribute = null;
                    currentListValue = null;
                }
                try {
                    value = EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)result.toString());
                }
                catch (RuntimeException runtimeException) {
                    continue;
                }
                total += count;
                if (eAttribute.isMany()) {
                    if (currentListValue == null) {
                        currentListAttribute = eAttribute;
                        Object propertyValue = item.itemPropertyDescriptor.getPropertyValue(data.object);
                        if (propertyValue instanceof IItemPropertySource) {
                            propertyValue = ((IItemPropertySource)propertyValue).getEditableValue(data.object);
                        }
                        currentListValue = new ArrayList<Object>((List)propertyValue);
                    }
                    currentListValue.set(item.itemIndex, value);
                    continue;
                }
                Command setCommand = SetCommand.create((EditingDomain)domain, (Object)data.object, (Object)eAttribute, (Object)value);
                this.replaceAllCommand.append(setCommand);
            }
            if (currentListAttribute == null) continue;
            Command setCommand = SetCommand.create((EditingDomain)domain, (Object)data.object, currentListAttribute, currentListValue);
            this.replaceAllCommand.append(setCommand);
        }
        return total;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        if (replaceAll) {
            this.findReplaceable = true;
            this.replaceAllCommand = new CompoundCommand(Integer.MAX_VALUE, "Replace All"){};
            this.pendingReplacements = Integer.MAX_VALUE;
        } else {
            try {
                EditingDomain domain = ((IEditingDomainProvider)this.workbenchPart).getEditingDomain();
                domain.getCommandStack().execute((Command)this.replaceAllCommand);
            }
            finally {
                this.findReplaceable = false;
                this.replaceAllCommand = null;
                this.pendingReplacements = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getAdapter(Class<?> adapter, IWorkbenchPart workbenchPart) {
        if (adapter == IFindReplaceTarget.class) {
            Map<IWorkbenchPart, FindAndReplaceTarget> map = FIND_AND_REPLACE_TARGETS;
            synchronized (map) {
                FindAndReplaceTarget findAndReplaceTarget = FIND_AND_REPLACE_TARGETS.get(workbenchPart);
                if (findAndReplaceTarget == null) {
                    findAndReplaceTarget = new FindAndReplaceTarget(workbenchPart);
                    FIND_AND_REPLACE_TARGETS.put(workbenchPart, findAndReplaceTarget);
                }
                return findAndReplaceTarget;
            }
        }
        return null;
    }

    protected static List<String> getText(IItemPropertyDescriptor itemPropertyDescriptor, Object object) {
        EAttribute eAttribute;
        EDataType eDataType;
        Object feature = itemPropertyDescriptor.getFeature(object);
        if (feature instanceof EAttribute && (eDataType = (eAttribute = (EAttribute)feature).getEAttributeType()).isSerializable()) {
            Object value = itemPropertyDescriptor.getPropertyValue(object);
            if (value instanceof IItemPropertySource) {
                value = ((IItemPropertySource)value).getEditableValue(object);
            }
            if (value != null) {
                ArrayList<String> result = new ArrayList<String>();
                if (eAttribute.isMany()) {
                    for (Object item : (List)value) {
                        result.add(EcoreUtil.convertToString((EDataType)eDataType, item));
                    }
                } else {
                    result.add(EcoreUtil.convertToString((EDataType)eDataType, (Object)value));
                }
                return result;
            }
        }
        return null;
    }

    protected static PropertyDescriptor getPropertyDescriptor(TreeItem treeItem) {
        PropertySheetEntry propertySheetEntry;
        Object descriptor;
        Object data = treeItem.getData();
        if (data instanceof PropertySheetEntry && (descriptor = ReflectUtil.invokeMethod((Method)GET_DESCRIPTOR_METHOD, (Object)(propertySheetEntry = (PropertySheetEntry)data), (Object[])new Object[0])) instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            return propertyDescriptor;
        }
        return null;
    }

    protected static Object getObject(PropertyDescriptor propertyDescriptor) {
        Object object = ReflectUtil.getValue((Field)OBJECT_FIELD, (Object)propertyDescriptor);
        return object;
    }

    protected static Object getFeature(PropertyDescriptor propertyDescriptor) {
        Object object = FindAndReplaceTarget.getObject(propertyDescriptor);
        IItemPropertyDescriptor itemPropertyDescriptor = (IItemPropertyDescriptor)ReflectUtil.getValue((Field)ITEM_PROPERTY_DESCRIPTOR_FIELD, (Object)propertyDescriptor);
        return itemPropertyDescriptor.getFeature(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Data {
        public Object object;
        public int depth;
        public Data parent;
        public List<Item> items;

        public Data(int depth, Object object, List<Item> items) {
            this.depth = depth;
            this.object = object;
            this.items = items;
        }

        public Object[] getPath() {
            ArrayList<Object> path = new ArrayList<Object>();
            Data data = this;
            while (data != null) {
                path.add(0, data.object);
                data = data.parent;
            }
            return path.toArray();
        }

        public static class Item {
            public Data data;
            public int index;
            public IItemPropertyDescriptor itemPropertyDescriptor;
            public int itemIndex;
            public String value;

            public Item(Data data, int index, IItemPropertyDescriptor itemPropertyDescriptor, int itemIndex, String value) {
                this.data = data;
                this.index = index;
                this.itemPropertyDescriptor = itemPropertyDescriptor;
                this.itemIndex = itemIndex;
                this.value = value;
            }

            public Object getFeature() {
                if (this.itemPropertyDescriptor != null) {
                    return this.itemPropertyDescriptor.getFeature(this.data.object);
                }
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchType {
        LABEL_AND_ATTRIBUTE{

            public boolean isIncluded(Data.Item item) {
                return item != null;
            }

            public String key() {
                return "label+attribute";
            }

            public String label() {
                return "Labels and attributes";
            }
        }
        ,
        LABEL{

            public boolean isIncluded(Data.Item item) {
                return item != null && item.itemPropertyDescriptor == null;
            }

            public String key() {
                return "label";
            }

            public String label() {
                return "Labels";
            }
        }
        ,
        ATTRIBUTE{

            public boolean isIncluded(Data.Item item) {
                return item != null && item.itemPropertyDescriptor != null;
            }

            public String key() {
                return "attribute";
            }

            public String label() {
                return "Attributes";
            }
        }
        ,
        MODIFIABLE_ATTRIBUTE{

            public boolean isIncluded(Data.Item item) {
                return item != null && item.itemPropertyDescriptor != null && item.itemPropertyDescriptor.canSetProperty(item.data.object);
            }

            public String key() {
                return "modifiable-attribute";
            }

            public String label() {
                return "Modifiable attributes";
            }
        };


        public abstract boolean isIncluded(Data.Item var1);

        public abstract String key();

        public abstract String label();

        public static SearchType getSearchType(String key) {
            SearchType[] searchTypeArray = SearchType.values();
            int n = searchTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchType searchType = searchTypeArray[n2];
                if (searchType.key().equals(key)) {
                    return searchType;
                }
                ++n2;
            }
            return LABEL_AND_ATTRIBUTE;
        }

        public static String[] getLabels() {
            SearchType[] values = SearchType.values();
            String[] labels = new String[values.length];
            int i = 0;
            while (i < values.length) {
                labels[i] = values[i].label();
                ++i;
            }
            return labels;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextData
    implements Iterable<Data> {
        private StructuredViewer viewer;
        private ILabelProvider labelProvider;
        private IPropertySourceProvider propertySourceProvider;

        public TextData(StructuredViewer viewer) {
            this.viewer = viewer;
            this.labelProvider = (ILabelProvider)viewer.getLabelProvider();
            IContentProvider contentProvider = viewer.getContentProvider();
            if (contentProvider instanceof IPropertySourceProvider) {
                this.propertySourceProvider = (IPropertySourceProvider)contentProvider;
            }
        }

        @Override
        public Iterator<Data> iterator() {
            IContentProvider contentProvider = this.viewer.getContentProvider();
            final StructuredViewerTreeIterator structuredViewerTreeIterator = contentProvider instanceof StructuredViewerTreeIterator.Provider ? ((StructuredViewerTreeIterator.Provider)contentProvider).create() : new StructuredViewerTreeIterator(this.viewer);
            return new Iterator<Data>(){
                private List<Data> parents = new ArrayList<Data>();
                private int index;

                @Override
                public boolean hasNext() {
                    return structuredViewerTreeIterator.hasNext();
                }

                @Override
                public Data next() {
                    IPropertySource propertySource;
                    int depth = structuredViewerTreeIterator.size();
                    Object object = structuredViewerTreeIterator.next();
                    ArrayList<Data.Item> items = new ArrayList<Data.Item>();
                    Data data = new Data(depth - 1, object, items);
                    if (this.parents.size() < depth) {
                        this.parents.add(data);
                    } else {
                        this.parents.set(depth - 1, data);
                    }
                    if (depth > 1) {
                        data.parent = this.parents.get(depth - 2);
                    }
                    String label = TextData.this.labelProvider.getText(object);
                    items.add(new Data.Item(data, this.index, null, 0, label));
                    this.index += label.length();
                    if (TextData.this.propertySourceProvider != null && (propertySource = TextData.this.propertySourceProvider.getPropertySource(object)) instanceof PropertySource) {
                        PropertySource emfPropertySource = (PropertySource)propertySource;
                        IItemPropertySource itemPropertySource = (IItemPropertySource)ReflectUtil.getValue((Field)ITEM_PROPERTY_SOURCE_FIELD, (Object)emfPropertySource);
                        for (IItemPropertyDescriptor itemPropertyDescriptor : itemPropertySource.getPropertyDescriptors(object)) {
                            List<String> text = FindAndReplaceTarget.getText(itemPropertyDescriptor, object);
                            if (text == null) continue;
                            int i = 0;
                            int size = text.size();
                            while (i < size) {
                                String value = text.get(i);
                                items.add(new Data.Item(data, this.index, itemPropertyDescriptor, i, value));
                                this.index += value.length();
                                ++i;
                            }
                        }
                    }
                    return data;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
    }
}

