/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.nebula.widgets.timeline.IColored;
import org.eclipse.nebula.widgets.timeline.ITimelinePackage;
import org.eclipse.swt.graphics.RGB;

public abstract class Colored
extends MinimalEObjectImpl.Container
implements IColored {
    private static final Pattern LONG_HEX_PATTERN = Pattern.compile("#(\\p{XDigit}{2})(\\p{XDigit}{2})(\\p{XDigit}{2})");
    private static final Pattern SHORT_HEX_PATTERN = Pattern.compile("#(\\p{XDigit}{1})(\\p{XDigit}{1})(\\p{XDigit}{1})");
    protected static final String COLOR_CODE_EDEFAULT = null;
    protected String colorCode = COLOR_CODE_EDEFAULT;
    protected static final RGB RGB_EDEFAULT = null;

    protected Colored() {
    }

    protected EClass eStaticClass() {
        return ITimelinePackage.Literals.COLORED;
    }

    @Override
    public String getColorCode() {
        return this.colorCode;
    }

    @Override
    public void setColorCode(String newColorCode) {
        String oldColorCode = this.colorCode;
        this.colorCode = newColorCode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldColorCode, (Object)this.colorCode));
        }
    }

    @Override
    public RGB getRgb() {
        String colorCode = this.getColorCode();
        if (colorCode != null) {
            Matcher matcher = LONG_HEX_PATTERN.matcher(colorCode);
            if (matcher.matches()) {
                int red = Integer.parseInt(matcher.group(1), 16);
                int green = Integer.parseInt(matcher.group(2), 16);
                int blue = Integer.parseInt(matcher.group(3), 16);
                return new RGB(red, green, blue);
            }
            matcher = SHORT_HEX_PATTERN.matcher(colorCode);
            if (matcher.matches()) {
                int red = Integer.parseInt(matcher.group(1) + matcher.group(1), 16);
                int green = Integer.parseInt(matcher.group(2) + matcher.group(2), 16);
                int blue = Integer.parseInt(matcher.group(3) + matcher.group(3), 16);
                return new RGB(red, green, blue);
            }
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getColorCode();
            }
            case 1: {
                return this.getRgb();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setColorCode((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setColorCode(COLOR_CODE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return COLOR_CODE_EDEFAULT == null ? this.colorCode != null : !COLOR_CODE_EDEFAULT.equals(this.colorCode);
            }
            case 1: {
                return RGB_EDEFAULT == null ? this.getRgb() != null : !RGB_EDEFAULT.equals((Object)this.getRgb());
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (colorCode: ");
        result.append(this.colorCode);
        result.append(')');
        return result.toString();
    }
}

