/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example;

import java.security.MessageDigest;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.example.model.SomeTask;

public class MyPreComputedColumn
extends XViewerColumn
implements IXViewerPreComputedColumn {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public MyPreComputedColumn() {
        super("xviewer.test.preComputedColumnExample", "Pre Computed Column", 130, XViewerAlign.Left, true, SortDataType.String, false, "Background loaded column that loads prior to setting inputs to XViewer.");
    }

    public MyPreComputedColumn copy() {
        MyPreComputedColumn newXCol = new MyPreComputedColumn();
        super.copy((XViewerColumn)this, (XViewerColumn)newXCol);
        return newXCol;
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        try {
            MessageDigest salt = MessageDigest.getInstance("SHA-256");
            for (Object obj : objects) {
                salt.update(UUID.randomUUID().toString().getBytes("UTF-8"));
                String digest = this.bytesToHex(salt.digest());
                preComputedValueMap.put(this.getKey(obj), "value " + digest);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public Long getKey(Object obj) {
        return new Long(((SomeTask)obj).getId().hashCode());
    }

    public String getText(Object obj, Long key, String cachedValue) {
        return cachedValue;
    }
}

