/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassReloadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.nattable.MouseDownClientListener;
import org.eclipse.nebula.widgets.nattable.MouseMoveClientListener;
import org.eclipse.nebula.widgets.nattable.MouseUpClientListener;
import org.eclipse.nebula.widgets.nattable.MouseWheelClientListener;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.NatTableLCA;
import org.eclipse.nebula.widgets.nattable.NatTableOperationHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.command.ColumnGroupReorderCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.command.RowGroupReorderCommand;
import org.eclipse.nebula.widgets.nattable.groupby.GroupByCommand;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.RowReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Widget;

public class RAPInitializer {
    public static void initialize() {
        ByteBuddyAgent.install();
        Map<TypeDescription, byte[]> map = Map.of(TypeDescription.ForLoadedType.of(NatTableLCA.class), ClassFileLocator.ForClassLoader.read(NatTableLCA.class), TypeDescription.ForLoadedType.of(NatTableOperationHandler.class), ClassFileLocator.ForClassLoader.read(NatTableOperationHandler.class));
        new ClassInjector.UsingUnsafe(Canvas.class.getClassLoader()).inject(map);
        ByteBuddy byteBuddy = new ByteBuddy();
        byteBuddy.redefine(Canvas.class).visit((AsmVisitorWrapper)Advice.withCustomMapping().with((Advice.PostProcessor.Factory)new Advice.AssignReturned.Factory()).to(AdapterAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"getAdapter"))).make().load(NatTable.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
        byteBuddy.redefine(NatTable.class).visit((AsmVisitorWrapper)Advice.to(ConfigureAdvice.class).on((ElementMatcher)ElementMatchers.named((String)"configure"))).make().load(NatTable.class.getClassLoader(), (ClassLoadingStrategy)ClassReloadingStrategy.fromInstalledAgent());
    }

    public static <T extends ILayer> T findLayer(ILayer layer, int columnPosition, Class<T> layerClass) {
        if (layerClass.isInstance(layer)) {
            return (T)layer;
        }
        T result = null;
        Collection underlyingLayers = layer.getUnderlyingLayersByColumnPosition(columnPosition);
        if (underlyingLayers != null) {
            for (ILayer underlyingLayer : underlyingLayers) {
                if (underlyingLayer != null && (result = (T)RAPInitializer.findLayer(underlyingLayer, columnPosition, layerClass)) != null) break;
            }
        }
        if (result == null && layer instanceof DimensionallyDependentLayer) {
            result = RAPInitializer.findLayer(((DimensionallyDependentLayer)layer).getVerticalLayerDependency(), columnPosition, layerClass);
        }
        if (result == null && layer instanceof DimensionallyDependentLayer) {
            result = RAPInitializer.findLayer(((DimensionallyDependentLayer)layer).getHorizontalLayerDependency(), columnPosition, layerClass);
        }
        if (result == null && layer instanceof CompositeFreezeLayer) {
            result = RAPInitializer.findLayer(((CompositeFreezeLayer)layer).getChildLayerByLayoutCoordinate(1, 1), columnPosition, layerClass);
        }
        return result;
    }

    public static int findColumnHeaderBottomRow(ILayer layer) {
        if (layer instanceof CompositeLayer) {
            CompositeLayer compositeLayer = (CompositeLayer)layer;
            ILayer columnHeader = compositeLayer.getChildLayerByRegionName("COLUMN_HEADER");
            if (columnHeader == null) {
                int x = 0;
                while (x < compositeLayer.getLayoutXCount()) {
                    int rowOffset = 0;
                    int y = 0;
                    while (y < compositeLayer.getLayoutYCount()) {
                        ILayer childLayer = compositeLayer.getChildLayerByLayoutCoordinate(x, y);
                        int bottomRow = RAPInitializer.findColumnHeaderBottomRow(childLayer);
                        if (bottomRow >= 0) {
                            return bottomRow + rowOffset;
                        }
                        rowOffset += childLayer.getRowCount();
                        ++y;
                    }
                    ++x;
                }
            } else {
                return columnHeader.getRowCount() - 1;
            }
        }
        return -1;
    }

    public static int[] findColumnHeaderDimensions(ILayer layer) {
        if (layer instanceof CompositeLayer) {
            CompositeLayer compositeLayer = (CompositeLayer)layer;
            ILayer columnHeader = compositeLayer.getChildLayerByRegionName("COLUMN_HEADER");
            if (columnHeader == null) {
                int x = 0;
                while (x < compositeLayer.getLayoutXCount()) {
                    int rowOffset = 0;
                    int y = 0;
                    while (y < compositeLayer.getLayoutYCount()) {
                        ILayer childLayer = compositeLayer.getChildLayerByLayoutCoordinate(x, y);
                        int[] bottomRow = RAPInitializer.findColumnHeaderDimensions(childLayer);
                        if (bottomRow[0] >= 0) {
                            bottomRow[0] = bottomRow[0] + rowOffset;
                            bottomRow[1] = bottomRow[1] + rowOffset;
                            return bottomRow;
                        }
                        rowOffset += childLayer.getHeight();
                        ++y;
                    }
                    ++x;
                }
            } else {
                ILayerCell bottomRowCell = columnHeader.getCellByPosition(0, columnHeader.getRowCount() - 1);
                if (bottomRowCell != null) {
                    Rectangle bottomRowBounds = bottomRowCell.getBounds();
                    return new int[]{columnHeader.getStartYOfRowPosition(0), bottomRowBounds.y + bottomRowBounds.height};
                }
            }
        }
        return new int[]{-1};
    }

    public static int findRowHeaderRightmostColumn(ILayer layer) {
        if (layer instanceof CompositeLayer) {
            CompositeLayer compositeLayer = (CompositeLayer)layer;
            ILayer rowHeader = compositeLayer.getChildLayerByRegionName("ROW_HEADER");
            if (rowHeader == null) {
                int y = 0;
                while (y < compositeLayer.getLayoutYCount()) {
                    int columnOffset = 0;
                    int x = 0;
                    while (x < compositeLayer.getLayoutXCount()) {
                        ILayer childLayer = compositeLayer.getChildLayerByLayoutCoordinate(x, y);
                        int bottomColumn = RAPInitializer.findRowHeaderRightmostColumn(childLayer);
                        if (bottomColumn >= 0) {
                            return bottomColumn + columnOffset;
                        }
                        columnOffset += childLayer.getColumnCount();
                        ++x;
                    }
                    ++y;
                }
            } else {
                return rowHeader.getColumnCount() - 1;
            }
        }
        return -1;
    }

    public static int[] findRowHeaderDimensions(ILayer layer) {
        if (layer instanceof CompositeLayer) {
            CompositeLayer compositeLayer = (CompositeLayer)layer;
            ILayer rowHeader = compositeLayer.getChildLayerByRegionName("ROW_HEADER");
            if (rowHeader == null) {
                int y = 0;
                while (y < compositeLayer.getLayoutYCount()) {
                    int columnOffset = 0;
                    int x = 0;
                    while (x < compositeLayer.getLayoutXCount()) {
                        ILayer childLayer = compositeLayer.getChildLayerByLayoutCoordinate(x, y);
                        int[] bottomColumn = RAPInitializer.findRowHeaderDimensions(childLayer);
                        if (bottomColumn[0] >= 0) {
                            bottomColumn[0] = bottomColumn[0] + columnOffset;
                            bottomColumn[1] = bottomColumn[1] + columnOffset;
                            return bottomColumn;
                        }
                        columnOffset += childLayer.getWidth();
                        ++x;
                    }
                    ++y;
                }
            } else {
                ILayerCell rightMostCell = rowHeader.getCellByPosition(rowHeader.getColumnCount() - 1, 0);
                if (rightMostCell != null) {
                    Rectangle rightMostBounds = rightMostCell.getBounds();
                    return new int[]{rowHeader.getStartXOfColumnPosition(0), rightMostBounds.x + rightMostBounds.width};
                }
            }
        }
        return new int[]{-1};
    }

    public static void addScrollbars(NatTable natTable, ViewportLayer viewportLayer) {
        Composite parent = natTable.getParent();
        Layout parentLayout = parent.getLayout();
        Object parentLayoutData = parent.getLayoutData();
        if (parentLayoutData == null && parentLayout instanceof GridLayout) {
            parentLayoutData = GridDataFactory.fillDefaults().grab(true, true).create();
        }
        Composite container = new Composite(parent, 0);
        container.setLayoutData(parentLayoutData);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        natTable.setParent(container);
        Composite verticalComposite = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(verticalComposite);
        GridDataFactory.swtDefaults().hint(16, -1).align(1, 4).grab(false, true).applyTo((Control)verticalComposite);
        Slider vertical = new Slider(verticalComposite, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)vertical);
        SliderScroller verticalScroller = new SliderScroller(vertical, false);
        Composite horizontalComposite = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(horizontalComposite);
        GridDataFactory.swtDefaults().hint(-1, 16).align(4, 1).grab(true, false).applyTo((Control)horizontalComposite);
        Slider horizontal = new Slider(horizontalComposite, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)horizontal);
        SliderScroller horizontalScroller = new SliderScroller(horizontal, false);
        RAPInitializer.addMouseWheelListener(natTable, verticalScroller);
        viewportLayer.setVerticalScroller((IScroller)verticalScroller);
        viewportLayer.setHorizontalScroller((IScroller)horizontalScroller);
    }

    public static void addMouseWheelListener(NatTable natTable, IScroller<?> scroller) {
        natTable.addListener(37, (Listener)MouseWheelClientListener.getInstance());
        natTable.addListener(37, (Listener & Serializable)event -> {
            if (event.count > 0) {
                scroller.setSelection(scroller.getSelection() - scroller.getIncrement());
            } else if (event.count < 0) {
                scroller.setSelection(scroller.getSelection() + scroller.getIncrement());
            }
            Event scrollEvent = new Event();
            scrollEvent.detail = 4;
            ((Widget)scroller.getUnderlying()).notifyListeners(13, scrollEvent);
        });
    }

    public static void addMouseUpListener(NatTable natTable) {
        natTable.addListener(4, (Listener)MouseUpClientListener.getInstance());
        natTable.addListener(4, (Listener & Serializable)event -> {
            Object data = event.data;
            if (data != null) {
                String[] dataArray = data.toString().split(" ");
                if ("columnResize".equals(dataArray[0])) {
                    event.doit = false;
                    int pos = Integer.parseInt(dataArray[1]);
                    int widthDiff = Integer.parseInt(dataArray[2]);
                    int width = natTable.getColumnWidthByPosition(pos) + widthDiff;
                    if (width > 0) {
                        natTable.doCommand((ILayerCommand)new ColumnResizeCommand((ILayer)natTable, pos, width));
                    }
                } else if ("rowResize".equals(dataArray[0])) {
                    event.doit = false;
                    int pos = Integer.parseInt(dataArray[1]);
                    int heightDiff = Integer.parseInt(dataArray[2]);
                    int height = natTable.getRowHeightByPosition(pos) + heightDiff;
                    if (height > 0) {
                        natTable.doCommand((ILayerCommand)new RowResizeCommand((ILayer)natTable, pos, height));
                    }
                } else if ("columnDrag".equals(dataArray[0])) {
                    event.doit = false;
                    int startX = Integer.parseInt(dataArray[1]);
                    int endX = Integer.parseInt(dataArray[2]);
                    int endY = Integer.parseInt(dataArray[3]);
                    int fromColumn = natTable.getColumnPositionByX(startX);
                    LabelStack regionLabels = natTable.getRegionLabelsByXY(endX, endY);
                    if (regionLabels != null && regionLabels.hasLabel("GROUP_BY_REGION")) {
                        natTable.doCommand((ILayerCommand)new GroupByCommand(GroupByCommand.GroupByAction.ADD, new int[]{natTable.getColumnIndexByPosition(fromColumn)}));
                    } else if (regionLabels != null && regionLabels.hasLabel("COLUMN_GROUP_HEADER")) {
                        int diffEnd;
                        ILayerCell cell;
                        int toRow = natTable.getRowPositionByY(endY);
                        int columnHeaderBottomRow = RAPInitializer.findColumnHeaderBottomRow(natTable.getLayer());
                        int level = columnHeaderBottomRow - toRow - 1;
                        int toColumn = RAPInitializer.getDragToGridColumnPosition(natTable, endX);
                        int diffStart = toColumn - (cell = natTable.getCellByPosition(toColumn, toRow)).getOriginColumnPosition();
                        toColumn = diffStart < (diffEnd = cell.getOriginColumnPosition() + cell.getColumnSpan() - toColumn) ? cell.getOriginColumnPosition() : cell.getOriginColumnPosition() + cell.getColumnSpan();
                        natTable.doCommand((ILayerCommand)new ColumnGroupReorderCommand((ILayer)natTable, level, fromColumn, toColumn));
                    } else {
                        int toColumn = RAPInitializer.getDragToGridColumnPosition(natTable, endX);
                        natTable.doCommand((ILayerCommand)new ColumnReorderCommand((ILayer)natTable, fromColumn, toColumn));
                    }
                } else if ("rowDrag".equals(dataArray[0])) {
                    event.doit = false;
                    int startY = Integer.parseInt(dataArray[1]);
                    int endX = Integer.parseInt(dataArray[2]);
                    int endY = Integer.parseInt(dataArray[3]);
                    int fromRow = natTable.getRowPositionByY(startY);
                    int toRow = RAPInitializer.getDragToGridRowPosition(natTable, endY);
                    LabelStack regionLabels = natTable.getRegionLabelsByXY(endX, endY);
                    if (regionLabels != null && regionLabels.hasLabel("ROW_GROUP_HEADER")) {
                        int diffEnd;
                        int toColumn = natTable.getColumnPositionByX(endX);
                        int rowHeaderRightmostColumn = RAPInitializer.findRowHeaderRightmostColumn(natTable.getLayer());
                        int level = rowHeaderRightmostColumn - toColumn - 1;
                        ILayerCell cell = natTable.getCellByPosition(toColumn, toRow);
                        int diffStart = toRow - cell.getOriginRowPosition();
                        toRow = diffStart < (diffEnd = cell.getOriginRowPosition() + cell.getRowSpan() - toRow) ? cell.getOriginRowPosition() : cell.getOriginRowPosition() + cell.getRowSpan();
                        natTable.doCommand((ILayerCommand)new RowGroupReorderCommand((ILayer)natTable, level, fromRow, toRow));
                    } else {
                        natTable.doCommand((ILayerCommand)new RowReorderCommand((ILayer)natTable, fromRow, toRow));
                    }
                }
            }
        });
    }

    protected static int getDragToGridColumnPosition(NatTable natTable, int x) {
        int dragToGridColumnPosition = -1;
        int gridColumnPosition = natTable.getColumnPositionByX(x);
        CellEdgeEnum moveDirection = RAPInitializer.getHorizontalMoveDirection(natTable, x);
        if (moveDirection != null) {
            if (moveDirection == CellEdgeEnum.LEFT) {
                dragToGridColumnPosition = gridColumnPosition;
            } else if (moveDirection == CellEdgeEnum.RIGHT) {
                dragToGridColumnPosition = gridColumnPosition + 1;
            }
        }
        return dragToGridColumnPosition;
    }

    protected static CellEdgeEnum getHorizontalMoveDirection(NatTable natTable, int x) {
        ILayerCell cell = RAPInitializer.getColumnCell(natTable, x);
        if (cell != null) {
            Rectangle selectedColumnHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getHorizontalCellEdge((Rectangle)selectedColumnHeaderRect, (Point)new Point(x, selectedColumnHeaderRect.y + selectedColumnHeaderRect.height / 2));
        }
        return null;
    }

    protected static ILayerCell getColumnCell(NatTable natTable, int x) {
        int gridColumnPosition = natTable.getColumnPositionByX(x);
        int gridRowPosition = RAPInitializer.findColumnHeaderBottomRow(natTable.getLayer());
        return natTable.getCellByPosition(gridColumnPosition, gridRowPosition);
    }

    protected static int getDragToGridRowPosition(NatTable natTable, int y) {
        int dragToGridRowPosition = -1;
        int gridRowPosition = natTable.getRowPositionByY(y);
        CellEdgeEnum moveDirection = RAPInitializer.getVerticalMoveDirection(natTable, y);
        if (moveDirection != null) {
            if (moveDirection == CellEdgeEnum.TOP) {
                dragToGridRowPosition = gridRowPosition;
            } else if (moveDirection == CellEdgeEnum.BOTTOM) {
                dragToGridRowPosition = gridRowPosition + 1;
            }
        }
        return dragToGridRowPosition;
    }

    protected static CellEdgeEnum getVerticalMoveDirection(NatTable natTable, int y) {
        ILayerCell cell = RAPInitializer.getRowCell(natTable, y);
        if (cell != null) {
            Rectangle selectedRowHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getVerticalCellEdge((Rectangle)selectedRowHeaderRect, (Point)new Point(selectedRowHeaderRect.x + selectedRowHeaderRect.width / 2, y));
        }
        return null;
    }

    protected static ILayerCell getRowCell(NatTable natTable, int y) {
        int gridColumnPosition = RAPInitializer.findRowHeaderRightmostColumn(natTable.getLayer());
        int gridRowPosition = natTable.getRowPositionByY(y);
        return natTable.getCellByPosition(gridColumnPosition, gridRowPosition);
    }

    public class AdapterAdvice {
        @Advice.OnMethodEnter
        private static <T> T onEnter(@Advice.Argument(value=0) Class<T> adapter, @Advice.This Object thiz) {
            boolean isNatTable = false;
            Class<?> cls = thiz.getClass();
            while (cls != null) {
                if ("org.eclipse.nebula.widgets.nattable.NatTable".equals(cls.getName()) && adapter == WidgetLCA.class) {
                    isNatTable = true;
                    break;
                }
                cls = cls.getSuperclass();
            }
            if (isNatTable) {
                return (T)((Object)NatTableLCA.INSTANCE);
            }
            return null;
        }

        @Advice.OnMethodExit
        @Advice.AssignReturned.ToReturned
        private static <T> T onExit(@Advice.Enter T enterValue, @Advice.Return(readOnly=false) T returnValue) {
            if (enterValue != null) {
                return enterValue;
            }
            return returnValue;
        }
    }

    public class ConfigureAdvice {
        @Advice.OnMethodExit
        private static void onExit(@Advice.This Object thiz) {
            final NatTable natTable = (NatTable)thiz;
            WidgetUtil.registerDataKeys((String[])new String[]{"control", "columnHeaderDimensions", "rowHeaderDimensions", "columnBorders", "columnResizeBorders", "columnPositionToResize", "initialResizeX", "rowBorders", "rowResizeBorders", "rowPositionToResize", "initialResizeY", "columnDragEnabled", "columnDragStartX", "rowDragEnabled", "rowDragStartY"});
            natTable.setData("control", (Object)WidgetUtil.getId((Widget)natTable));
            natTable.doCommand((ILayerCommand)new TurnViewportOffCommand());
            ViewportLayer viewPortLayer = RAPInitializer.findLayer(natTable.getLayer(), 0, ViewportLayer.class);
            if (viewPortLayer != null && viewPortLayer.getVerticalScroller() == null && viewPortLayer.getHorizontalScroller() == null) {
                RAPInitializer.addScrollbars(natTable, viewPortLayer);
            } else if (viewPortLayer != null && viewPortLayer.getVerticalScroller() != null) {
                RAPInitializer.addMouseWheelListener(natTable, viewPortLayer.getVerticalScroller());
            }
            natTable.doCommand((ILayerCommand)new TurnViewportOnCommand());
            natTable.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    Rectangle bounds;
                    int i;
                    Rectangle firstBodyBounds;
                    int columnHeaderBottomRow = RAPInitializer.findColumnHeaderBottomRow(natTable.getLayer());
                    int rowHeaderRightmostColumn = RAPInitializer.findRowHeaderRightmostColumn(natTable.getLayer());
                    if (columnHeaderBottomRow >= 0 && natTable.getColumnCount() > 0) {
                        int columnHeaderColumn = rowHeaderRightmostColumn >= 0 ? rowHeaderRightmostColumn + 1 : 0;
                        int[] columnHeaderDimensions = RAPInitializer.findColumnHeaderDimensions(natTable.getLayer());
                        natTable.setData("columnHeaderDimensions", (Object)Arrays.toString(columnHeaderDimensions));
                        MutableIntList columnResizeBorders = IntLists.mutable.empty();
                        MutableIntList columnBorders = IntLists.mutable.empty();
                        int i2 = 0;
                        while (i2 < columnHeaderColumn) {
                            columnResizeBorders.add(-10);
                            ++i2;
                        }
                        ILayerCell firstBodyCell = natTable.getCellByPosition(columnHeaderColumn, columnHeaderBottomRow);
                        if (firstBodyCell != null) {
                            firstBodyBounds = firstBodyCell.getBounds();
                            columnBorders.add(firstBodyBounds.x);
                            i = columnHeaderColumn;
                            while (i < natTable.getColumnCount()) {
                                bounds = natTable.getCellByPosition(i, columnHeaderBottomRow).getBounds();
                                if (natTable.isColumnPositionResizable(i)) {
                                    columnResizeBorders.add(bounds.x + bounds.width);
                                } else {
                                    columnResizeBorders.add(-10);
                                }
                                columnBorders.add(bounds.x + bounds.width);
                                ++i;
                            }
                            natTable.setData("columnResizeBorders", (Object)columnResizeBorders.toArray());
                            natTable.setData("columnBorders", (Object)columnBorders.toArray());
                            if (RAPInitializer.findLayer(natTable.getLayer(), 0, ColumnReorderLayer.class) != null || natTable.getProvidedLabels().contains("GROUP_BY_REGION")) {
                                natTable.setData("columnDragEnabled", (Object)Boolean.TRUE);
                            }
                            if (RAPInitializer.findLayer(natTable.getLayer(), 0, RowReorderLayer.class) != null) {
                                natTable.setData("rowDragEnabled", (Object)Boolean.TRUE);
                            }
                        }
                    }
                    if (rowHeaderRightmostColumn >= 0 && natTable.getRowCount() > 0) {
                        int rowHeaderRow = columnHeaderBottomRow >= 0 ? columnHeaderBottomRow + 1 : 0;
                        int[] rowHeaderDimensions = RAPInitializer.findRowHeaderDimensions(natTable.getLayer());
                        natTable.setData("rowHeaderDimensions", (Object)Arrays.toString(rowHeaderDimensions));
                        MutableIntList rowResizeBorders = IntLists.mutable.empty();
                        MutableIntList rowBorders = IntLists.mutable.empty();
                        int i3 = 0;
                        while (i3 < rowHeaderRow) {
                            rowResizeBorders.add(-10);
                            ++i3;
                        }
                        ILayerCell firstBodyCell = natTable.getCellByPosition(rowHeaderRightmostColumn, rowHeaderRow);
                        if (firstBodyCell != null) {
                            firstBodyBounds = firstBodyCell.getBounds();
                            rowBorders.add(firstBodyBounds.y);
                            i = rowHeaderRow;
                            while (i < natTable.getRowCount()) {
                                bounds = natTable.getCellByPosition(rowHeaderRightmostColumn, i).getBounds();
                                if (natTable.isRowPositionResizable(i)) {
                                    rowResizeBorders.add(bounds.y + bounds.height);
                                } else {
                                    rowResizeBorders.add(-10);
                                }
                                rowBorders.add(bounds.y + bounds.height);
                                ++i;
                            }
                            natTable.setData("rowResizeBorders", (Object)rowResizeBorders.toArray());
                            natTable.setData("rowBorders", (Object)rowBorders.toArray());
                        }
                    }
                }
            });
            natTable.addListener(3, (Listener)MouseDownClientListener.getInstance());
            natTable.addListener(5, (Listener)MouseMoveClientListener.getInstance());
            RAPInitializer.addMouseUpListener(natTable);
            ServerPushSession pushSession = new ServerPushSession();
            pushSession.start();
            natTable.addDisposeListener((DisposeListener)new PushSessionDisposeListener(pushSession));
        }
    }

    public static class PushSessionDisposeListener
    implements DisposeListener {
        final ServerPushSession pushSession;

        public PushSessionDisposeListener(ServerPushSession pushSession) {
            this.pushSession = pushSession;
        }

        public void widgetDisposed(DisposeEvent event) {
            this.pushSession.stop();
        }
    }
}

