/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataExternalizer;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.xml.sax.SAXParseException;

public class TaskDataExternalizerTest
extends TestCase {
    private TaskDataExternalizer externalizer;
    private TaskRepository repository;

    protected void setUp() throws Exception {
        TaskRepositoryManager taskRepositoryManager = new TaskRepositoryManager();
        taskRepositoryManager.addRepositoryConnector((AbstractRepositoryConnector)new MockRepositoryConnector());
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        taskRepositoryManager.addRepository(this.repository);
        this.externalizer = new TaskDataExternalizer((IRepositoryManager)taskRepositoryManager);
    }

    public void testRead() throws Exception {
        ZipInputStream in = new ZipInputStream(CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/taskdata-1.0-bug-219897.zip"));
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                in.getNextEntry();
                TaskDataState taskDataState = this.externalizer.readState((InputStream)in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void testReadWrite() throws Exception {
        TaskDataState state;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ZipInputStream in = new ZipInputStream(CommonTestUtil.getResource((Object)((Object)this), (String)"testdata/taskdata-1.0-bug-219897.zip"));){
            in.getNextEntry();
            state = this.externalizer.readState((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.externalizer.writeState((OutputStream)out, (ITaskDataWorkingCopy)state);
        TaskDataState state2 = this.externalizer.readState((InputStream)new ByteArrayInputStream(out.toByteArray()));
        TaskDataExternalizerTest.assertEquals((String)state.getConnectorKind(), (String)state2.getConnectorKind());
        TaskDataExternalizerTest.assertEquals((String)state.getRepositoryUrl(), (String)state2.getRepositoryUrl());
        TaskDataExternalizerTest.assertEquals((String)state.getTaskId(), (String)state2.getTaskId());
        TaskDataExternalizerTest.assertEquals((String)state.getRepositoryData().getRoot().toString(), (String)state2.getRepositoryData().getRoot().toString());
    }

    public void testReadWriteInvalidCharactersXML11() throws Exception {
        TaskData data = new TaskData(new TaskAttributeMapper(this.repository), this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "1");
        data.getRoot().createAttribute("attribute").setValue("\u0000");
        TaskDataState state = new TaskDataState(this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "1");
        state.setRepositoryData(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.externalizer.writeState((OutputStream)out, (ITaskDataWorkingCopy)state);
        try {
            this.externalizer.readState((InputStream)new ByteArrayInputStream(out.toByteArray()));
            TaskDataExternalizerTest.fail((String)"Expected SAXParseException");
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
    }

    public void testReadWriteInvalidCharactersXML10() throws Exception {
        TaskData data = new TaskData(new TaskAttributeMapper(this.repository), this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "1");
        data.getRoot().createAttribute("attribute").setValue("\u0001\u001f");
        TaskDataState state = new TaskDataState(this.repository.getConnectorKind(), this.repository.getRepositoryUrl(), "1");
        state.setRepositoryData(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.externalizer.writeState((OutputStream)out, (ITaskDataWorkingCopy)state);
        this.externalizer.readState((InputStream)new ByteArrayInputStream(out.toByteArray()));
        TaskDataState state2 = this.externalizer.readState((InputStream)new TaskDataExternalizer.Xml11InputStream((InputStream)new ByteArrayInputStream(out.toByteArray())));
        TaskDataExternalizerTest.assertEquals((String)state.getRepositoryData().getRoot().toString(), (String)state2.getRepositoryData().getRoot().toString());
        TaskDataExternalizerTest.assertEquals((String)"\u0001\u001f", (String)state2.getRepositoryData().getRoot().getAttribute("attribute").getValue());
    }
}

