/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.internal.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTemplateManager;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritServerUtility {
    private static final String LAST_GERRIT_FILE = "lastGerrit.txt";
    private static GerritServerUtility instance = null;
    private static Map<TaskRepository, String> fResultTask = new HashMap<TaskRepository, String>();

    public GerritServerUtility() {
        instance = this;
        this.mapConfiguredGerritServer();
    }

    private Map<TaskRepository, String> mapConfiguredGerritServer() {
        fResultTask.clear();
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        GerritPlugin.Ftracer.traceInfo("--------Review repo ---------------");
        Set reviewRepo = repositoryManager.getRepositories("org.eclipse.mylyn.gerrit");
        for (TaskRepository taskRepo : reviewRepo) {
            GerritPlugin.Ftracer.traceInfo("Add Gerrit Review repo: " + taskRepo.getRepositoryLabel() + "\t url: " + taskRepo.getRepositoryUrl());
            fResultTask.put(taskRepo, taskRepo.getRepositoryUrl());
            if (taskRepo.getRepositoryUrl() == null) continue;
            this.adjustTemplatemanager(taskRepo);
        }
        this.printRepositoryTemplate();
        return fResultTask;
    }

    private void adjustTemplatemanager(TaskRepository aTaskRepo) {
        RepositoryTemplateManager templateManager = TasksUiPlugin.getRepositoryTemplateManager();
        boolean found = false;
        for (RepositoryTemplate template : templateManager.getTemplates("org.eclipse.mylyn.gerrit")) {
            String convertedRemoteURL = aTaskRepo.getRepositoryUrl();
            GerritPlugin.Ftracer.traceInfo("\t template.label: " + template.label + "\t repo label: " + aTaskRepo.getRepositoryLabel() + " repo getname: " + convertedRemoteURL);
            if (!template.label.equals(aTaskRepo.getRepositoryLabel()) && !template.repositoryUrl.equals(convertedRemoteURL)) continue;
            found = true;
            break;
        }
        if (!found) {
            String userName = aTaskRepo.getUserName();
            Boolean anonymous = userName == null || userName.isEmpty();
            RepositoryTemplate templateTest = new RepositoryTemplate(aTaskRepo.getRepositoryLabel(), aTaskRepo.getRepositoryUrl(), aTaskRepo.getCharacterEncoding(), aTaskRepo.getVersion(), "", "", "", aTaskRepo.getUserName(), anonymous.booleanValue(), true);
            Map attributes = aTaskRepo.getProperties();
            Set value = attributes.entrySet();
            for (Map.Entry entry : value) {
                templateTest.addAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            templateManager.addTemplate("org.eclipse.mylyn.gerrit", templateTest);
        }
    }

    private void printRepositoryTemplate() {
        RepositoryTemplateManager templateManager = TasksUiPlugin.getRepositoryTemplateManager();
        for (RepositoryTemplate template : templateManager.getTemplates("org.eclipse.mylyn.gerrit")) {
            GerritPlugin.Ftracer.traceInfo("------------======================------------------");
            Set value = template.getAttributes().entrySet();
            for (Map.Entry entry : value) {
                GerritPlugin.Ftracer.traceInfo("key: " + (String)entry.getKey() + "\tvalue: " + (String)entry.getValue());
            }
        }
    }

    private File getLastGerritFile() {
        IPath ipath = GerritUi.getDefault().getStateLocation();
        String fileName = ipath.append(LAST_GERRIT_FILE).toPortableString();
        File file = new File(fileName);
        return file;
    }

    public static GerritServerUtility getDefault() {
        if (instance == null) {
            new GerritServerUtility();
        }
        return instance;
    }

    public static Map<TaskRepository, String> getGerritMapping() {
        return fResultTask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean saveLastGerritServer(String aURL) {
        boolean ok = true;
        File file = this.getLastGerritFile();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileWriter fw = new FileWriter(file);
                try {
                    try (BufferedWriter out = new BufferedWriter(fw);){
                        out.write(aURL);
                    }
                    if (fw == null) return ok;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fw == null) throw throwable;
                    fw.close();
                    throw throwable;
                }
                fw.close();
                return ok;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            ok = false;
        }
        return ok;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getLastSavedGerritServer() {
        String lastGerritURL = null;
        File file = this.getLastGerritFile();
        if (file == null) return lastGerritURL;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileReader fr = new FileReader(file);
                try {
                    try (BufferedReader in = new BufferedReader(fr);){
                        lastGerritURL = in.readLine();
                    }
                    if (fr == null) return lastGerritURL;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return lastGerritURL;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lastGerritURL;
    }

    public String getMenuSelectionURL(String aSt) {
        String urlStr = null;
        if (!fResultTask.isEmpty()) {
            Set<TaskRepository> mapSet = fResultTask.keySet();
            GerritPlugin.Ftracer.traceInfo("-------------------");
            for (TaskRepository key : mapSet) {
                if (!key.getRepositoryLabel().equals(aSt)) continue;
                urlStr = fResultTask.get(key);
                GerritPlugin.Ftracer.traceInfo("Map Key: " + key.getRepositoryLabel() + "\t URL: " + fResultTask.get(key));
                return urlStr;
            }
        }
        return urlStr;
    }

    public TaskRepository getTaskRepo(String aStURL) {
        if (aStURL != null && !fResultTask.isEmpty()) {
            Set<TaskRepository> mapSet = fResultTask.keySet();
            GerritPlugin.Ftracer.traceInfo("-------------------");
            for (TaskRepository key : mapSet) {
                if (!key.getRepositoryUrl().equals(aStURL)) continue;
                GerritPlugin.Ftracer.traceInfo("Key label : " + key.getRepositoryLabel() + "\t URL: " + fResultTask.get(key));
                return key;
            }
        }
        return null;
    }
}

