/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class BugzillaFlagPart
extends AbstractTaskEditorPart {
    private static final int LABEL_WIDTH = 110;
    private static final int COLUMN_WIDTH = 140;
    private static final int COLUMN_GAP = 20;
    private static final int MULTI_COLUMN_WIDTH = 420;
    private static final int MULTI_ROW_HEIGHT = 55;
    private boolean hasIncoming;
    private List<AbstractAttributeEditor> flagEditors;
    private String infoOverlayText = null;
    private String infoOverlayTooltipText = null;

    public BugzillaFlagPart() {
        this.setPartName(Messages.BugzillaFlagPart_Flags_PartName);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.initialize();
        int style = 8194;
        if (this.hasIncoming) {
            style |= 0x40;
        }
        Section flagSection = this.createSection(parent, toolkit, style);
        EditorUtil.setTitleBarForeground((ExpandableComposite)flagSection, (Color)toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridLayout gl = new GridLayout();
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 4;
        flagSection.setLayout((Layout)gl);
        flagSection.setLayoutData((Object)gd);
        Composite flagComposite = toolkit.createComposite((Composite)flagSection);
        GridLayout flagsLayout = EditorUtil.createSectionClientLayout();
        flagsLayout.numColumns = 4;
        flagsLayout.horizontalSpacing = 7;
        flagsLayout.verticalSpacing = 6;
        flagComposite.setLayout((Layout)flagsLayout);
        GridData flagsData = new GridData(1808);
        flagsData.horizontalSpan = 1;
        flagsData.grabExcessVerticalSpace = false;
        flagComposite.setLayoutData((Object)flagsData);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)flagComposite);
        this.createAttributeControls(flagComposite, toolkit, flagsLayout.numColumns);
        flagSection.setClient((Control)flagComposite);
        toolkit.paintBordersFor(flagComposite);
        this.setSection(toolkit, flagSection);
    }

    private void initialize() {
        this.hasIncoming = false;
        this.flagEditors = new ArrayList<AbstractAttributeEditor>();
        int used = 0;
        int unused = 0;
        Object usedDetail = "";
        Object unusedDetail = "";
        Map attributes = this.getTaskData().getRoot().getAttributes();
        for (TaskAttribute attribute : attributes.values()) {
            TaskAttribute stateAttribute;
            if (!"task.common.kind.flag".equals(attribute.getMetaData().getKind()) || (stateAttribute = attribute.getAttribute("state")) == null) continue;
            String val = stateAttribute.getValue();
            if (val != null && !val.equals("") && !val.equals(" ")) {
                if (used > 0) {
                    usedDetail = (String)usedDetail + ", ";
                }
                ++used;
                usedDetail = (String)usedDetail + stateAttribute.getMetaData().getLabel();
            } else {
                if (unused > 0) {
                    unusedDetail = (String)unusedDetail + ", ";
                }
                ++unused;
                unusedDetail = (String)unusedDetail + stateAttribute.getMetaData().getLabel();
            }
            AbstractAttributeEditor attributeEditor = this.createAttributeEditor(attribute);
            if (attributeEditor == null) continue;
            this.flagEditors.add(attributeEditor);
            if (!this.getModel().hasIncomingChanges(attribute)) continue;
            this.hasIncoming = true;
        }
        Comparator<AbstractAttributeEditor> attributeSorter = this.createAttributeEditorSorter();
        if (attributeSorter != null) {
            Collections.sort(this.flagEditors, attributeSorter);
        }
        this.infoOverlayText = used > 0 ? NLS.bind((String)(" " + Messages.BugzillaFlagPart_Fleg_Section_Title), (Object)("" + (unused + used)), (Object)("" + used)) : NLS.bind((String)(" " + Messages.BugzillaFlagPart_Fleg_Section_Title_Short), (Object)("" + (unused + used)));
        usedDetail = NLS.bind((String)"{0} {1}", (Object)(used == 1 ? Messages.BugzillaFlagPart_used_flag + Messages.BugzillaFlagPart_is : Messages.BugzillaFlagPart_used_flags + Messages.BugzillaFlagPart_are), (Object)usedDetail);
        unusedDetail = NLS.bind((String)"{0} {1}", (Object)(unused == 1 ? Messages.BugzillaFlagPart_unused_flag + Messages.BugzillaFlagPart_is : Messages.BugzillaFlagPart_unused_flags + Messages.BugzillaFlagPart_are), (Object)unusedDetail);
        this.infoOverlayTooltipText = used > 0 && unused > 0 ? NLS.bind((String)"{0}\n{1}", (Object)usedDetail, (Object)unusedDetail) : (used > 0 ? usedDetail : unusedDetail);
    }

    protected Comparator<AbstractAttributeEditor> createAttributeEditorSorter() {
        return (o1, o2) -> {
            int p1 = o1.getLayoutHint() != null ? o1.getLayoutHint().getPriority() : 10;
            int p2 = o2.getLayoutHint() != null ? o2.getLayoutHint().getPriority() : 10;
            return p1 - p2;
        };
    }

    private void createAttributeControls(Composite attributesComposite, FormToolkit toolkit, int columnCount) {
        int currentColumn = 1;
        int currentPriority = 0;
        for (AbstractAttributeEditor attributeEditor : this.flagEditors) {
            int priority;
            int n = priority = attributeEditor.getLayoutHint() != null ? attributeEditor.getLayoutHint().getPriority() : 10;
            if (priority != currentPriority) {
                currentPriority = priority;
                if (currentColumn > 1) {
                    while (currentColumn <= columnCount) {
                        this.getManagedForm().getToolkit().createLabel(attributesComposite, "");
                        ++currentColumn;
                    }
                    currentColumn = 1;
                }
            }
            if (attributeEditor.hasLabel()) {
                attributeEditor.createLabelControl(attributesComposite, toolkit);
                Label label = attributeEditor.getLabelControl();
                String text = label.getText();
                String shortenText = TaskDiffUtil.shortenText((Drawable)label, (String)text, (int)110);
                label.setText(shortenText);
                if (!text.equals(shortenText)) {
                    label.setToolTipText(text);
                }
                GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(110, -1).create();
                if (currentColumn > 1) {
                    gd.horizontalIndent = 20;
                    gd.widthHint = 130;
                }
                label.setLayoutData((Object)gd);
                ++currentColumn;
            }
            attributeEditor.createControl(attributesComposite, toolkit);
            LayoutHint layoutHint = attributeEditor.getLayoutHint();
            GridData gd = new GridData(4, 0x1000000, false, false);
            if (layoutHint != null && (layoutHint.rowSpan != LayoutHint.RowSpan.SINGLE || layoutHint.columnSpan != LayoutHint.ColumnSpan.SINGLE)) {
                if (layoutHint.rowSpan == LayoutHint.RowSpan.MULTIPLE) {
                    gd.heightHint = 55;
                }
                if (layoutHint.columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                    gd.widthHint = 140;
                    gd.horizontalSpan = 1;
                } else {
                    gd.widthHint = 420;
                    gd.horizontalSpan = columnCount - currentColumn + 1;
                }
            } else {
                gd.widthHint = 140;
                gd.horizontalSpan = 1;
            }
            attributeEditor.getControl().setLayoutData((Object)gd);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
            currentColumn += gd.horizontalSpan;
            currentColumn %= columnCount;
        }
    }

    protected String getInfoOverlayText() {
        return this.infoOverlayText;
    }

    protected String getInfoOverlayTooltipText() {
        return this.infoOverlayTooltipText;
    }

    private void createInfoOverlay(Composite composite, Section section, FormToolkit toolkit) {
        String text = this.getInfoOverlayText();
        if (text == null) {
            return;
        }
        final Label label = toolkit.createLabel(composite, LegacyActionTools.escapeMnemonics((String)text));
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setBackground(null);
        label.setVisible(!section.isExpanded());
        label.setToolTipText(this.getInfoOverlayTooltipText());
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                label.setVisible(!e.getState());
            }
        });
    }

    protected void setSection(FormToolkit toolkit, Section section) {
        if (section.getTextClient() == null) {
            ToolBarManager toolBarManager = new ToolBarManager(0x800000);
            this.fillToolBar(toolBarManager);
            if (toolBarManager.getSize() > 0 || this.getInfoOverlayText() != null) {
                Composite toolbarComposite = toolkit.createComposite((Composite)section);
                toolbarComposite.setBackground(null);
                RowLayout rowLayout = new RowLayout();
                rowLayout.marginLeft = 0;
                rowLayout.marginRight = 0;
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                rowLayout.center = true;
                toolbarComposite.setLayout((Layout)rowLayout);
                this.createInfoOverlay(toolbarComposite, section, toolkit);
                toolBarManager.createControl(toolbarComposite);
                section.clientVerticalSpacing = 0;
                section.descriptionVerticalSpacing = 0;
                section.setTextClient((Control)toolbarComposite);
            }
        }
        this.setControl((Control)section);
    }
}

