/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.validation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

@Singleton
public class LanguageAwareMarkerTypeProvider
extends MarkerTypeProvider {
    protected String fastValidationMarker;
    protected String normalValidationMarker;
    protected String expensiveValidationMarker;

    @Inject
    public void initialize(LanguageInfo languageInfo, AbstractUIPlugin uiPlugin) {
        String bundleName = uiPlugin.getBundle().getSymbolicName();
        String languageName = languageInfo.getShortName().toLowerCase();
        this.setMarkerTypes(bundleName + "." + languageName);
    }

    protected void setMarkerTypes(String baseName) {
        Object markerType;
        MarkerTypesModel markerTypesModel = MarkerTypesModel.getInstance();
        if (markerTypesModel.getType((String)(markerType = baseName + ".check.fast")) == null) {
            markerType = "org.eclipse.xtext.ui.check.fast";
        }
        this.fastValidationMarker = markerType;
        markerType = baseName + ".check.normal";
        if (markerTypesModel.getType((String)markerType) == null) {
            markerType = "org.eclipse.xtext.ui.check.normal";
        }
        this.normalValidationMarker = markerType;
        markerType = baseName + ".check.expensive";
        if (markerTypesModel.getType((String)markerType) == null) {
            markerType = "org.eclipse.xtext.ui.check.expensive";
        }
        this.expensiveValidationMarker = markerType;
    }

    @Override
    public String getMarkerType(Issue issue) {
        CheckType type = issue.getType();
        if (type == null) {
            return super.getMarkerType(issue);
        }
        switch (type) {
            case FAST: {
                return this.fastValidationMarker;
            }
            case NORMAL: {
                return this.normalValidationMarker;
            }
            case EXPENSIVE: {
                return this.expensiveValidationMarker;
            }
        }
        throw new IllegalStateException("issue.getType was " + String.valueOf(issue.getType()));
    }

    @Override
    public CheckType getCheckType(String markerType) {
        if (this.fastValidationMarker.equals(markerType)) {
            return CheckType.FAST;
        }
        if (this.normalValidationMarker.equals(markerType)) {
            return CheckType.NORMAL;
        }
        if (this.expensiveValidationMarker.equals(markerType)) {
            return CheckType.EXPENSIVE;
        }
        return super.getCheckType(markerType);
    }
}

