/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting.impl.BaseFormatter;
import org.eclipse.xtext.formatting.impl.BaseTokenStream;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;

public class OneWhitespaceFormatter
extends BaseFormatter {
    @Override
    public ITokenStream createFormatterStream(String initalIndentation, ITokenStream outputStream, boolean preserveWhitespaces) {
        return new OneWhitespaceFormatterStream(outputStream, preserveWhitespaces);
    }

    protected class OneWhitespaceFormatterStream
    extends BaseTokenStream {
        protected boolean hasStarted;
        protected boolean preserveWS;
        protected boolean wsWritten;

        public OneWhitespaceFormatterStream(ITokenStream out, boolean preserve) {
            super(out);
            this.hasStarted = false;
            this.wsWritten = false;
            this.preserveWS = preserve;
        }

        protected boolean isComment(EObject grammarElement, String value) {
            return grammarElement != OneWhitespaceFormatter.this.getWSRule();
        }

        @Override
        public void writeHidden(EObject grammarElement, String value) throws IOException {
            boolean isCmt = this.isComment(grammarElement, value);
            if (this.preserveWS || isCmt) {
                if (isCmt) {
                    this.writeSpaceIfNecessary();
                    this.hasStarted = true;
                }
                this.out.writeHidden(grammarElement, value);
                this.wsWritten = !isCmt;
            }
        }

        @Override
        public void writeSemantic(EObject grammarElement, String value) throws IOException {
            this.writeSpaceIfNecessary();
            this.hasStarted = true;
            this.out.writeSemantic(grammarElement, value);
            this.wsWritten = false;
        }

        protected void writeSpaceIfNecessary() throws IOException {
            if (this.hasStarted && !this.wsWritten) {
                this.out.writeHidden(OneWhitespaceFormatter.this.getWSRule(), " ");
                this.wsWritten = true;
            }
        }
    }
}

