/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractProfileMigrationDialog
extends FormDialog {
    private String title;
    private String prefConst;
    private Button checkBox;

    public AbstractProfileMigrationDialog(Shell shell, String title, String prefConst) {
        super(shell);
        this.title = title;
        this.prefConst = prefConst;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(this.title);
        ScrolledForm scrolledForm = mform.getForm();
        FormToolkit toolkit = mform.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createDescriptionSections(scrolledForm.getBody(), toolkit);
        this.createMigrationActionSections(scrolledForm.getBody(), toolkit);
        this.dontShowItAgainCheckbox(scrolledForm.getBody(), toolkit);
        this.hookListeners();
    }

    protected void createDescriptionSections(Composite body, FormToolkit toolkit) {
        String lSectionTitle = this.getDecriptionSectionTitle();
        Section lSection = toolkit.createSection(body, 320);
        lSection.setLayoutData((Object)new GridData(1040));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = toolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 1;
        lBody.setLayout((Layout)lLayout);
        if (this.getDecription() != null) {
            toolkit.createLabel(lBody, this.getDecription(), 64);
        }
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected String getDecriptionSectionTitle() {
        return Messages.AbstractProfileMigrationDialog_description;
    }

    protected abstract String getDecription();

    protected void createMigrationActionSections(Composite body, FormToolkit toolkit) {
        String lSectionTitle = this.getMigrationActionSectionTitle();
        Section lSection = toolkit.createSection(body, 320);
        lSection.setLayoutData((Object)new GridData(1808));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = toolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        FillLayout lLayout = new FillLayout();
        lLayout.type = 256;
        lBody.setLayout((Layout)lLayout);
        this.getMigrationActionSectionContent(lBody, toolkit);
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected String getMigrationActionSectionTitle() {
        return Messages.AbstractProfileMigrationDialog_MigrateAction;
    }

    protected abstract void getMigrationActionSectionContent(Composite var1, FormToolkit var2);

    protected Control dontShowItAgainCheckbox(Composite body, FormToolkit toolkit) {
        this.checkBox = toolkit.createButton(body, Messages.AbstractProfileMigrationDialog_DoNotShowItAgain, 16416);
        return this.checkBox;
    }

    private void hookListeners() {
        SelectionAdapter selectCreateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() instanceof Button) {
                    boolean doNotShow = ((Button)e.getSource()).getSelection();
                    IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
                    prefStore.putValue(AbstractProfileMigrationDialog.this.prefConst, Boolean.toString(!doNotShow));
                }
            }
        };
        this.checkBox.addSelectionListener((SelectionListener)selectCreateListener);
    }
}

