/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.deployment.services;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;

public class DeploymentDiagramServices
extends AbstractDiagramServices {
    private CommonDiagramServices commonDiagramServices = new CommonDiagramServices();

    public boolean canCreateManifestationDD(EObject source, EObject target, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        boolean canCreate = false;
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        if (source instanceof Artifact) {
            canCreate = domainBasedEdgeServices.canCreateDomainBasedEdge(source, target, UMLPackage.eINSTANCE.getManifestation().getName(), UMLPackage.eINSTANCE.getArtifact_Manifestation().getName(), sourceView, targetView);
        } else if (source instanceof PackageableElement) {
            canCreate = domainBasedEdgeServices.canCreateDomainBasedEdge(source, target, UMLPackage.eINSTANCE.getManifestation().getName(), UMLPackage.eINSTANCE.getPackage_PackagedElement().getName(), sourceView, targetView);
        }
        return canCreate;
    }

    public EObject createManifestationDD(EObject source, EObject target, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        EObject result = null;
        if (source instanceof Artifact) {
            domainBasedEdgeServices.createDomainBasedEdge(source, target, UMLPackage.eINSTANCE.getManifestation().getName(), UMLPackage.eINSTANCE.getArtifact_Manifestation().getName(), sourceView, targetView);
        } else if (source instanceof PackageableElement) {
            domainBasedEdgeServices.createDomainBasedEdge(source, target, UMLPackage.eINSTANCE.getManifestation().getName(), UMLPackage.eINSTANCE.getPackage_PackagedElement().getName(), sourceView, targetView);
        }
        return result;
    }

    public List<? extends Artifact> getArtifactCandidates(Element container) {
        Optional<EReference> optionalContainmentFeature = this.getArtifactContainmentFeature(container);
        if (optionalContainmentFeature.isPresent()) {
            return this.retrieveCandidates(Artifact.class, container, optionalContainmentFeature.get());
        }
        return List.of();
    }

    public List<? extends Node> getNodeCandidates(Element container) {
        Optional<EReference> optionalContainmentFeature = this.getNodeContainmentFeature(container);
        if (optionalContainmentFeature.isPresent()) {
            return this.retrieveCandidates(Node.class, container, optionalContainmentFeature.get());
        }
        return List.of();
    }

    public List<? extends Package> getPackageCandidates(Element container) {
        if (container instanceof Package) {
            return this.retrieveCandidates(Package.class, container, UMLPackage.eINSTANCE.getPackage_PackagedElement());
        }
        return List.of();
    }

    public boolean canCreateArtifactDD(Element container, EClass type) {
        Optional<EReference> containmentFeature = this.getArtifactContainmentFeature(container);
        if (containmentFeature.isPresent()) {
            return this.commonDiagramServices.canCreate((EObject)container, type, (EStructuralFeature)containmentFeature.get());
        }
        return false;
    }

    public void createArtifactDD(Element container, EClass type, DSemanticDecorator targetView) {
        Optional<EReference> optional0CcontainmentFeature = this.getArtifactContainmentFeature(container);
        if (optional0CcontainmentFeature.isPresent()) {
            this.commonDiagramServices.createElement(container, type.getName(), optional0CcontainmentFeature.get().getName(), targetView);
        }
    }

    public boolean canCreateNodeDD(Element container, EClass type) {
        Optional<EReference> optionalContainmentFeature = this.getNodeContainmentFeature(container);
        if (optionalContainmentFeature.isPresent()) {
            return this.commonDiagramServices.canCreate((EObject)container, type, (EStructuralFeature)optionalContainmentFeature.get());
        }
        return false;
    }

    public void createNodeDD(Element container, EClass type, DSemanticDecorator targetView) {
        Optional<EReference> containmentFeature = this.getNodeContainmentFeature(container);
        if (containmentFeature.isPresent()) {
            this.commonDiagramServices.createElement(container, type.getName(), containmentFeature.get().getName(), targetView);
        }
    }

    private Optional<EReference> getArtifactContainmentFeature(Element container) {
        Optional<Object> reference;
        if (container instanceof Package) {
            Package pkg = (Package)container;
            reference = Optional.of(UMLPackage.eINSTANCE.getPackage_PackagedElement());
        } else if (container instanceof Class) {
            Class clazz = (Class)container;
            reference = Optional.of(UMLPackage.eINSTANCE.getClass_NestedClassifier());
        } else if (container instanceof Artifact) {
            Artifact artifact = (Artifact)container;
            reference = Optional.of(UMLPackage.eINSTANCE.getArtifact_NestedArtifact());
        } else {
            reference = Optional.empty();
        }
        return reference;
    }

    private Optional<EReference> getNodeContainmentFeature(Element container) {
        Optional<EReference> reference;
        if (container instanceof Package) {
            Package pkg = (Package)container;
            reference = Optional.of(UMLPackage.eINSTANCE.getPackage_PackagedElement());
        } else if (container instanceof Node) {
            Node node = (Node)container;
            reference = Optional.of(UMLPackage.eINSTANCE.getNode_NestedNode());
        } else {
            reference = Optional.empty();
        }
        return reference;
    }

    private <T> List<? extends T> retrieveCandidates(java.lang.Class<? extends T> type, Element container, EReference containmentFeature) {
        Stream streamOfCandidates = Optional.ofNullable(container.eGet((EStructuralFeature)containmentFeature)).filter(List.class::isInstance).map(List.class::cast).stream().flatMap(Collection::stream);
        return streamOfCandidates.filter(type::isInstance).map(type::cast).toList();
    }
}

