/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.commands.UnloadDecoratorModelHandler;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.AbstractManageProfileApplicationsWizard;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.DecoratorModelSelectionPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class UnloadProfileApplicationsWizard
extends AbstractManageProfileApplicationsWizard {
    public UnloadProfileApplicationsWizard() {
        super(false);
        this.setWindowTitle(Messages.UnloadProfileApplicationsWizard_0);
    }

    @Override
    protected void configureSelectionPage(DecoratorModelSelectionPage page) {
        page.setMessage(Messages.UnloadProfileApplicationsWizard_1);
    }

    @Override
    Set<URI> getAvailableProfileApplicationResources(Package package_) {
        HashSet result = Sets.newHashSet();
        result.addAll(DecoratorModelUtils.getLoadedDecoratorModels((Resource)package_.eResource()));
        for (Package subUnit : DecoratorModelUtils.getLoadedSubUnitPackages((Package)package_)) {
            result.addAll(DecoratorModelUtils.getLoadedDecoratorModels((Resource)subUnit.eResource()));
        }
        return result;
    }

    @Override
    protected boolean performFinish(ResourceSet resourceSet, Set<URI> resourceURIs) {
        return UnloadProfileApplicationsWizard.unload(resourceSet, resourceURIs);
    }

    static boolean unload(ResourceSet resourceSet, Set<URI> resourceURIs) {
        boolean result = false;
        HashSet toUnload = Sets.newHashSet();
        for (URI uri : resourceURIs) {
            Resource resource = resourceSet.getResource(uri, false);
            if (resource == null || !resource.isLoaded()) continue;
            toUnload.add(resource);
        }
        if (!toUnload.isEmpty()) {
            try {
                UnloadDecoratorModelHandler.unloadResources(Activator.getActiveWorkbenchWindow(), resourceSet, toUnload);
                result = true;
            }
            catch (ExecutionException e) {
                Status status = new Status(4, "org.eclipse.papyrus.uml.decoratormodel.ui", Messages.UnloadProfileApplicationsWizard_2, (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                StatusManager.getManager().handle((IStatus)status, 4);
            }
        }
        return result;
    }
}

