/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.helper;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.commands.CreateHyperLinkObjectCommand;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkSpecificObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.CompositeContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.swt.widgets.Shell;

public class ObjectHyperLinkHelper
extends AbstractHyperLinkHelper {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.hyperlink.specificHyperLinks";

    @Override
    public String getNameofManagedHyperLink() {
        return "Specific object";
    }

    @Override
    public void executeNewMousePressed(Shell parentShell, List<HyperLinkObject> list, EObject aModel) {
        ModelSet modelSet;
        LabelProviderService labelProviderService;
        try {
            ServicesRegistry servicesRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(aModel);
            if (servicesRegistry == null) {
                return;
            }
            labelProviderService = (LabelProviderService)servicesRegistry.getService(LabelProviderService.class);
            modelSet = (ModelSet)servicesRegistry.getService(ModelSet.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return;
        }
        TreeSelectorDialog selectionDialog = new TreeSelectorDialog(parentShell);
        selectionDialog.setBlockOnOpen(true);
        IHierarchicContentProvider semanticProvider = this.getContentProvider();
        EMFGraphicalContentProvider graphicalProvider = new EMFGraphicalContentProvider((IStructuredContentProvider)semanticProvider, (ResourceSet)modelSet, EXTENSION_ID);
        selectionDialog.setContentProvider((ITreeContentProvider)graphicalProvider);
        selectionDialog.setLabelProvider(labelProviderService.getLabelProvider());
        selectionDialog.setInput((Object)aModel);
        selectionDialog.open();
        if (selectionDialog.getReturnCode() == 0) {
            Object[] result;
            Object[] objectArray = result = selectionDialog.getResult();
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object resultElement = objectArray[n2];
                if (resultElement instanceof EObject) {
                    list.add(new HyperLinkSpecificObject((EObject)resultElement));
                }
                ++n2;
            }
        }
    }

    protected IHierarchicContentProvider getContentProvider() {
        IConfigurationElement[] configElements;
        CompositeContentProvider provider = new CompositeContentProvider();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object contentProviderObject = e.createExecutableExtension("contentProvider");
                if (!(contentProviderObject instanceof ITreeContentProvider)) {
                    Activator.log.warn("Plugin " + String.valueOf(e.getContributor()) + " contributed an invalid extension for org.eclipse.papyrus.infra.hyperlink.specificHyperLinks. The content provider must be a ITreeContentProvider");
                } else {
                    ITreeContentProvider contentProvider = (ITreeContentProvider)contentProviderObject;
                    provider.appendContentProvider(contentProvider);
                }
            }
            catch (Exception ex) {
                Activator.log.error("Plugin " + String.valueOf(e.getContributor()) + " contributed an invalid extension for org.eclipse.papyrus.infra.hyperlink.specificHyperLinks", (Throwable)ex);
            }
            ++n2;
        }
        return provider;
    }

    @Override
    public List<HyperLinkObject> getFilteredObject(List<HyperLinkObject> hyperLinkObjects) {
        LinkedList<HyperLinkObject> result = new LinkedList<HyperLinkObject>();
        for (HyperLinkObject object : hyperLinkObjects) {
            if (!(object instanceof HyperLinkSpecificObject)) continue;
            result.add(object);
        }
        return result;
    }

    @Override
    public HyperLinkObject getHyperLinkObject(EAnnotation eAnnotation) {
        if ("PapyrusHyperLink_Object".equals(eAnnotation.getSource()) && !eAnnotation.getReferences().isEmpty()) {
            HyperLinkSpecificObject specificObjectHyperlink = new HyperLinkSpecificObject();
            specificObjectHyperlink.setTargetElement((EObject)eAnnotation.getReferences().get(0));
            specificObjectHyperlink.setIsDefault(Boolean.parseBoolean((String)eAnnotation.getDetails().get((Object)"is_default_navigation")));
            specificObjectHyperlink.setTooltipText((String)eAnnotation.getDetails().get((Object)"tooltip_text"));
            return specificObjectHyperlink;
        }
        return null;
    }

    @Override
    public RecordingCommand getAddHyperLinkCommand(TransactionalEditingDomain domain, EModelElement object, HyperLinkObject hyperLinkObject) {
        if (hyperLinkObject instanceof HyperLinkSpecificObject) {
            HyperLinkSpecificObject hyperLinkSpecificObject = (HyperLinkSpecificObject)hyperLinkObject;
            return new CreateHyperLinkObjectCommand(domain, object, hyperLinkSpecificObject.getTooltipText(), "PapyrusHyperLink_Object", hyperLinkSpecificObject.getTargetElement(), hyperLinkObject.getIsDefault());
        }
        return null;
    }
}

