/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.groups.utils;

import java.util.Comparator;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.common.groups.core.groupcontainment.GroupContainmentRegistry;

public class GraphicalAndModelElementComparator
implements Comparator<IGraphicalEditPart> {
    private Mode mode;
    private Map registery;

    public GraphicalAndModelElementComparator(IGraphicalEditPart anypart) {
        this.mode = Mode.GRAPHICAL_AND_MODEL;
        this.registery = anypart.getViewer().getEditPartRegistry();
    }

    public GraphicalAndModelElementComparator(Mode mode, IGraphicalEditPart anypart) {
        this.mode = mode;
        this.registery = anypart.getViewer().getEditPartRegistry();
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public int compare(IGraphicalEditPart o1, IGraphicalEditPart o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (Mode.GRAPHICAL_AND_MODEL.equals((Object)this.mode)) {
            IGraphicalEditPart o1Graphic = o1;
            IGraphicalEditPart o2Graphic = o2;
            EditPart graphicalParent = o2Graphic.getParent();
            while (graphicalParent != null) {
                if (graphicalParent.equals(o1Graphic)) {
                    return -1;
                }
                graphicalParent = graphicalParent.getParent();
            }
            graphicalParent = o1Graphic.getParent();
            while (graphicalParent != null) {
                if (graphicalParent == o2Graphic) {
                    return 1;
                }
                graphicalParent = graphicalParent.getParent();
            }
        }
        EObject o1model = o1.resolveSemanticElement();
        EObject o2model = o2.resolveSemanticElement();
        return this.compare(o1model, o2model);
    }

    @Override
    public int compare(EObject o1model, EObject o2model) {
        EObject modelParent = o2model.eContainer();
        IGraphicalEditPart modelParentEditPart = (IGraphicalEditPart)this.registery.get(modelParent);
        while (modelParent != null || GroupContainmentRegistry.isContainerConcerned(modelParentEditPart)) {
            if (modelParent == o1model) {
                return -1;
            }
            modelParent = modelParent.eContainer();
            modelParentEditPart = (IGraphicalEditPart)this.registery.get(modelParent);
        }
        modelParent = o2model.eContainer();
        modelParentEditPart = (IGraphicalEditPart)this.registery.get(modelParent);
        while (modelParent != null) {
            if (modelParent == o2model || GroupContainmentRegistry.isContainerConcerned(modelParentEditPart)) {
                return -1;
            }
            modelParent = modelParent.eContainer();
            modelParentEditPart = (IGraphicalEditPart)this.registery.get(modelParent);
        }
        return 0;
    }

    public static enum Mode {
        MODEL,
        GRAPHICAL_AND_MODEL;

    }
}

