/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class AbstractLookForEditorShell
extends TrayDialog {
    private TabFolder tabFolder = null;
    private Composite diagramListcomposite = null;
    private Composite treeViewcomposite = null;
    private Composite afterTreeViewComposite = null;
    private final Tree modeltree = null;
    private Button newDiagrambutton = null;
    private Button removeDiagrambutton = null;
    private final Tree diagramListtree = null;
    private FilteredTree diagramfilteredTree = null;
    private FilteredTree modeFilteredTree = null;
    private CLabel cLabel = null;

    public AbstractLookForEditorShell(Shell parentShell) {
        super(parentShell);
    }

    public AbstractLookForEditorShell(IShellProvider parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.tabFolder = new TabFolder(parent, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        AbstractLookForEditorShell.applyDialogFont((Control)this.tabFolder);
        this.createDiagramListcomposite();
        this.createTreeViewcomposite();
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setControl((Control)this.diagramListcomposite);
        tabItem.setText(Messages.AbstractLookForEditorShell_EditorsList);
        TabItem tabItem1 = new TabItem(this.tabFolder, 0);
        tabItem1.setText(Messages.AbstractLookForEditorShell_TreeView);
        tabItem1.setControl((Control)this.treeViewcomposite);
        this.contentsCreated();
        return this.tabFolder;
    }

    protected void contentsCreated() {
    }

    private void createDiagramListcomposite() {
        GridLayout gridLayout2 = new GridLayout();
        this.diagramListcomposite = new Composite((Composite)this.tabFolder, 2048);
        this.createDiagramfilteredTree();
        this.diagramListcomposite.setLayout((Layout)gridLayout2);
    }

    private void createTreeViewcomposite() {
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridData gridData5 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.treeViewcomposite = new Composite((Composite)this.tabFolder, 0);
        this.createModelFilteredTree();
        this.treeViewcomposite.setLayout((Layout)gridLayout);
        this.newDiagrambutton = new Button(this.treeViewcomposite, 0);
        this.newDiagrambutton.setText(Messages.AbstractLookForEditorShell_New);
        this.newDiagrambutton.setLayoutData((Object)gridData4);
        this.removeDiagrambutton = new Button(this.treeViewcomposite, 0);
        this.removeDiagrambutton.setText(Messages.AbstractLookForEditorShell_Remove);
        this.removeDiagrambutton.setLayoutData((Object)gridData5);
        this.cLabel = new CLabel(this.treeViewcomposite, 0);
        this.cLabel.setText("   ");
        this.afterTreeViewComposite = new Composite(this.treeViewcomposite, 0);
        this.afterTreeViewComposite.setLayout((Layout)new FillLayout());
        this.afterTreeViewComposite.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected Tree getModeltree() {
        return this.modeltree;
    }

    protected Button getNewDiagrambutton() {
        return this.newDiagrambutton;
    }

    protected void setNewDiagrambutton(Button newDiagrambutton) {
        this.newDiagrambutton = newDiagrambutton;
    }

    protected Button getRemoveDiagrambutton() {
        return this.removeDiagrambutton;
    }

    protected void setRemoveDiagrambutton(Button removeDiagrambutton) {
        this.removeDiagrambutton = removeDiagrambutton;
    }

    protected Tree getDiagramListtree() {
        return this.diagramListtree;
    }

    private void createDiagramfilteredTree() {
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.grabExcessVerticalSpace = true;
        gridData6.verticalAlignment = 4;
        this.diagramfilteredTree = new FilteredTree(this.diagramListcomposite, 2048, new PatternFilter(), true);
        this.diagramfilteredTree.setLayoutData((Object)gridData6);
    }

    private void createModelFilteredTree() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.grabExcessVerticalSpace = true;
        gridData3.verticalSpan = 3;
        gridData3.verticalAlignment = 4;
        this.modeFilteredTree = new FilteredTree(this.treeViewcomposite, 2048, new PatternFilter(), true);
        this.modeFilteredTree.setLayoutData((Object)gridData3);
    }

    protected FilteredTree getDiagramfilteredTree() {
        return this.diagramfilteredTree;
    }

    protected FilteredTree getModeFilteredTree() {
        return this.modeFilteredTree;
    }

    protected Composite getAfterTreeViewComposite() {
        return this.afterTreeViewComposite;
    }
}

