/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.editor.properties.advanced.controls.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.dialect.description.ToolInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.internal.SiriusToolServices;
import org.eclipse.sirius.properties.core.internal.expressions.DomainClassSwitch;
import org.eclipse.sirius.properties.core.internal.expressions.VSMNavigation;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Extension;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;

public final class ExtEditableReferenceInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    private Collection<EPackage> packagesToImport;

    public ExtEditableReferenceInterpretedExpressionQuery(EObject target, EStructuralFeature expressionAttribute) {
        super(target, expressionAttribute);
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new PropertiesExpressionsGlobalTargetSwitch(this.feature);
    }

    public Collection<EPackage> getPackagesToImport() {
        if (this.packagesToImport == null) {
            this.packagesToImport = ExtEditableReferenceInterpretedExpressionQuery.getEPackagesInScope(this.target);
        }
        return this.packagesToImport;
    }

    public Collection<String> getDependencies() {
        if (this.dependencies == null) {
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(VSMNavigation.getJavaExtensionsInVSM((EObject)this.target));
            result.add(SiriusToolServices.class.getName());
            this.dependencies = result;
        }
        return this.dependencies;
    }

    private static Collection<EPackage> getEPackagesInScope(EObject target) {
        Option viewDescriptionOpt;
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        boolean needsGlobalPackages = false;
        for (RepresentationDescription desc : VSMNavigation.getRepresentationDescriptionsInVSM((EObject)target)) {
            EList configured = desc.getMetamodel();
            result.addAll((Collection<EPackage>)configured);
            if (!configured.isEmpty()) continue;
            needsGlobalPackages = true;
        }
        if (needsGlobalPackages) {
            result.addAll(ExtEditableReferenceInterpretedExpressionQuery.getAllRegisteredEPackages(EPackage.Registry.INSTANCE));
        }
        if ((viewDescriptionOpt = new EObjectQuery(target).getFirstAncestorOfType(PropertiesPackage.Literals.VIEW_EXTENSION_DESCRIPTION)).some()) {
            ViewExtensionDescription ved = (ViewExtensionDescription)viewDescriptionOpt.get();
            result.addAll((Collection<EPackage>)ved.getMetamodels());
        }
        result.add((EPackage)EcorePackage.eINSTANCE);
        result.add((EPackage)ViewpointPackage.eINSTANCE);
        result.add((EPackage)DescriptionPackage.eINSTANCE);
        result.add((EPackage)ToolPackage.eINSTANCE);
        result.add((EPackage)ValidationPackage.eINSTANCE);
        result.add((EPackage)PropertiesPackage.eINSTANCE);
        return result;
    }

    private static Collection<EPackage> getAllRegisteredEPackages(EPackage.Registry source) {
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        LinkedHashSet nsURIs = new LinkedHashSet();
        nsURIs.addAll(source.keySet());
        for (String nsURI : nsURIs) {
            try {
                EPackage ePackage = source.getEPackage(nsURI);
                if (ePackage == null) continue;
                result.add(ePackage);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public Map<String, VariableType> getAvailableVariables() {
        if (this.availableVariables == null) {
            this.availableVariables = new LinkedHashMap();
        }
        this.availableVariables.put("input", VariableType.fromJavaClass(SiriusInputDescriptor.class));
        this.availableVariables.put("selection", VariableType.ANY_EOBJECT);
        this.availableVariables.put("newElementTypeName", VariableType.fromJavaClass(String.class));
        this.availableVariables.put("newElementContainer", VariableType.ANY_EOBJECT);
        this.availableVariables.put("newElementContainerFeatureName", VariableType.fromJavaClass(String.class));
        return this.availableVariables;
    }

    private static class PropertiesExpressionsGlobalTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private final DomainClassSwitch propertiesSwitch;
        private final ToolInterpretedExpressionTargetSwitch delegateSwitch;

        PropertiesExpressionsGlobalTargetSwitch(EStructuralFeature feature) {
            this.propertiesSwitch = new DomainClassSwitch(feature);
            this.delegateSwitch = new CustomToolInterpretedExpressionTargetSwitch(feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = new LinkedHashSet();
            Option expressionTarget = Options.newSome(targetTypes);
            if (target != null) {
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.propertiesSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.propertiesSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.delegateSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.delegateSwitch.doSwitch(target);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            if (obj != null) {
                EObject container = obj.eContainer();
                while (container != null && !this.isRelevant(container)) {
                    container = container.eContainer();
                }
                return container;
            }
            return null;
        }

        private boolean isRelevant(EObject container) {
            return container instanceof PageDescription || container instanceof GroupDescription;
        }

        private static class CustomToolInterpretedExpressionTargetSwitch
        extends ToolInterpretedExpressionTargetSwitch {
            CustomToolInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultSwitch) {
                super(feature, defaultSwitch);
            }

            protected EObject getFirstContextChangingContainer(EObject element) {
                EObject defaultResult = super.getFirstContextChangingContainer(element);
                if (defaultResult instanceof Extension) {
                    return VSMNavigation.findClosestGroupDescription((EObject)element);
                }
                return defaultResult;
            }
        }
    }
}

