/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.provider;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderFullCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;

public class AxisIdentifierLabelProvider
extends LabelProvider {
    private static LabelProviderFullCellContextElementWrapper wrapper = null;
    protected final INattableModelManager tableManager;

    public AxisIdentifierLabelProvider(INattableModelManager tableManager) {
        this.tableManager = tableManager;
    }

    public String getText(Object element) {
        String returnedValue = null;
        ServicesRegistry serviceRegistry = null;
        LabelProviderService serv = null;
        try {
            serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.tableManager.getTable().getContext());
            serv = (LabelProviderService)serviceRegistry.getService(LabelProviderService.class);
        }
        catch (ServiceException e) {
            Activator.log.error("Cannot get service registry", (Throwable)e);
        }
        if (serv != null) {
            ConfigRegistry configRegistry = new ConfigRegistry();
            configRegistry.registerConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, (Object)serv, DisplayMode.NORMAL, "label_provider_service_id");
            configRegistry.registerConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, (Object)this.tableManager, DisplayMode.NORMAL, "nattable_model_manager_id");
            wrapper = new LabelProviderFullCellContextElementWrapper();
            wrapper.setDataValue(element);
            wrapper.setConfigRegistry((IConfigRegistry)configRegistry);
            wrapper.setConfigLabels(new LabelStack(new String[]{"COLUMN_HEADER"}));
            ILabelProvider labelProvider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider", (Object)wrapper);
            if (labelProvider != null) {
                returnedValue = labelProvider.getText((Object)wrapper);
            } else {
                labelProvider = serv.getLabelProvider((Object)wrapper);
                if (labelProvider != null) {
                    returnedValue = labelProvider.getText((Object)wrapper);
                }
            }
            wrapper = null;
        }
        return returnedValue;
    }

    public Image getImage(Object element) {
        Image returnImage = null;
        ServicesRegistry serviceRegistry = null;
        LabelProviderService serv = null;
        try {
            serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.tableManager.getTable().getContext());
            serv = (LabelProviderService)serviceRegistry.getService(LabelProviderService.class);
        }
        catch (ServiceException e) {
            Activator.log.error("Cannot get service registry", (Throwable)e);
        }
        if (serv != null) {
            ConfigRegistry configRegistry = new ConfigRegistry();
            configRegistry.registerConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, (Object)serv, DisplayMode.NORMAL, "label_provider_service_id");
            configRegistry.registerConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, (Object)this.tableManager, DisplayMode.NORMAL, "nattable_model_manager_id");
            wrapper = new LabelProviderFullCellContextElementWrapper();
            wrapper.setDataValue(element);
            wrapper.setConfigRegistry((IConfigRegistry)configRegistry);
            wrapper.setConfigLabels(new LabelStack(new String[]{"COLUMN_HEADER"}));
            ILabelProvider labelProvider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider", (Object)wrapper);
            if (labelProvider != null) {
                returnImage = labelProvider.getImage((Object)wrapper);
            } else {
                labelProvider = serv.getLabelProvider((Object)wrapper);
                if (labelProvider != null) {
                    returnImage = labelProvider.getImage((Object)wrapper);
                }
            }
            wrapper = null;
        }
        return returnImage;
    }
}

