/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureFramework;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.ui.architecture.providers.MergedArchitectureDescriptionLanguageItemProvider;
import org.eclipse.papyrus.infra.ui.architecture.providers.MergedArchitectureDomainItemProvider;
import org.eclipse.papyrus.infra.ui.architecture.providers.MergedArchitectureFrameworkItemProvider;
import org.eclipse.papyrus.infra.ui.architecture.providers.MergedArchitectureItemProvider;
import org.eclipse.papyrus.infra.ui.architecture.providers.MergedArchitectureViewpointItemProvider;

public class MergedArchitectureItemProviderAdapterFactory
extends AdapterFactoryImpl
implements ComposeableAdapterFactory,
IDisposable {
    private final Set<?> supportedTypes = Set.of(IItemLabelProvider.class, IItemStyledLabelProvider.class, IItemPropertySource.class, IStructuredItemContentProvider.class, ITreeItemContentProvider.class, MergedADElement.class.getPackage());
    private final Map<MergedADElement, MergedArchitectureItemProvider> providers = new HashMap<MergedADElement, MergedArchitectureItemProvider>();
    private ComposedAdapterFactory parent;

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    protected Adapter createAdapter(Notifier target) {
        if (target instanceof MergedArchitectureDomain) {
            return this.createDomainItemProvider((MergedArchitectureDomain)target);
        }
        if (target instanceof MergedArchitectureDescriptionLanguage) {
            return this.createDescriptionLanguageItemProvider((MergedArchitectureDescriptionLanguage)target);
        }
        if (target instanceof MergedArchitectureFramework) {
            return this.createFrameworkItemProvider((MergedArchitectureFramework)target);
        }
        if (target instanceof MergedArchitectureViewpoint) {
            return this.createViewpointItemProvider((MergedArchitectureViewpoint)target);
        }
        return null;
    }

    protected MergedArchitectureItemProvider createDomainItemProvider(MergedArchitectureDomain target) {
        return this.providers.computeIfAbsent((MergedADElement)target, __ -> new MergedArchitectureDomainItemProvider((AdapterFactory)this, target));
    }

    protected MergedArchitectureItemProvider createDescriptionLanguageItemProvider(MergedArchitectureDescriptionLanguage target) {
        return this.providers.computeIfAbsent((MergedADElement)target, __ -> new MergedArchitectureDescriptionLanguageItemProvider((AdapterFactory)this, target));
    }

    protected MergedArchitectureItemProvider createFrameworkItemProvider(MergedArchitectureFramework target) {
        return this.providers.computeIfAbsent((MergedADElement)target, __ -> new MergedArchitectureFrameworkItemProvider((AdapterFactory)this, target));
    }

    protected MergedArchitectureItemProvider createViewpointItemProvider(MergedArchitectureViewpoint target) {
        return this.providers.computeIfAbsent((MergedADElement)target, __ -> new MergedArchitectureViewpointItemProvider((AdapterFactory)this, target));
    }

    public void dispose() {
        this.providers.values().forEach(IDisposable::dispose);
        this.providers.clear();
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parent == null ? null : this.parent.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parent = parentAdapterFactory;
    }
}

