/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class PropertyUtil {
    public static List<Property> getSubsettablesProperties(Property property, boolean noCheck) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (NamedElement element : property.getClass_().getMembers()) {
            if (!(element instanceof Property)) continue;
            boolean isValid = true;
            Property subsettableProperty = (Property)element;
            if (subsettableProperty.equals(property)) {
                isValid = false;
            }
            if (!noCheck) {
                if (property.getType() != null && subsettableProperty.getType() != null) {
                    if (!property.getType().conformsTo(subsettableProperty.getType())) {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
                if (subsettableProperty.getUpper() != -1 && property.getUpper() > subsettableProperty.getUpper()) {
                    isValid = false;
                }
            }
            if (!isValid) continue;
            list.add(subsettableProperty);
        }
        return list;
    }

    public static Property findSusbsettedPropertyByName(String propertyName, Property property, boolean noCheck) {
        for (Property tmpProperty : PropertyUtil.getSubsettablesProperties(property, true)) {
            String tmpPropertyName = tmpProperty.getName();
            if (tmpPropertyName == null || !propertyName.equals(tmpPropertyName.trim())) continue;
            return tmpProperty;
        }
        return null;
    }

    public static List<Property> getRedefinableProperties(Property property) {
        ArrayList<Property> list = new ArrayList<Property>();
        for (NamedElement element : property.getClass_().getInheritedMembers()) {
            if (!(element instanceof Property)) continue;
            list.add((Property)element);
        }
        for (Property element : property.getRedefinedProperties()) {
            list.add(element);
        }
        return list;
    }

    public static Property findRedefinedPropertyByName(String propertyName, Property property) {
        for (Property tmpProperty : PropertyUtil.getRedefinableProperties(property)) {
            String tmpPropertyName = tmpProperty.getName();
            if (tmpPropertyName == null || !propertyName.equals(tmpPropertyName.trim())) continue;
            return tmpProperty;
        }
        return null;
    }

    public static String getDerived(Property property) {
        return property.isDerived() ? "/" : "";
    }

    public static String getLabel(Property property) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        buffer.append(PropertyUtil.getNonNullString(NamedElementUtil.getVisibilityAsSign((NamedElement)property)));
        buffer.append(PropertyUtil.getNonNullString(PropertyUtil.getDerived(property)));
        buffer.append(" ");
        buffer.append(PropertyUtil.getNonNullString(PropertyUtil.getName(property)));
        if (property.getType() != null) {
            buffer.append(" : " + PropertyUtil.getNonNullString(UMLLabelInternationalization.getInstance().getLabel((NamedElement)property.getType())));
        } else {
            buffer.append(" : <Undefined>");
        }
        String multiplicity = MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property);
        if (!multiplicity.trim().equals("[1]")) {
            buffer.append(PropertyUtil.getNonNullString(multiplicity));
        }
        if (property.getDefaultValue() != null) {
            buffer.append(" = ");
            buffer.append(PropertyUtil.getNonNullString(ValueSpecificationUtil.getSpecificationValue(property.getDefaultValue())));
        }
        buffer.append(PropertyUtil.getNonNullString(PropertyUtil.getModifiersAsString(property, false)));
        return buffer.toString();
    }

    public static String getName(Property property) {
        if (property.getName() != null) {
            return UMLLabelInternationalization.getInstance().getLabel((NamedElement)property);
        }
        return NamedElementUtil.getDefaultNameWithIncrement((EObject)property);
    }

    private static String getNonNullString(String source) {
        return source == null ? "" : source;
    }

    public static String getCustomLabel(Property property, Collection<String> style) {
        boolean multiLine;
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (style.contains("visibility")) {
            buffer.append(PropertyUtil.getNonNullString(NamedElementUtil.getVisibilityAsSign((NamedElement)property)));
        }
        if (style.contains("derived") && property.isDerived()) {
            buffer.append("/");
        }
        if (style.contains("name")) {
            buffer.append(" ");
            buffer.append(PropertyUtil.getNonNullString(UMLLabelInternationalization.getInstance().getLabel((NamedElement)property)));
        }
        if (style.contains("type")) {
            if (property.getType() != null) {
                buffer.append(": " + PropertyUtil.getNonNullString(UMLLabelInternationalization.getInstance().getLabel((NamedElement)property.getType())));
            } else {
                buffer.append(": <Undefined>");
            }
        }
        if (style.contains("multiplicity")) {
            multiplicity = PropertyUtil.getNonNullString(MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)property));
            buffer.append(multiplicity);
        } else if (style.contains("multiplicityNoBrackets")) {
            multiplicity = PropertyUtil.getNonNullString(MultiplicityElementUtil.formatMultiplicityNoBrackets((MultiplicityElement)property));
            buffer.append(multiplicity);
        }
        if (style.contains("defaultValue") && property.getDefaultValue() != null) {
            buffer.append(" = ");
            buffer.append(PropertyUtil.getNonNullString(ValueSpecificationUtil.getSpecificationValue(property.getDefaultValue(), true)));
        }
        if (style.contains("modifiers") && !(modifiers = PropertyUtil.getNonNullString(PropertyUtil.getModifiersAsString(property, multiLine = style.contains("multiline")))).equals("")) {
            if (multiLine) {
                buffer.append("\n");
            }
            if (!buffer.toString().endsWith(" ")) {
                buffer.append(" ");
            }
            buffer.append(modifiers);
        }
        return buffer.toString();
    }

    public static String getModifiersAsString(Property property, boolean multiLine) {
        String NL;
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        String string = NL = multiLine ? "\n" : " ";
        if (property.isReadOnly()) {
            buffer.append("readOnly");
            needsComma = true;
        }
        if (property.isDerivedUnion()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "union");
        }
        if (property.isOrdered()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "ordered");
        }
        if (property.isUnique()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "unique");
        }
        for (Property current : property.getRedefinedProperties()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "redefines ");
            buffer.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)current));
        }
        for (Property current : property.getSubsettedProperties()) {
            needsComma = PropertyUtil.updateModifiersString(buffer, needsComma, NL, "subsets ");
            buffer.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)current));
        }
        if (!buffer.toString().equals("")) {
            buffer.insert(0, "{");
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static boolean updateModifiersString(StringBuffer buffer, boolean needsComma, String NL, String message) {
        if (needsComma) {
            buffer.append(",");
            buffer.append(NL);
        }
        buffer.append(message);
        return true;
    }
}

