/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.extension;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.HTMLExportHelper;
import org.eclipse.papyrus.uml.export.extension.AdditionalInformations;
import org.eclipse.papyrus.uml.export.extension.AnnotateSVG;

public class HTMLExtensionRegistry {
    private static final String ORG_ECLIPSE_PAPYRUS_EXPORT_HTML_GENERATE = "org.eclipse.papyrus.uml.export.generation";
    private static final String ANNOTATION = "annotation";
    private static final String ADDITIONNAL_INFO = "additionnalInformation";
    private static final String DATA = "data";
    private static final String KEY = "key";
    private static final String HTML = "html";
    private static final String HEADER = "header";
    private static final String TXT = "text";
    private static final String COPYFILE = "copyFile";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static HTMLExtensionRegistry instance;

    private HTMLExtensionRegistry() {
    }

    public static HTMLExtensionRegistry getInstance() {
        if (instance == null) {
            instance = new HTMLExtensionRegistry();
        }
        return instance;
    }

    public List<IExtension> getAllExtension() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] extensions = registry.getExtensionPoint(ORG_ECLIPSE_PAPYRUS_EXPORT_HTML_GENERATE).getExtensions();
        return Arrays.asList(extensions);
    }

    public static HTMLExportHelper getHelperFromPrefs(List<String> activatePref) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(ORG_ECLIPSE_PAPYRUS_EXPORT_HTML_GENERATE);
        IExtension[] extensions = extensionPoint.getExtensions();
        HTMLExportHelper helper = new HTMLExportHelper();
        int i = 0;
        while (i < extensions.length) {
            String simpleIdentifier = extensions[i].getUniqueIdentifier();
            if (activatePref.contains(simpleIdentifier)) {
                IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    HTMLExtensionRegistry.readExtension(configurationElements[j], helper);
                    ++j;
                }
            }
            ++i;
        }
        return helper;
    }

    private static void readExtension(IConfigurationElement configurationElementsFor, HTMLExportHelper helper) {
        String name = configurationElementsFor.getName();
        try {
            String attribute;
            if (ANNOTATION.equals(name)) {
                AnnotateSVG createExecutableExtension = (AnnotateSVG)configurationElementsFor.createExecutableExtension(ANNOTATION);
                helper.getAnnotations().add(createExecutableExtension);
            }
            if (ADDITIONNAL_INFO.equals(name)) {
                AdditionalInformations createExecutableExtensionAdditionalInformations = (AdditionalInformations)configurationElementsFor.createExecutableExtension(DATA);
                attribute = configurationElementsFor.getAttribute(KEY);
                helper.getAdditionnalDatas().put(attribute, createExecutableExtensionAdditionalInformations);
            }
            if (HTML.equals(name)) {
                String headerD = configurationElementsFor.getAttribute(HEADER);
                attribute = configurationElementsFor.getAttribute(TXT);
                if (Boolean.parseBoolean(headerD)) {
                    helper.getHeaders().add(attribute);
                } else {
                    helper.getFooters().add(attribute);
                }
            }
            if (COPYFILE.equals(name)) {
                String from = configurationElementsFor.getAttribute(FROM);
                String to = configurationElementsFor.getAttribute(TO);
                helper.getFromTO().put(from, to);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }
}

