/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EndKind implements Enumerator
{
    ALL(0, "all", "all"),
    SOURCE(1, "source", "source"),
    TARGET(2, "target", "target");

    public static final int ALL_VALUE = 0;
    public static final int SOURCE_VALUE = 1;
    public static final int TARGET_VALUE = 2;
    private static final EndKind[] VALUES_ARRAY;
    public static final List<EndKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EndKind[]{ALL, SOURCE, TARGET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EndKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EndKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EndKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EndKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EndKind get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return SOURCE;
            }
            case 2: {
                return TARGET;
            }
        }
        return null;
    }

    private EndKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

