/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.ProfileUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeApplicationRegistry {
    public static List<StereotypeApplicationDescriptor> stereotypeApplicationList;
    private static Package model;

    public StereotypeApplicationRegistry(TreeNode treeNode, Package profiledModel) {
        this.initList(treeNode, profiledModel);
        model = profiledModel;
    }

    public static List<StereotypeApplicationDescriptor> getStereotypeApplicationDescriptors(Stereotype stereotype) {
        ArrayList<StereotypeApplicationDescriptor> result = new ArrayList<StereotypeApplicationDescriptor>();
        for (StereotypeApplicationDescriptor descriptor : stereotypeApplicationList) {
            if (!descriptor.getStereotype().equals(stereotype)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static List<StereotypeApplicationDescriptor> getAllStereotypeApplicationDescriptors(Stereotype stereotype) {
        ArrayList<StereotypeApplicationDescriptor> result = new ArrayList<StereotypeApplicationDescriptor>();
        for (StereotypeApplicationDescriptor descriptor : stereotypeApplicationList) {
            for (Stereotype subStereotype : ProfileUtil.findAllSubStereotypes(stereotype, model, false)) {
                if (!descriptor.getStereotype().equals(subStereotype)) continue;
                result.add(descriptor);
            }
        }
        return result;
    }

    public static List<StereotypeApplicationDescriptor> getAllStereotypeApplicationDescriptorsFromOwner(Element element) {
        ArrayList<StereotypeApplicationDescriptor> result = new ArrayList<StereotypeApplicationDescriptor>();
        for (StereotypeApplicationDescriptor descriptor : stereotypeApplicationList) {
            if (!descriptor.getOwner().equals(element)) continue;
            result.add(descriptor);
        }
        return result;
    }

    public static StereotypeApplicationDescriptor getStereotypeApplicationDescriptors(Element owner, Stereotype stereotype) {
        StereotypeApplicationDescriptor result = null;
        for (StereotypeApplicationDescriptor descriptor : stereotypeApplicationList) {
            if (!descriptor.getOwner().equals(owner) || !descriptor.getStereotype().equals(stereotype)) continue;
            result = descriptor;
        }
        return result;
    }

    private void initList(TreeNode treeNode, Package profiledModel) {
        HashSet<Stereotype> treeNodeStereotypes = new HashSet<Stereotype>();
        this.getStereotypes(treeNode, treeNodeStereotypes);
        stereotypeApplicationList = new ArrayList<StereotypeApplicationDescriptor>();
        TreeIterator iter = profiledModel.eAllContents();
        while (iter.hasNext()) {
            EObject object = (EObject)iter.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            for (Stereotype stereotype : element.getAppliedStereotypes()) {
                stereotypeApplicationList.add(new StereotypeApplicationDescriptor(stereotype, element));
            }
        }
    }

    private void getStereotypes(TreeNode treeNode, Set<Stereotype> result) {
        if (treeNode.getData() instanceof Match) {
            if (((Match)treeNode.getData()).getRight() instanceof EAnnotation) {
                return;
            }
            if (((Match)treeNode.getData()).getLeft() instanceof Stereotype) {
                result.add((Stereotype)((Match)treeNode.getData()).getLeft());
            } else if (((Match)treeNode.getData()).getRight() instanceof Stereotype) {
                result.add((Stereotype)((Match)treeNode.getData()).getRight());
            }
        }
        for (TreeNode child : treeNode.getChildren()) {
            this.getStereotypes(child, result);
        }
    }
}

