/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.InsertDiagramCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;

public class DiagramPasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    @Deprecated
    protected static final String DIAGRAM_WITH_NO_OWNER = "DIAGRAM_WITH_NO_OWNER";
    protected static final String DIAGRAM_WITH_NO_SEMANTIC_CONTEXT = "DIAGRAM_WITH_NO_SEMANTIC_CONTEXT";
    private static IPasteStrategy instance = new DiagramPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    @Override
    public String getLabel() {
        return "Diagram Strategy";
    }

    @Override
    public String getID() {
        return "org.eclipse.papyrus.infra.gmfdiag.common.DiagramStrategy";
    }

    @Override
    public String getDescription() {
        return "Copy Diagrams in model explorer";
    }

    @Override
    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand("Copy all Diagrams");
        Map internalClipboardToTargetCopy = papyrusClipboard.getInternalClipboardToTargetCopy();
        Map additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID());
        if (additionalDataMap != null) {
            Object additionalData = additionalDataMap.get(DIAGRAM_WITH_NO_SEMANTIC_CONTEXT);
            if (additionalData instanceof DiagramClipboardAdditionalData) {
                DiagramClipboardAdditionalData diagramClipboardAdditionnalData = (DiagramClipboardAdditionalData)additionalData;
                Map<Diagram, Diagram> maps = diagramClipboardAdditionnalData.getDuplicatedDiagramsMap(internalClipboardToTargetCopy);
                for (Map.Entry<Diagram, Diagram> currentEntry : maps.entrySet()) {
                    Diagram copiedDiagram = currentEntry.getValue();
                    EObject diagramSemanticContext = currentEntry.getKey().getElement();
                    InsertDiagramCommand command = new InsertDiagramCommand((TransactionalEditingDomain)domain, "InsertDiagramCommand", copiedDiagram, diagramSemanticContext, targetOwner);
                    compoundCommand.append((Command)command);
                }
            }
            for (Object object : papyrusClipboard) {
                EObject diagramSemanticContext = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                if (diagramSemanticContext == null || !(diagramSemanticContext instanceof EObject) || !((additionalData = additionalDataMap.get(object)) instanceof DiagramClipboardAdditionalData)) continue;
                DiagramClipboardAdditionalData diagramClipboardAdditionnalData = (DiagramClipboardAdditionalData)additionalData;
                Map<Diagram, Diagram> maps = diagramClipboardAdditionnalData.getDuplicatedDiagramsMap(internalClipboardToTargetCopy);
                for (Map.Entry<Diagram, Diagram> currentEntry : maps.entrySet()) {
                    Diagram sourceDiagram = currentEntry.getKey();
                    EObject sourceSemanticContext = sourceDiagram.getElement();
                    EObject sourceGraphicalContext = DiagramUtils.getOwner(sourceDiagram);
                    EObject intermediateSourceSemanticContextCopy = (EObject)papyrusClipboard.getSourceToInternalClipboard().get(sourceSemanticContext);
                    EObject intermediateSourceGraphicalContextCopy = (EObject)papyrusClipboard.getSourceToInternalClipboard().get(sourceGraphicalContext);
                    EObject targetSemanticContextCopy = (EObject)internalClipboardToTargetCopy.get(intermediateSourceSemanticContextCopy);
                    EObject targetGraphicalContextCopy = (EObject)internalClipboardToTargetCopy.get(intermediateSourceGraphicalContextCopy);
                    EObject newSemanticContext = targetSemanticContextCopy != null ? targetSemanticContextCopy : sourceSemanticContext;
                    EObject newTargetContext = targetGraphicalContextCopy != null ? targetGraphicalContextCopy : sourceGraphicalContext;
                    Diagram copiedDiagram = currentEntry.getValue();
                    InsertDiagramCommand command = new InsertDiagramCommand((TransactionalEditingDomain)domain, "InsertDiagramCommand", copiedDiagram, newSemanticContext, newTargetContext);
                    compoundCommand.append((Command)command);
                }
            }
        }
        if (compoundCommand.getCommandList().isEmpty()) {
            return null;
        }
        return compoundCommand;
    }

    @Override
    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    @Override
    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        HashMap<Object, DiagramClipboardAdditionalData> mapCopyToClipboardAdditionalData = new HashMap<Object, DiagramClipboardAdditionalData>();
        Map sourceToInternalClipboard = papyrusClipboard.getSourceToInternalClipboard();
        List<Diagram> extractSelectedWithoutElement = this.extractDiagramWithoutSemanticContext(selection);
        if (extractSelectedWithoutElement != null && extractSelectedWithoutElement.size() > 0) {
            DiagramClipboardAdditionalData diagramAdditionnalData = new DiagramClipboardAdditionalData(extractSelectedWithoutElement, sourceToInternalClipboard);
            mapCopyToClipboardAdditionalData.put(DIAGRAM_WITH_NO_SEMANTIC_CONTEXT, diagramAdditionnalData);
        }
        ArrayList<Diagram> alreadyManagedDiagrams = new ArrayList<Diagram>();
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            EObject eObjectSource = (EObject)iterator.next();
            ResourceSet resourceSet = eObjectSource.eResource().getResourceSet();
            Collection<Diagram> associatedDiagrams = DiagramPasteStrategy.getAssociatedDiagrams(eObjectSource, resourceSet);
            associatedDiagrams.removeAll(alreadyManagedDiagrams);
            alreadyManagedDiagrams.addAll(associatedDiagrams);
            if (associatedDiagrams == null || associatedDiagrams.size() <= 0) continue;
            DiagramClipboardAdditionalData diagramAdditionnalData = new DiagramClipboardAdditionalData(associatedDiagrams, sourceToInternalClipboard);
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToClipboardAdditionalData.put(copy, diagramAdditionnalData);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToClipboardAdditionalData);
    }

    public static Collection<Diagram> getAssociatedDiagrams(EObject eobject, ResourceSet resourceSet) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        diagrams.addAll(DiagramPasteStrategy.getDiagramsAssociatedBySemanticContext(eobject, resourceSet));
        diagrams.addAll(DiagramPasteStrategy.getDiagramsAssociatedByGraphicalContext(eobject, resourceSet));
        return diagrams;
    }

    public static List<Diagram> getDiagramsAssociatedBySemanticContext(EObject element, ResourceSet resourceSet) {
        return DiagramUtils.getAssociatedDiagrams(element, resourceSet);
    }

    public static List<Diagram> getDiagramsAssociatedByGraphicalContext(EObject element, ResourceSet resourceSet) {
        if (resourceSet == null && element != null && element.eResource() != null) {
            resourceSet = element.eResource().getResourceSet();
        }
        if (resourceSet instanceof ModelSet) {
            Resource notationResource = NotationUtils.getNotationResource((ModelSet)resourceSet);
            return DiagramPasteStrategy.getAssociatedDiagramsByByGraphicalContextFromNotationResource(element, notationResource);
        }
        return DiagramUtils.getAssociatedDiagrams(element, resourceSet);
    }

    public static List<Diagram> getAssociatedDiagramsByByGraphicalContextFromNotationResource(EObject element, Resource notationResource) {
        if (notationResource != null) {
            LinkedList<Diagram> diagrams = new LinkedList<Diagram>();
            for (EObject eObj : notationResource.getContents()) {
                Diagram diagram;
                if (!(eObj instanceof Diagram) || !element.equals(DiagramUtils.getOwner(diagram = (Diagram)eObj))) continue;
                diagrams.add(diagram);
            }
            return diagrams;
        }
        return Collections.emptyList();
    }

    protected List<Diagram> extractDiagramWithoutSemanticContext(Collection<EObject> selection) {
        ArrayList<Diagram> diagramWithoutSemanticContenxtOwnerInSelection = new ArrayList<Diagram>();
        if (selection != null) {
            for (EObject eObject : selection) {
                Diagram diagram;
                EObject element;
                if (!(eObject instanceof Diagram) || selection.contains(element = (diagram = (Diagram)eObject).getElement())) continue;
                diagramWithoutSemanticContenxtOwnerInSelection.add(diagram);
            }
        }
        return diagramWithoutSemanticContenxtOwnerInSelection;
    }

    protected class DiagramClipboardAdditionalData
    implements IClipboardAdditionalData {
        protected Collection<Diagram> diagrams;
        private Map<Diagram, Diagram> sourceVSCopy = new HashMap<Diagram, Diagram>();

        public DiagramClipboardAdditionalData(Collection<Diagram> diagrams, Map<? extends EObject, ? extends EObject> alreadyCopied) {
            this.diagrams = this.duplicateDiagrams(diagrams, alreadyCopied);
            this.sourceVSCopy = this.createDuplicatedDiagrams(diagrams, alreadyCopied);
        }

        @Deprecated
        public Collection<Diagram> getDuplicatedDiagrams(Map<? extends EObject, ? extends EObject> alreadyCopied) {
            return this.duplicateDiagrams(this.diagrams, alreadyCopied);
        }

        public Map<Diagram, Diagram> getDuplicatedDiagramsMap(Map<? extends EObject, ? extends EObject> alreadyCopied) {
            return this.createDuplicatedDiagrams(this.sourceVSCopy.keySet(), alreadyCopied);
        }

        @Deprecated
        protected Collection<Diagram> duplicateDiagrams(Collection<Diagram> diagrams, Map<? extends EObject, ? extends EObject> alreadyCopied) {
            ArrayList<Diagram> duplicatedDiagrams = new ArrayList<Diagram>();
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.putAll(alreadyCopied);
            for (Diagram diagram : diagrams) {
                copier.copy((EObject)diagram);
                EObject copy = (EObject)copier.get((Object)diagram);
                if (!(copy instanceof Diagram)) continue;
                duplicatedDiagrams.add((Diagram)copy);
            }
            return duplicatedDiagrams;
        }

        /*
         * WARNING - void declaration
         */
        protected Map<Diagram, Diagram> createDuplicatedDiagrams(Collection<Diagram> diagrams, Map<? extends EObject, ? extends EObject> alreadyCopied) {
            HashMap<Diagram, Diagram> sourceVSCopy = new HashMap<Diagram, Diagram>();
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.putAll(alreadyCopied);
            for (Diagram diagram : diagrams) {
                void tmpDiag;
                EObject copy;
                copier.copy((EObject)diagram);
                EObject eObject = copy = (EObject)copier.get((Object)diagram);
                if (!(eObject instanceof Diagram)) continue;
                Diagram cfr_ignored_0 = (Diagram)eObject;
                Diagram cfr_ignored_1 = (Diagram)eObject;
                sourceVSCopy.put(diagram, (Diagram)tmpDiag);
            }
            return sourceVSCopy;
        }
    }
}

